/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public abstract class DataDrivenValue
implements IDataDrivenRuntimeObject {
    protected static final String ILLEGAL_STATE_EXCEPTION_MESSAGE = "The state system hasn't been initialized yet";
    private final @Nullable String fMappingGroupId;
    private final ITmfStateValue.Type fForcedType;

    public DataDrivenValue(@Nullable String mappingGroupId, ITmfStateValue.Type forcedType) {
        this.fMappingGroupId = mappingGroupId;
        this.fForcedType = forcedType;
    }

    protected abstract @Nullable Object resolveValue(int var1, IAnalysisDataContainer var2);

    protected abstract @Nullable Object resolveValue(ITmfEvent var1, int var2, DataDrivenScenarioInfo var3, IAnalysisDataContainer var4);

    public final @Nullable Object getValue(@Nullable ITmfEvent event, int baseQuark, @Nullable DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        Object resolvedValue = null;
        if (event == null && scenarioInfo == null) {
            resolvedValue = this.resolveValue(baseQuark, container);
        } else {
            if (event == null || scenarioInfo == null) {
                throw new NullPointerException("event and scenarioInfo should not be null. Yet one of them is...");
            }
            resolvedValue = this.resolveValue(event, baseQuark, scenarioInfo, container);
        }
        if (this.fMappingGroupId != null) {
            DataDrivenMappingGroup mappingGroup = container.getMappingGroup(this.fMappingGroupId);
            resolvedValue = mappingGroup.map(event, baseQuark, scenarioInfo, container, resolvedValue);
        }
        if (this.fForcedType != ITmfStateValue.Type.NULL) {
            resolvedValue = TmfXmlUtils.newTmfStateValueFromObjectWithForcedType(resolvedValue, this.fForcedType).unboxValue();
        }
        return resolvedValue;
    }

    public String toString() {
        return "TmfXmlValue: " + this.getClass().getSimpleName();
    }

    public int hashCode() {
        return Objects.hash(this.fMappingGroupId, this.fForcedType);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DataDrivenValue)) {
            return false;
        }
        DataDrivenValue other = (DataDrivenValue)obj;
        return Objects.equals(this.fMappingGroupId, other.fMappingGroupId) && Objects.equals(this.fForcedType, other.fForcedType);
    }
}

