/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NonNullByDefault(value={})
public class HTIntervalObjectReadWriteTest {
    private Object fTestObject;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object[] array = new Object[]{String.valueOf("Hello")};
        list.add(array);
        array = new Object[]{new TestObject("Test", 0)};
        list.add(array);
        return list;
    }

    public HTIntervalObjectReadWriteTest(Object obj) {
        this.fTestObject = obj;
    }

    @Test
    public void testHtInterval() throws IOException {
        HTInterval interval = new HTInterval(0L, 10L, 1, this.fTestObject);
        HTIntervalObjectReadWriteTest.writeAndReadInterval(interval);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeAndReadInterval(HTInterval interval) throws IOException {
        HTInterval readInterval;
        block27: {
            Throwable throwable;
            File tempFile;
            int sizeOnDisk;
            block25: {
                sizeOnDisk = interval.getSizeOnDisk();
                tempFile = File.createTempFile("test-interval", ".interval");
                Throwable throwable2 = null;
                throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(tempFile, false);
                    try {
                        try (FileChannel fc = fos.getChannel();){
                            ByteBuffer bb = ByteBuffer.allocate(sizeOnDisk);
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                            bb.clear();
                            interval.writeInterval(bb, 1L);
                            bb.flip();
                            int written = fc.write(bb);
                            Assert.assertEquals((long)sizeOnDisk, (long)written);
                        }
                        if (fos == null) break block25;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (fos == null) throw throwable2;
                        fos.close();
                        throw throwable2;
                    }
                    fos.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            throwable = null;
            Object var5_9 = null;
            try {
                FileInputStream fis = new FileInputStream(tempFile);
                try {
                    try (FileChannel fc = fis.getChannel();){
                        ByteBuffer bb = ByteBuffer.allocate(sizeOnDisk);
                        bb.order(ByteOrder.LITTLE_ENDIAN);
                        bb.clear();
                        int read = fc.read(bb);
                        Assert.assertEquals((long)sizeOnDisk, (long)read);
                        bb.flip();
                        readInterval = HTInterval.readFrom((ByteBuffer)bb, (long)1L);
                    }
                    if (fis == null) break block27;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        Assert.assertEquals((Object)interval.toString(), (Object)readInterval.toString());
    }

    private static class TestObject {
        private final String fName;
        private final int fId;

        private TestObject(String name, int id) {
            this.fName = name;
            this.fId = id;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.fName).append(this.fId);
            return b.toString();
        }
    }
}

