/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.eventdensity;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Test;

public class EventDensityViewTest
extends XYDataProviderBaseTest {
    private static final @NonNull String TRACE_NAME = "kernel_vm";
    private static final @NonNull String TOTAL_NAME = "Total";
    private static final @NonNull String EVENT_DENSITY_VIEW_TITLE = "Event Density View";
    private static final @NonNull String MAIN_SERIES_NAME = "kernel_vm/Ungrouped/total";
    private static final @NonNull String EVENT_DENSITY_VIEW_ID = "org.eclipse.tracecompass.tmf.ui.views.eventdensity";

    @Test
    public void testManipulatingTreeViewer() {
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        SWTBot swtBot = this.getSWTBotView().bot();
        SWTBotTree treeBot = swtBot.tree();
        WaitUtils.waitUntil(tree -> tree.rowCount() >= 1, (Object)treeBot, (String)"The tree viewer did not finish loading.");
        SWTBotTreeItem root = treeBot.getTreeItem(TRACE_NAME);
        Assert.assertNotNull((Object)root);
        SWTBotTreeItem totalItem = SWTBotUtils.getTreeItem(swtBot, root, TOTAL_NAME);
        Assert.assertNotNull((Object)totalItem);
        WaitUtils.waitUntil(SWTBotTreeItem::isChecked, (Object)totalItem, (String)"Total entry was not checked");
        Assert.assertTrue((boolean)totalItem.isChecked());
        Assert.assertFalse((boolean)root.isGrayed());
        Assert.assertFalse((boolean)totalItem.isGrayed());
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 1, (Object)chart, (String)"The data series did not load.");
        totalItem.uncheck();
        Assert.assertFalse((boolean)root.isChecked());
        Assert.assertFalse((boolean)totalItem.isChecked());
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length == 0, (Object)chart, (String)"A data series has not been removed.");
    }

    @Override
    protected @NonNull String getMainSeriesName() {
        return MAIN_SERIES_NAME;
    }

    @Override
    protected @NonNull String getTitle() {
        return EVENT_DENSITY_VIEW_TITLE;
    }

    @Override
    protected String getViewID() {
        return EVENT_DENSITY_VIEW_ID;
    }

    @Override
    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.KERNEL_VM);
    }

    @Override
    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.KERNEL_VM);
    }
}

