/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.config;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.config.XmlConfigurationSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSource;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceManager;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class XmlConfigurationSourceTest {
    private static final String UNKNOWN_TYPE = "test-test-test";
    private static final String XML_ANALYSIS_TYPE_ID = "org.eclipse.tracecompass.tmf.core.config.xmlsourcetype";
    private static final Path PATH_INVALID = new Path("test_xml_files/test_invalid");
    private static final Path PATH_VALID = new Path("test_xml_files/test_valid");
    private static String VALID_NAME = "kvm_exits";
    private static String VALID_XML_FILE = VALID_NAME + ".xml";
    private static String INVALID_XML_FILE = "invalid_condition_operators.xml";
    private static String PATH_TO_INVALID_FILE = XmlConfigurationSourceTest.getPath(PATH_INVALID, INVALID_XML_FILE);
    private static String PATH_TO_VALID_FILE = XmlConfigurationSourceTest.getPath(PATH_VALID, VALID_XML_FILE);
    private static String PATH_TO_VALID_FILE2 = XmlConfigurationSourceTest.getPath(PATH_VALID, "state_provider_placement.xml");
    private static final String EXPECTED_TYPE_NAME = "XML Data-driven analyses";
    private static final String EXPECTED_TYPE_DESCRIPTION = "Data-driven analyses described in XML";
    private static final String EXPECTED_KEY_NAME = "path";
    private static final String EXPECTED_PARAM_DESCRIPTION = "URI to XML analysis file";
    private static final String EXPECTED_DATA_TYPE = "STRING";
    private static final String EXPECTED_CONFIG_NAME = VALID_NAME;
    private static final String EXPECTED_CONFIG_ID = VALID_XML_FILE;
    private static final String EXPECTED_CONFIG_DESCRIPTION = "XML Data-driven analysis: " + VALID_NAME;
    private static Map<String, Object> VALID_PARAM = ImmutableMap.of((Object)"path", (Object)PATH_TO_VALID_FILE);
    private static Map<String, Object> VALID_PARAM2 = ImmutableMap.of((Object)"path", (Object)PATH_TO_VALID_FILE2);
    private static Map<String, Object> INVALID_PARAM = ImmutableMap.of((Object)"path", (Object)PATH_TO_INVALID_FILE);
    private static final String EXPECTED_MESSAGE_NO_PATH = "Missing path";
    private static final String EXPECTED_MESSAGE_FILE_NOT_FOUND = "An error occurred while validating the XML file.";
    private static final String EXPECTED_MESSAGE_INVALID_CONFIG = "No such configuration with ID: test-test-test";
    private static final String EXPECTED_MESSAGE_FILE_MISMATCH = "File mismatch";
    private static ITmfConfigurationSource sfXmlConfigSource;
    private static TmfConfigurationSourceManager sfInstance;

    @BeforeClass
    public static void init() {
        sfInstance = TmfConfigurationSourceManager.getInstance();
        Assert.assertNotNull((Object)sfInstance);
        sfXmlConfigSource = sfInstance.getConfigurationSource(XML_ANALYSIS_TYPE_ID);
        Assert.assertNotNull((Object)sfXmlConfigSource);
    }

    @After
    public void emptyXmlFolder() {
        Iterator iter = sfXmlConfigSource.getConfigurations().iterator();
        while (iter.hasNext()) {
            sfXmlConfigSource.remove(((ITmfConfiguration)iter.next()).getId());
        }
        File fFolder = XmlUtils.getXmlFilesPath().toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            xmlFile.delete();
            ++n2;
        }
    }

    @Test
    public void testConstructor() throws TmfConfigurationException {
        ITmfConfiguration config = sfXmlConfigSource.create(VALID_PARAM);
        XmlConfigurationSource instance = new XmlConfigurationSource();
        List configurations = instance.getConfigurations();
        Assert.assertTrue((boolean)configurations.contains(config));
    }

    @Test
    public void testSourceType() {
        ITmfConfigurationSourceType type = sfXmlConfigSource.getConfigurationSourceType();
        Assert.assertEquals((Object)XML_ANALYSIS_TYPE_ID, (Object)type.getId());
        Assert.assertEquals((Object)EXPECTED_TYPE_NAME, (Object)type.getName());
        Assert.assertEquals((Object)EXPECTED_TYPE_DESCRIPTION, (Object)type.getDescription());
        List descriptors = type.getConfigParamDescriptors();
        Assert.assertNotNull((Object)descriptors);
        Assert.assertEquals((long)1L, (long)descriptors.size());
        ITmfConfigParamDescriptor desc = (ITmfConfigParamDescriptor)descriptors.get(0);
        Assert.assertEquals((Object)EXPECTED_KEY_NAME, (Object)desc.getKeyName());
        Assert.assertEquals((Object)EXPECTED_DATA_TYPE, (Object)desc.getDataType());
        Assert.assertEquals((Object)EXPECTED_PARAM_DESCRIPTION, (Object)desc.getDescription());
        Assert.assertTrue((boolean)desc.isRequired());
    }

    @Test
    public void testCreation() {
        ImmutableMap param = Collections.emptyMap();
        try {
            sfXmlConfigSource.create(param);
        }
        catch (TmfConfigurationException e) {
            Assert.assertEquals((Object)EXPECTED_MESSAGE_NO_PATH, (Object)e.getMessage());
        }
        param = ImmutableMap.of((Object)EXPECTED_KEY_NAME, (Object)XmlUtils.getXmlFilesPath().append(UNKNOWN_TYPE).toOSString());
        try {
            sfXmlConfigSource.create((Map)param);
        }
        catch (TmfConfigurationException e) {
            Assert.assertEquals((Object)EXPECTED_MESSAGE_FILE_NOT_FOUND, (Object)e.getMessage());
        }
        try {
            sfXmlConfigSource.create(INVALID_PARAM);
        }
        catch (TmfConfigurationException e) {
            // empty catch block
        }
        try {
            ITmfConfiguration config = sfXmlConfigSource.create(VALID_PARAM);
            XmlConfigurationSourceTest.validateConfig(PATH_TO_VALID_FILE, config);
        }
        catch (TmfConfigurationException e) {
            Assert.fail();
        }
    }

    @Test
    public void testUpdate() {
        ITmfConfiguration config = XmlConfigurationSourceTest.createConfig(PATH_TO_VALID_FILE);
        Assert.assertNotNull((Object)config);
        ImmutableMap param = Collections.emptyMap();
        try {
            sfXmlConfigSource.update(config.getId(), param);
        }
        catch (TmfConfigurationException e) {
            Assert.assertEquals((Object)EXPECTED_MESSAGE_NO_PATH, (Object)e.getMessage());
        }
        try {
            sfXmlConfigSource.update(UNKNOWN_TYPE, param);
        }
        catch (TmfConfigurationException e) {
            Assert.assertEquals((Object)EXPECTED_MESSAGE_INVALID_CONFIG, (Object)e.getMessage());
        }
        param = ImmutableMap.of((Object)EXPECTED_KEY_NAME, (Object)XmlUtils.getXmlFilesPath().append(UNKNOWN_TYPE).toOSString());
        try {
            sfXmlConfigSource.update(config.getId(), (Map)param);
        }
        catch (TmfConfigurationException e) {
            Assert.assertEquals((Object)EXPECTED_MESSAGE_FILE_NOT_FOUND, (Object)e.getMessage());
        }
        try {
            sfXmlConfigSource.update(EXPECTED_CONFIG_ID, INVALID_PARAM);
        }
        catch (TmfConfigurationException e) {
            // empty catch block
        }
        try {
            sfXmlConfigSource.update(config.getId(), VALID_PARAM2);
        }
        catch (TmfConfigurationException e) {
            Assert.assertEquals((Object)EXPECTED_MESSAGE_FILE_MISMATCH, (Object)e.getMessage());
        }
        try {
            ITmfConfiguration configUpdated = sfXmlConfigSource.update(config.getId(), VALID_PARAM);
            XmlConfigurationSourceTest.validateConfig(PATH_TO_VALID_FILE, configUpdated);
        }
        catch (TmfConfigurationException e) {
            Assert.fail();
        }
    }

    @Test
    public void testContains() {
        XmlConfigurationSourceTest.createConfig(PATH_TO_VALID_FILE);
        Assert.assertTrue((boolean)sfXmlConfigSource.contains(EXPECTED_CONFIG_ID));
        Assert.assertFalse((boolean)sfXmlConfigSource.contains(UNKNOWN_TYPE));
    }

    @Test
    public void testRemove() {
        XmlConfigurationSourceTest.createConfig(PATH_TO_VALID_FILE);
        ITmfConfiguration config = sfXmlConfigSource.remove(UNKNOWN_TYPE);
        Assert.assertNull((Object)config);
        config = sfXmlConfigSource.remove(EXPECTED_CONFIG_ID);
        XmlConfigurationSourceTest.validateConfig(PATH_TO_VALID_FILE, config);
    }

    @Test
    public void testGetConfiguration() {
        List configurations = sfXmlConfigSource.getConfigurations();
        Assert.assertTrue((boolean)configurations.isEmpty());
        ITmfConfiguration config = XmlConfigurationSourceTest.createConfig(PATH_TO_VALID_FILE);
        Assert.assertNotNull((Object)config);
        configurations = sfXmlConfigSource.getConfigurations();
        Assert.assertFalse((boolean)configurations.isEmpty());
        Assert.assertTrue((boolean)configurations.contains(config));
    }

    private static ITmfConfiguration createConfig(String path) {
        ImmutableMap param = ImmutableMap.of((Object)EXPECTED_KEY_NAME, (Object)path);
        try {
            return sfXmlConfigSource.create((Map)param);
        }
        catch (TmfConfigurationException tmfConfigurationException) {
            return null;
        }
    }

    private static void validateConfig(String path, ITmfConfiguration config) {
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)EXPECTED_CONFIG_NAME, (Object)config.getName());
        Assert.assertEquals((Object)EXPECTED_CONFIG_ID, (Object)config.getId());
        Assert.assertEquals((Object)XML_ANALYSIS_TYPE_ID, (Object)config.getSourceTypeId());
        Assert.assertEquals((Object)EXPECTED_CONFIG_DESCRIPTION, (Object)config.getDescription());
        Assert.assertTrue((boolean)config.getParameters().isEmpty());
    }

    private static String getPath(Path folder, String name) {
        IPath path = Activator.getAbsolutePath(folder).append(name);
        File file = path.toFile();
        Assert.assertTrue((boolean)file.exists());
        return Objects.requireNonNull(file.getAbsolutePath());
    }
}

