/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IBaseQuarkProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenStateSystemPath
implements IDataDrivenRuntimeObject {
    private final List<DataDrivenValue> fAttributes;
    private final IBaseQuarkProvider fQuarkProvider;

    public DataDrivenStateSystemPath(List<DataDrivenValue> attributes) {
        this(attributes, IBaseQuarkProvider.IDENTITY_BASE_QUARK);
    }

    public DataDrivenStateSystemPath(List<DataDrivenValue> attributes, IBaseQuarkProvider quarkProvider) {
        this.fAttributes = attributes;
        this.fQuarkProvider = quarkProvider;
    }

    public int getQuark(@Nullable ITmfEvent event, int baseQuark, @Nullable DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        int quark = this.fQuarkProvider.getBaseQuark(baseQuark, scenarioInfo);
        for (DataDrivenValue val : this.fAttributes) {
            Object value = val.getValue(event, quark, scenarioInfo, container);
            if (value == null) {
                Activator.logWarning("StateChange.handleEvent: A value is null: " + String.valueOf(val));
                return -2;
            }
            if ((quark = container.getQuarkRelativeAndAdd(quark, String.valueOf(value))) >= 0) continue;
            Activator.logWarning("The attribute quark is invalid for event " + String.valueOf(event) + ": " + String.valueOf(this.fAttributes));
            break;
        }
        return quark;
    }

    public int getQuark(int baseQuark, IAnalysisDataContainer container) {
        int quark = this.fQuarkProvider.getBaseQuark(baseQuark, null);
        for (DataDrivenValue val : this.fAttributes) {
            Object value = val.getValue(null, quark, null, container);
            if (value == null) {
                Activator.logWarning("State system path, a value is null for " + String.valueOf(val) + " from quark " + quark);
                return -2;
            }
            ITmfStateSystem stateSystem = container.getStateSystem();
            if ((quark = stateSystem.optQuarkRelative(quark, new String[]{String.valueOf(value)})) >= 0) continue;
            Activator.logWarning("The attribute quark is invalid: " + String.valueOf(this.fAttributes));
            break;
        }
        return quark;
    }

    public String toString() {
        return "DataDrivenStateSystemPath: " + String.valueOf(this.fAttributes);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fAttributes, this.fQuarkProvider);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DataDrivenStateSystemPath)) {
            return false;
        }
        DataDrivenStateSystemPath other = (DataDrivenStateSystemPath)obj;
        return Objects.equals(this.fAttributes, other.fAttributes) && Objects.equals(this.fQuarkProvider, other.fQuarkProvider);
    }
}

