/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlActionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlFsmStateCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenPatternEventHandler;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlPatternEventHandlerCu
implements IDataDrivenCompilationUnit {
    private List<TmfXmlFsmStateCu.TmfXmlFsmCu> fFsms;
    private List<String> fInitials;

    private TmfXmlPatternEventHandlerCu(List<TmfXmlFsmStateCu.TmfXmlFsmCu> fsms, List<String> initials) {
        this.fFsms = fsms;
        this.fInitials = initials;
    }

    @Override
    public DataDrivenPatternEventHandler generate() {
        Map<String, DataDrivenFsm> fsms = this.fFsms.stream().map(TmfXmlFsmStateCu.TmfXmlFsmCu::generate).collect(Collectors.toMap(DataDrivenFsmState::getId, fsm -> fsm));
        ArrayList<DataDrivenFsm> initials = new ArrayList<DataDrivenFsm>();
        for (String initial : this.fInitials) {
            initials.add(Objects.requireNonNull(fsms.get(initial)));
        }
        return new DataDrivenPatternEventHandler(fsms.values(), initials);
    }

    public static @Nullable TmfXmlPatternEventHandlerCu compile(AnalysisCompilationData analysisData, Element element) {
        Object action;
        List<Element> elements = TmfXmlUtils.getChildElements(element, "test");
        for (Element testElement : elements) {
            TmfXmlConditionCu test = TmfXmlConditionCu.compileNamedCondition(analysisData, testElement);
            if (test != null) continue;
            return null;
        }
        elements = TmfXmlUtils.getChildElements(element, "action");
        for (Element actionElement : elements) {
            action = TmfXmlActionCu.compileNamedAction(analysisData, actionElement);
            if (action != null) continue;
            return null;
        }
        elements = TmfXmlUtils.getChildElements(element, "action");
        for (Element actionElement : elements) {
            action = TmfXmlActionCu.compileNamedAction(analysisData, actionElement);
            if (action != null) continue;
            return null;
        }
        ArrayList<TmfXmlFsmStateCu.TmfXmlFsmCu> fsms = new ArrayList<TmfXmlFsmStateCu.TmfXmlFsmCu>();
        elements = TmfXmlUtils.getChildElements(element, "fsm");
        for (Element fsmElement : elements) {
            TmfXmlFsmStateCu.TmfXmlFsmCu fsm = TmfXmlFsmStateCu.compileFsm(analysisData, fsmElement);
            if (fsm == null) {
                return null;
            }
            fsms.add(fsm);
        }
        String initialFsm = element.getAttribute("initial");
        ArrayList<String> initials = new ArrayList<String>();
        if (!initialFsm.isEmpty()) {
            String[] stringArray = initialFsm.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String initial = stringArray[n2];
                TmfXmlFsmStateCu fsm = analysisData.getFsm(initial);
                if (fsm == null) {
                    Activator.logError("XML pattern handler: Undefined initial FSM: " + initial);
                    return null;
                }
                initials.add(initial);
                ++n2;
            }
        }
        return new TmfXmlPatternEventHandlerCu(fsms, initials);
    }
}

