/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model;

import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceCoreUtils;
import org.junit.Assert;
import org.junit.Test;

public class TmfTraceCoreUtilsTest {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
    private static final char BACKSLASH_PUA = '\uf05c';
    private static final char COLON_PUA = '\uf03a';

    @Test
    public void testValidateName() {
        if (IS_WINDOWS) {
            Assert.assertEquals((Object)"myName", (Object)TmfTraceCoreUtils.validateName((String)"myName"));
            Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName_"));
            Assert.assertEquals((Object)"my Name", (Object)TmfTraceCoreUtils.validateName((String)"my Name"));
            Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my\\Name"));
            Assert.assertEquals((Object)"_", (Object)TmfTraceCoreUtils.validateName((String)"."));
            Assert.assertEquals((Object)"._", (Object)TmfTraceCoreUtils.validateName((String)".."));
            Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName:"));
            Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my/Name"));
            Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my\\Name"));
            Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my/Name"));
            Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName."));
            Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName*"));
            Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName>"));
            Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName<"));
            Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my?Name"));
            Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my\"Name"));
            Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my|Name"));
            Assert.assertEquals((Object)"_com1", (Object)TmfTraceCoreUtils.validateName((String)"com1"));
            Assert.assertEquals((Object)"_clock$", (Object)TmfTraceCoreUtils.validateName((String)"clock$"));
            return;
        }
        Assert.assertEquals((Object)"myName", (Object)TmfTraceCoreUtils.validateName((String)"myName"));
        Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName_"));
        Assert.assertEquals((Object)"my\\ Name", (Object)TmfTraceCoreUtils.validateName((String)"my\\ Name"));
        Assert.assertEquals((Object)"_.", (Object)TmfTraceCoreUtils.validateName((String)"."));
        Assert.assertEquals((Object)"_..", (Object)TmfTraceCoreUtils.validateName((String)".."));
        Assert.assertEquals((Object)"myName_", (Object)TmfTraceCoreUtils.validateName((String)"myName\u0000"));
        Assert.assertEquals((Object)"my_Name", (Object)TmfTraceCoreUtils.validateName((String)"my/Name"));
    }

    public void testSafePath() {
        String path1 = "my:name:is/santa";
        Path safePath1 = TmfTraceCoreUtilsTest.newSafePath(path1);
        Assert.assertEquals((Object)safePath1.toPortableString(), (Object)TmfTraceCoreUtils.newSafePath((String)path1).toPortableString());
        String path2 = "my\\name\\is/santa";
        Path safePath2 = TmfTraceCoreUtilsTest.newSafePath(path2);
        Assert.assertEquals((Object)safePath2.toPortableString(), (Object)TmfTraceCoreUtils.newSafePath((String)path2).toPortableString());
        Assert.assertEquals((Object)path1, (Object)TmfTraceCoreUtils.safePathToString((String)safePath1.toPortableString()));
        Assert.assertEquals((Object)path2, (Object)TmfTraceCoreUtils.safePathToString((String)safePath2.toPortableString()));
    }

    private static Path newSafePath(String path) {
        return new Path(path.replace('\\', '\uf05c').replace(':', '\uf03a'));
    }
}

