/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.views.messageflow;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messageflow.Ros2MessageFlowAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messageflow.Ros2MessageFlowDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.AbstractRos2DataProviderTimeGraphView;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.Ros2HideInternalObjectsAction;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.Ros2ObjectTreeLabelProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.messageflow.Ros2MessageFlowPresentationProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;

public class Ros2MessageFlowView
extends AbstractRos2DataProviderTimeGraphView {
    private static final String ID_SUFFIX = ".messageflow";

    public Ros2MessageFlowView() {
        super(Ros2MessageFlowView.getFullViewId(), new Ros2MessageFlowPresentationProvider(), Ros2MessageFlowDataProvider.getFullDataProviderId());
        this.setTreeColumns(Ros2ObjectTreeLabelProvider.TREE_COLUMNS);
        this.setTreeLabelProvider(new Ros2MessageFlowTreeLabelProvider());
        this.setFilterColumns(Ros2ObjectTreeLabelProvider.TREE_COLUMNS);
        this.setFilterLabelProvider(new Ros2MessageFlowTreeLabelProvider());
    }

    public static @NonNull String getFullViewId() {
        return AbstractRos2DataProviderTimeGraphView.getViewIdFromSuffix(ID_SUFFIX);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        IDialogSettings settings = Objects.requireNonNull(Activator.getDefault()).getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        Action hideArrowsAction = this.getTimeGraphViewer().getHideArrowsAction(section);
        manager.appendToGroup("additions", (IAction)hideArrowsAction);
        Ros2HideInternalObjectsAction hideInternalAction = new Ros2HideInternalObjectsAction(this.getTimeGraphViewer());
        manager.appendToGroup("additions", (IAction)hideInternalAction);
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @TmfSignalHandler
    public void analysisStarted(TmfStartAnalysisSignal signal) {
        IAnalysisModule analysis = signal.getAnalysisModule();
        if (analysis instanceof Ros2MessageFlowAnalysis) {
            final Ros2MessageFlowAnalysis messageFlowAnalysis = (Ros2MessageFlowAnalysis)analysis;
            new Thread(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @Override
                public void run() {
                    @NonNull Collection traces = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)Ros2MessageFlowView.this.getTrace());
                    if (traces.contains(messageFlowAnalysis.getTrace()) && messageFlowAnalysis.waitForCompletion()) {
                        Ros2MessageFlowView.this.rebuild();
                    }
                }
            }.start();
        }
    }

    private class Ros2MessageFlowTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private Ros2MessageFlowTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return Ros2ObjectTreeLabelProvider.getColumnText(element, columnIndex);
        }
    }
}

