/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.tcp;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.tcp.TCPEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;

public class TCPPacket
extends Packet {
    private final @Nullable Packet fChildPacket;
    private final @Nullable ByteBuffer fPayload;
    private final int fSourcePort;
    private final int fDestinationPort;
    private final long fSequenceNumber;
    private final long fAcknowledgmentNumber;
    private final int fDataOffset;
    private final byte fReservedField;
    private final boolean fNSFlag;
    private final boolean fCWRFlag;
    private final boolean fECEFlag;
    private final boolean fURGFlag;
    private final boolean fACKFlag;
    private final boolean fPSHFlag;
    private final boolean fRSTFlag;
    private final boolean fSYNFlag;
    private final boolean fFINFlag;
    private final int fWindowSize;
    private final int fChecksum;
    private final int fUrgentPointer;
    private final byte @Nullable [] fOptions;
    private @Nullable TCPEndpoint fSourceEndpoint = null;
    private @Nullable TCPEndpoint fDestinationEndpoint = null;
    private @Nullable Map<String, String> fFields = null;

    public TCPPacket(PcapFile file, @Nullable Packet parent, ByteBuffer packet) throws BadPacketException {
        super(file, parent, PcapProtocol.TCP);
        packet.order(ByteOrder.BIG_ENDIAN);
        packet.position(0);
        this.fSourcePort = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fDestinationPort = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fSequenceNumber = ConversionHelper.unsignedIntToLong(packet.getInt());
        this.fAcknowledgmentNumber = ConversionHelper.unsignedIntToLong(packet.getInt());
        byte storage = packet.get();
        this.fDataOffset = (storage & 0xF0) >>> 4 & 0xFF;
        this.fReservedField = (byte)((storage & 0xE) >>> 1);
        this.fNSFlag = TCPPacket.isBitSet(storage, 0);
        storage = packet.get();
        this.fCWRFlag = TCPPacket.isBitSet(storage, 7);
        this.fECEFlag = TCPPacket.isBitSet(storage, 6);
        this.fURGFlag = TCPPacket.isBitSet(storage, 5);
        this.fACKFlag = TCPPacket.isBitSet(storage, 4);
        this.fPSHFlag = TCPPacket.isBitSet(storage, 3);
        this.fRSTFlag = TCPPacket.isBitSet(storage, 2);
        this.fSYNFlag = TCPPacket.isBitSet(storage, 1);
        this.fFINFlag = TCPPacket.isBitSet(storage, 0);
        this.fWindowSize = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fChecksum = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fUrgentPointer = ConversionHelper.unsignedShortToInt(packet.getShort());
        if (this.fDataOffset > 5) {
            this.fOptions = new byte[(this.fDataOffset - 5) * 4];
            packet.get(this.fOptions);
        } else {
            this.fOptions = null;
        }
        if (packet.remaining() > 0) {
            ByteBuffer payload = packet.slice();
            payload.order(ByteOrder.BIG_ENDIAN);
            this.fPayload = payload;
        } else {
            this.fPayload = null;
        }
        this.fChildPacket = this.findChildPacket();
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        return this.fPayload;
    }

    @Override
    protected @Nullable Packet findChildPacket() throws BadPacketException {
        ByteBuffer payload = this.fPayload;
        if (payload == null) {
            return null;
        }
        return new UnknownPacket(this.getPcapFile(), (Packet)this, payload);
    }

    public String toString() {
        ByteBuffer payload = this.fPayload;
        int length = 0;
        if (payload != null) {
            length = payload.limit();
        }
        String flagString = "";
        String string = this.getProtocol().getName() + ", Source Port: " + this.fSourcePort + ", Destination Port: " + this.fDestinationPort + "\nSequence Number: " + this.fSequenceNumber + ", Acknowledgment Number: " + this.fAcknowledgmentNumber + "\nHeader length: " + this.fDataOffset * 4 + " bytes, Data length: " + length + "\n" + flagString + "Window size value: " + this.fWindowSize + ", Urgent Pointer: " + String.format("%s%04x", "0x", this.fUrgentPointer) + "\nChecksum: " + String.format("%s%04x", "0x", this.fChecksum) + "\n";
        Packet child = this.fChildPacket;
        if (child != null) {
            return string + child.toString();
        }
        return string;
    }

    public int getSourcePort() {
        return this.fSourcePort;
    }

    public int getDestinationPort() {
        return this.fDestinationPort;
    }

    public long getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public long getAcknowledgmentNumber() {
        return this.fAcknowledgmentNumber;
    }

    public int getDataOffset() {
        return this.fDataOffset;
    }

    public byte getReservedField() {
        return this.fReservedField;
    }

    public boolean isNSFlagSet() {
        return this.fNSFlag;
    }

    public boolean isCongestionWindowReducedFlagSet() {
        return this.fCWRFlag;
    }

    public boolean isECNEchoFlagSet() {
        return this.fECEFlag;
    }

    public boolean isUrgentFlagSet() {
        return this.fURGFlag;
    }

    public boolean isAcknowledgeFlagSet() {
        return this.fACKFlag;
    }

    public boolean isPushFlagSet() {
        return this.fPSHFlag;
    }

    public boolean isResetFlagSet() {
        return this.fRSTFlag;
    }

    public boolean isSynchronizationFlagSet() {
        return this.fSYNFlag;
    }

    public boolean isFinalFlagSet() {
        return this.fFINFlag;
    }

    public int getWindowSize() {
        return this.fWindowSize;
    }

    public int getChecksum() {
        return this.fChecksum;
    }

    public int getUrgentPointer() {
        return this.fUrgentPointer;
    }

    public byte @Nullable [] getOptions() {
        byte[] options = this.fOptions;
        if (options == null) {
            return null;
        }
        return Arrays.copyOf(options, options.length);
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public TCPEndpoint getSourceEndpoint() {
        @Nullable TCPEndpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new TCPEndpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public TCPEndpoint getDestinationEndpoint() {
        @Nullable TCPEndpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new TCPEndpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"Source Port", (Object)String.valueOf(this.fSourcePort)).put((Object)"Destination Port", (Object)String.valueOf(this.fDestinationPort)).put((Object)"Sequence Number", (Object)String.valueOf(this.fSequenceNumber)).put((Object)"Acknowledgement Number", (Object)String.valueOf(this.fAcknowledgmentNumber)).put((Object)"Length", (Object)(String.valueOf(this.fDataOffset * 4) + " bytes")).put((Object)"ECN-Nonce Flag", (Object)String.valueOf(this.fNSFlag)).put((Object)"Congestion Window Reduced Flag", (Object)String.valueOf(this.fCWRFlag)).put((Object)"ECN-Echo Flag", (Object)String.valueOf(this.fECEFlag)).put((Object)"Urgent Flag", (Object)String.valueOf(this.fURGFlag)).put((Object)"ACK Flag", (Object)String.valueOf(this.fACKFlag)).put((Object)"PSH Flag", (Object)String.valueOf(this.fPSHFlag)).put((Object)"RST Flag", (Object)String.valueOf(this.fRSTFlag)).put((Object)"SYN Flag", (Object)String.valueOf(this.fSYNFlag)).put((Object)"FIN Flag", (Object)String.valueOf(this.fFINFlag)).put((Object)"Window Size Value", (Object)String.valueOf(this.fWindowSize)).put((Object)"Checksum", (Object)String.format("%s%04x", "0x", this.fChecksum)).put((Object)"Urgent Pointer", (Object)String.format("%s%04x", "0x", this.fUrgentPointer));
            byte[] options = this.fOptions;
            if (options == null) {
                builder.put((Object)"Options", (Object)"");
            } else {
                builder.put((Object)"Options", (Object)ConversionHelper.bytesToHex(options, true));
            }
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Src Port: " + this.fSourcePort + ", Dst Port: " + this.fDestinationPort + ", Seq: " + this.fSequenceNumber + ", Ack: " + this.fAcknowledgmentNumber + ", Len: " + this.fDataOffset * 4;
    }

    @Override
    protected String getSignificationString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fSourcePort).append(" > ").append(this.fDestinationPort);
        if (!this.generateFlagString().equals("")) {
            sb.append(' ').append('[').append(this.generateFlagString()).append(']');
        }
        sb.append(" Seq=").append(this.fSequenceNumber);
        if (this.fACKFlag) {
            sb.append(" Ack=").append(this.fAcknowledgmentNumber);
        }
        sb.append(" Len=").append(this.fDataOffset * 4);
        return NonNullUtils.nullToEmptyString((Object)sb);
    }

    private String generateFlagString() {
        StringBuilder sb = new StringBuilder();
        boolean start = true;
        if (this.fSYNFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("SYN");
            start = false;
        }
        if (this.fACKFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("ACK");
            start = false;
        }
        if (this.fFINFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("FIN");
            start = false;
        }
        if (this.fRSTFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("RST");
            start = false;
        }
        if (this.fPSHFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("PSH");
            start = false;
        }
        if (this.fURGFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("URG");
            start = false;
        }
        if (this.fNSFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("NS");
            start = false;
        }
        if (this.fCWRFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("CWR");
            start = false;
        }
        if (this.fECEFlag) {
            if (!start) {
                sb.append(", ");
            }
            sb.append("ECE");
            start = false;
        }
        return NonNullUtils.nullToEmptyString((Object)sb);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fACKFlag ? 1231 : 1237);
        result = 31 * result + (int)(this.fAcknowledgmentNumber ^ this.fAcknowledgmentNumber >>> 32);
        result = 31 * result + (this.fCWRFlag ? 1231 : 1237);
        result = 31 * result + this.fChecksum;
        Packet child = this.fChildPacket;
        result = child != null ? 31 * result + child.hashCode() : (result *= 31);
        result = 31 * result + this.fDataOffset;
        result = 31 * result + this.fDestinationPort;
        result = 31 * result + (this.fECEFlag ? 1231 : 1237);
        result = 31 * result + (this.fFINFlag ? 1231 : 1237);
        result = 31 * result + (this.fNSFlag ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.fOptions);
        result = 31 * result + (this.fPSHFlag ? 1231 : 1237);
        if (child == null) {
            result = 31 * result + TCPPacket.payloadHashCode(this.fPayload);
        }
        result = 31 * result + (this.fRSTFlag ? 1231 : 1237);
        result = 31 * result + this.fReservedField;
        result = 31 * result + (this.fSYNFlag ? 1231 : 1237);
        result = 31 * result + (int)(this.fSequenceNumber ^ this.fSequenceNumber >>> 32);
        result = 31 * result + this.fSourcePort;
        result = 31 * result + (this.fURGFlag ? 1231 : 1237);
        result = 31 * result + this.fUrgentPointer;
        result = 31 * result + this.fWindowSize;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCPPacket other = (TCPPacket)obj;
        if (this.fACKFlag != other.fACKFlag) {
            return false;
        }
        if (this.fAcknowledgmentNumber != other.fAcknowledgmentNumber) {
            return false;
        }
        if (this.fCWRFlag != other.fCWRFlag) {
            return false;
        }
        if (this.fChecksum != other.fChecksum) {
            return false;
        }
        if (!Objects.equals(this.fChildPacket, other.fChildPacket)) {
            return false;
        }
        if (this.fDataOffset != other.fDataOffset) {
            return false;
        }
        if (this.fDestinationPort != other.fDestinationPort) {
            return false;
        }
        if (this.fECEFlag != other.fECEFlag) {
            return false;
        }
        if (this.fFINFlag != other.fFINFlag) {
            return false;
        }
        if (this.fNSFlag != other.fNSFlag) {
            return false;
        }
        if (!Arrays.equals(this.fOptions, other.fOptions)) {
            return false;
        }
        if (this.fPSHFlag != other.fPSHFlag) {
            return false;
        }
        if (this.fChildPacket == null && !TCPPacket.payloadEquals(this.fPayload, other.fPayload)) {
            return false;
        }
        if (this.fRSTFlag != other.fRSTFlag) {
            return false;
        }
        if (this.fReservedField != other.fReservedField) {
            return false;
        }
        if (this.fSYNFlag != other.fSYNFlag) {
            return false;
        }
        if (this.fSequenceNumber != other.fSequenceNumber) {
            return false;
        }
        if (this.fSourcePort != other.fSourcePort) {
            return false;
        }
        if (this.fURGFlag != other.fURGFlag) {
            return false;
        }
        if (this.fUrgentPointer != other.fUrgentPointer) {
            return false;
        }
        return this.fWindowSize == other.fWindowSize;
    }
}

