/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.reflect.Field;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.Requestor;

public class FieldRequestor
extends Requestor<Field> {
    public FieldRequestor(Field field, IInjector injector, PrimaryObjectSupplier primarySupplier, PrimaryObjectSupplier tempSupplier, Object requestingObject, boolean track) {
        super(field, injector, primarySupplier, tempSupplier, requestingObject, track);
    }

    @Override
    public Object execute() throws InjectionException {
        if (this.actualArgs == null) {
            return null;
        }
        this.setField((Field)this.location, this.actualArgs[0]);
        this.clearResolvedArgs();
        return null;
    }

    @Override
    protected IObjectDescriptor[] calcDependentObjects() {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor(((Field)this.location).getGenericType(), ((Field)this.location).getAnnotations());
        return new IObjectDescriptor[]{objectDescriptor};
    }

    private boolean setField(Field field, Object value) throws InjectionException {
        Object userObject = this.getRequestingObject();
        if (userObject == null) {
            return false;
        }
        try {
            field.trySetAccessible();
            field.set(userObject, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new InjectionException(e);
        }
        return true;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        Object object = this.getRequestingObject();
        if (object != null) {
            tmp.append(object.getClass().getSimpleName());
        }
        tmp.append('.');
        tmp.append(((Field)this.location).getName());
        return tmp.toString();
    }
}

