/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTName
extends CPPASTNameBase
implements ICPPASTCompletionContext {
    public static final IASTName NOT_INITIALIZED = new CPPASTName(null);
    private char[] name;

    public CPPASTName(char[] name) {
        this.name = name;
    }

    public CPPASTName() {
        this.name = CharArrayUtils.EMPTY;
    }

    @Override
    public CPPASTName copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTName copy(IASTNode.CopyStyle style) {
        CPPASTName copy = new CPPASTName(this.name == null ? null : (char[])this.name.clone());
        return this.copy(copy, style);
    }

    @Override
    protected IBinding createIntermediateBinding() {
        CPPSemantics.pushLookupPoint(this);
        try {
            IBinding iBinding = CPPVisitor.createBinding(this);
            return iBinding;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    @Override
    public IASTCompletionContext getCompletionContext() {
        IASTNode node = this.getParent();
        while (node != null) {
            if (node instanceof IASTCompletionContext) {
                return (IASTCompletionContext)((Object)node);
            }
            node = node.getParent();
        }
        if (this.getLength() > 0) {
            return this;
        }
        return null;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IASTNode parent = this.getParent();
        if (parent instanceof ICPPASTElaboratedTypeSpecifier) {
            ICPPASTElaboratedTypeSpecifier specifier = (ICPPASTElaboratedTypeSpecifier)parent;
            int kind = specifier.getKind();
            switch (kind) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    return null;
                }
            }
            IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
            return this.filterByElaboratedTypeSpecifier(kind, bindings);
        }
        if (parent instanceof IASTDeclarator) {
            IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
            if (isPrefix) {
                int i = 0;
                while (i < bindings.length) {
                    IBinding binding = bindings[i];
                    if (!(binding instanceof ICPPNamespace) && !(binding instanceof ICPPClassType)) {
                        bindings[i] = null;
                    }
                    ++i;
                }
            } else if (bindings.length == 0) {
                bindings = new IBinding[]{n.resolveBinding()};
            }
            return ArrayUtil.removeNulls(IBinding.class, bindings);
        }
        return null;
    }

    private IBinding[] filterByElaboratedTypeSpecifier(int kind, IBinding[] bindings) {
        int i = 0;
        while (i < bindings.length) {
            IBinding binding = bindings[i];
            if (binding instanceof ICPPClassType) {
                if (((ICPPClassType)binding).getKey() != kind) {
                    bindings[i] = null;
                }
            } else if (!(binding instanceof ICPPNamespace)) {
                bindings[i] = null;
            }
            ++i;
        }
        return ArrayUtil.removeNulls(IBinding.class, bindings);
    }

    @Override
    public char[] toCharArray() {
        return this.name;
    }

    @Override
    public final char[] getSimpleID() {
        return this.name;
    }

    @Override
    public final char[] getLookupKey() {
        return this.name;
    }

    public void setName(char[] name) {
        this.assertNotFrozen();
        this.name = name;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

