/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart.XYAxis;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart.XYSeries;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IXYSeries;

public abstract class BaseMouseProvider {
    private AbstractSegmentStoreDensityViewer fDensityViewer;
    private IAxis fXaxis;

    public BaseMouseProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        this.fDensityViewer = densityViewer;
        this.fXaxis = XYAxis.create((Object)densityViewer.getControl().getAxisSet().getXAxis(0));
        this.register();
    }

    private Chart getChart() {
        return this.fDensityViewer.getControl();
    }

    protected Control getControl() {
        return this.fDensityViewer.getControl().getPlotArea().getControl();
    }

    public AbstractSegmentStoreDensityViewer getDensityViewer() {
        return this.fDensityViewer;
    }

    public List<@NonNull IXYSeries> getSeries() {
        ArrayList<@NonNull IXYSeries> retVal = new ArrayList<IXYSeries>();
        ISeries[] iSeriesArray = this.getChart().getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            XYSeries xySeries = XYSeries.create((Object)series);
            if (xySeries != null) {
                retVal.add((IXYSeries)xySeries);
            }
            ++n2;
        }
        return retVal;
    }

    public IAxis getXAxis() {
        return this.fXaxis;
    }

    public void redraw() {
        this.getChart().redraw();
    }

    public void setToolTipText(String tooltip) {
        this.getChart().getPlotArea().setToolTipText(tooltip);
    }

    public TmfAbstractToolTipHandler getTooltipHandler() {
        return null;
    }

    public void dispose() {
        this.deregister();
    }

    protected void register() {
        IPlotArea plotArea = this.getChart().getPlotArea();
        Control control = plotArea.getControl();
        if (this instanceof MouseListener) {
            control.addMouseListener((MouseListener)this);
        }
        if (this instanceof MouseMoveListener) {
            control.addMouseMoveListener((MouseMoveListener)this);
        }
        if (this instanceof MouseWheelListener) {
            control.addMouseWheelListener((MouseWheelListener)this);
        }
        if (this instanceof MouseTrackListener) {
            control.addMouseTrackListener((MouseTrackListener)this);
        }
        if (this instanceof ICustomPaintListener) {
            plotArea.addCustomPaintListener((ICustomPaintListener)this);
        } else if (this instanceof PaintListener) {
            control.addPaintListener((PaintListener)this);
        }
        TmfAbstractToolTipHandler tooltipHandler = this.getTooltipHandler();
        if (tooltipHandler != null) {
            tooltipHandler.activateHoverHelp(control);
        }
    }

    protected void deregister() {
        IPlotArea plotArea = this.getChart().getPlotArea();
        if (plotArea == null) {
            return;
        }
        Control control = plotArea.getControl();
        if (!control.isDisposed()) {
            if (this instanceof MouseListener) {
                control.removeMouseListener((MouseListener)this);
            }
            if (this instanceof MouseMoveListener) {
                control.removeMouseMoveListener((MouseMoveListener)this);
            }
            if (this instanceof MouseWheelListener) {
                control.removeMouseWheelListener((MouseWheelListener)this);
            }
            if (this instanceof MouseTrackListener) {
                control.removeMouseTrackListener((MouseTrackListener)this);
            }
            if (this instanceof ICustomPaintListener) {
                plotArea.removeCustomPaintListener((ICustomPaintListener)this);
            } else if (this instanceof PaintListener) {
                control.removePaintListener((PaintListener)this);
            }
            TmfAbstractToolTipHandler tooltipHandler = this.getTooltipHandler();
            if (tooltipHandler != null) {
                tooltipHandler.deactivateHoverHelp(control);
            }
        }
    }
}

