/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.url;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ContentHandlerFactory;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.url.ContentHandlerFactoryImpl;
import org.eclipse.osgi.internal.url.MultiplexingFactory;
import org.eclipse.osgi.internal.url.URLStreamHandlerFactoryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class EquinoxFactoryManager {
    private final EquinoxContainer container;
    private volatile URLStreamHandlerFactoryImpl urlStreamHandlerFactory;
    private volatile ContentHandlerFactoryImpl contentHandlerFactory;

    public EquinoxFactoryManager(EquinoxContainer container) {
        this.container = container;
    }

    public void installHandlerFactories(BundleContext context) {
        this.installURLStreamHandlerFactory(context);
        this.installContentHandlerFactory(context);
    }

    private void installURLStreamHandlerFactory(BundleContext context) {
        URLStreamHandlerFactoryImpl shf = new URLStreamHandlerFactoryImpl(context, this.container);
        try {
            URL.setURLStreamHandlerFactory(shf);
        }
        catch (Error err) {
            try {
                EquinoxFactoryManager.forceURLStreamHandlerFactory(shf);
            }
            catch (Throwable ex) {
                this.container.getLogServices().log("org.eclipse.osgi", 4, ex.getMessage(), ex);
                this.urlStreamHandlerFactory = null;
                return;
            }
        }
        this.urlStreamHandlerFactory = shf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceURLStreamHandlerFactory(URLStreamHandlerFactoryImpl shf) throws Exception {
        Object lock;
        FrameworkUtil.asDictionary(Collections.emptyMap());
        Field factoryField = EquinoxFactoryManager.getField(URL.class, URLStreamHandlerFactory.class, false);
        if (factoryField == null) {
            throw new Exception("Could not find URLStreamHandlerFactory field");
        }
        Object object = lock = EquinoxFactoryManager.getURLStreamHandlerFactoryLock();
        synchronized (object) {
            URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
            if (factory != null) {
                try {
                    factory.getClass().getMethod("isMultiplexing", null);
                    Method register = factory.getClass().getMethod("register", Object.class);
                    register.invoke((Object)factory, shf);
                }
                catch (NoSuchMethodException e) {
                    shf.setParentFactory(factory);
                    factory = shf;
                }
            }
            factoryField.set(null, null);
            EquinoxFactoryManager.resetURLStreamHandlers();
            URL.setURLStreamHandlerFactory(factory);
        }
    }

    private static void resetURLStreamHandlers() throws IllegalAccessException {
        Hashtable handlers;
        Field handlersField = EquinoxFactoryManager.getField(URL.class, Hashtable.class, false);
        if (handlersField != null && (handlers = (Hashtable)handlersField.get(null)) != null) {
            handlers.clear();
        }
    }

    private static Object getURLStreamHandlerFactoryLock() throws IllegalAccessException {
        Object lock;
        try {
            Field streamHandlerLockField = URL.class.getDeclaredField("streamHandlerLock");
            MultiplexingFactory.setAccessible(streamHandlerLockField);
            lock = streamHandlerLockField.get(null);
        }
        catch (NoSuchFieldException noField) {
            lock = URL.class;
        }
        return lock;
    }

    private void installContentHandlerFactory(BundleContext context) {
        ContentHandlerFactoryImpl chf = new ContentHandlerFactoryImpl(context, this.container);
        try {
            URLConnection.setContentHandlerFactory(chf);
        }
        catch (Error err) {
            try {
                EquinoxFactoryManager.forceContentHandlerFactory(chf);
            }
            catch (Throwable ex) {
                this.container.getLogServices().log("org.eclipse.osgi", 4, ex.getMessage(), ex);
                this.contentHandlerFactory = null;
                return;
            }
        }
        this.contentHandlerFactory = chf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceContentHandlerFactory(ContentHandlerFactoryImpl chf) throws Exception {
        Field factoryField = EquinoxFactoryManager.getField(URLConnection.class, ContentHandlerFactory.class, false);
        if (factoryField == null) {
            throw new Exception("Could not find ContentHandlerFactory field");
        }
        Class<URLConnection> clazz = URLConnection.class;
        synchronized (URLConnection.class) {
            ContentHandlerFactory factory = (ContentHandlerFactory)factoryField.get(null);
            if (factory != null) {
                try {
                    factory.getClass().getMethod("isMultiplexing", null);
                    Method register = factory.getClass().getMethod("register", Object.class);
                    register.invoke((Object)factory, chf);
                }
                catch (NoSuchMethodException e) {
                    chf.setParentFactory(factory);
                    factory = chf;
                }
            }
            factoryField.set(null, null);
            EquinoxFactoryManager.resetContentHandlers();
            URLConnection.setContentHandlerFactory(factory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void resetContentHandlers() throws IllegalAccessException {
        Hashtable handlers;
        Field handlersField = EquinoxFactoryManager.getField(URLConnection.class, Hashtable.class, false);
        if (handlersField != null && (handlers = (Hashtable)handlersField.get(null)) != null) {
            handlers.clear();
        }
    }

    public void uninstallHandlerFactories() {
        this.uninstallURLStreamHandlerFactory();
        this.uninstallContentHandlerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallURLStreamHandlerFactory() {
        if (this.urlStreamHandlerFactory == null) {
            return;
        }
        try {
            Object lock;
            Field factoryField = EquinoxFactoryManager.getField(URL.class, URLStreamHandlerFactory.class, false);
            if (factoryField == null) {
                return;
            }
            Object object = lock = EquinoxFactoryManager.getURLStreamHandlerFactoryLock();
            synchronized (object) {
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory == this.urlStreamHandlerFactory) {
                    factory = (URLStreamHandlerFactory)this.urlStreamHandlerFactory.designateSuccessor();
                } else {
                    Method unregister = factory.getClass().getMethod("unregister", Object.class);
                    unregister.invoke((Object)factory, this.urlStreamHandlerFactory);
                }
                factoryField.set(null, null);
                EquinoxFactoryManager.resetURLStreamHandlers();
                if (factory != null) {
                    URL.setURLStreamHandlerFactory(factory);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallContentHandlerFactory() {
        if (this.contentHandlerFactory == null) {
            return;
        }
        try {
            Field factoryField = EquinoxFactoryManager.getField(URLConnection.class, ContentHandlerFactory.class, false);
            if (factoryField == null) {
                return;
            }
            Class<URLConnection> clazz = URLConnection.class;
            synchronized (URLConnection.class) {
                ContentHandlerFactory factory = (ContentHandlerFactory)factoryField.get(null);
                if (factory == this.contentHandlerFactory) {
                    factory = (ContentHandlerFactory)this.contentHandlerFactory.designateSuccessor();
                } else {
                    Method unregister = factory.getClass().getMethod("unregister", Object.class);
                    unregister.invoke((Object)factory, this.contentHandlerFactory);
                }
                factoryField.set(null, null);
                EquinoxFactoryManager.resetContentHandlers();
                if (factory != null) {
                    URLConnection.setContentHandlerFactory(factory);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        {
            return;
        }
    }

    public static Field getField(Class<?> clazz, Class<?> type, boolean instance) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (instance != isStatic && field.getType().equals(type)) {
                MultiplexingFactory.setAccessible(field);
                return field;
            }
            ++n2;
        }
        return null;
    }
}

