/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;

public abstract class AbstractPathCompletionProvider
extends AbstractCompletionProvider {
    protected <T> Collection<T> filter(Collection<T> elements, ICompletionContext context) {
        ArrayList<T> filteredElements = new ArrayList<T>();
        String filter = this.getFilter(context);
        for (T element : elements) {
            IPath path = this.convertToPath(element).makeAbsolute();
            if (!path.toString().startsWith(filter) || new Path(filter).segmentCount() + (filter.endsWith("/") ? 1 : 0) != path.segmentCount()) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }

    private String getFilter(ICompletionContext context) {
        return context.getFilter().startsWith("/") ? context.getFilter() : "/" + context.getFilter();
    }

    protected Collection<IPath> getPathsFromElements(Collection<?> elements) {
        LinkedHashSet<IPath> paths = new LinkedHashSet<IPath>();
        List pathsFromElements = elements.stream().map(e -> this.convertToPath(e)).filter(p -> p.segmentCount() > 0).map(p -> p.removeLastSegments(1).makeAbsolute()).collect(Collectors.toList());
        for (IPath path : pathsFromElements) {
            this.addPath(path, paths);
        }
        return paths;
    }

    private void addPath(IPath path, Collection<IPath> paths) {
        if (!Path.ROOT.equals((Object)path)) {
            this.addPath(path.removeLastSegments(1), paths);
            paths.add(path);
        }
    }

    private IPath convertToPath(Object element) {
        if (element instanceof IPath) {
            return (IPath)element;
        }
        return this.toPath(element);
    }

    protected abstract IPath toPath(Object var1);
}

