/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.preferences.PreferencesHelper;
import org.eclipse.ease.ui.scripts.repository.IRepositoryFactory;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.IStorage;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryFactoryImpl;
import org.eclipse.ease.ui.scripts.repository.impl.UpdateRepositoryJob;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.EventHandler;

public class RepositoryService
implements IRepositoryService,
IResourceChangeListener {
    static final long UPDATE_URI_INTERVAL = 1000L;
    static final long UPDATE_SCRIPT_INTERVAL = 1000L;
    private static RepositoryService fInstance;
    private static final String CACHE_FILE_NAME = "script.repository";
    private static final long DEFAULT_DELAY = 60000L;
    public static final long UPDATE_STREAM_INTERVAL = 0L;
    private static final String EXTENSION_KEYWORD_ID = "org.eclipse.ease.ui.scripts.keyword";
    private static final String EXTENSION_KEYWORD_HANDLER = "handler";
    private static final String EXTENSION_KEYWORD_HANDLER_CLASS = "class";
    private static final String EXTENSION_KEYWORD_HANDLER_KEYWORDS = "keywords";
    private IStorage fRepository = null;
    private final UpdateRepositoryJob fUpdateJob;
    IEventBroker fEventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
    private final Job fSaveJob = new Job("Save Script Repositories"){

        protected IStatus run(IProgressMonitor monitor) {
            IPath path = Activator.getDefault().getStateLocation().append(RepositoryService.CACHE_FILE_NAME);
            File file = path.toFile();
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resource = resSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
            resource.getContents().add((Object)RepositoryService.this.fRepository);
            try {
                resource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not store script repositories", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    };

    public static RepositoryService getInstance() {
        if (fInstance == null) {
            fInstance = new RepositoryService();
        }
        return fInstance;
    }

    private RepositoryService() {
        Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_REPOSITORY_SERVICE, (String)"org.eclipse.ease.ui.scripts", (String)"Starting repository service");
        RepositoryFactoryImpl.init();
        this.startKeywordHandlers();
        IPath path = Activator.getDefault().getStateLocation().append(CACHE_FILE_NAME);
        File file = path.toFile();
        if (file != null && file.exists()) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createURI((String)file.toURI().toString()));
            try {
                resource.load(null);
                this.fRepository = (IStorage)resource.getContents().get(0);
                for (IScript script : this.fRepository.getScripts()) {
                    for (Map.Entry<String, String> entry : script.getKeywords().entrySet()) {
                        this.fireKeywordEvent(script, entry.getKey(), entry.getValue(), null);
                    }
                }
                Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_REPOSITORY_SERVICE, (String)"org.eclipse.ease.ui.scripts", (String)"Loaded cached scripts");
            }
            catch (IOException script) {
                // empty catch block
            }
        }
        long updateDelay = 0L;
        if (this.fRepository == null) {
            this.fRepository = IRepositoryFactory.eINSTANCE.createStorage();
            Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_REPOSITORY_SERVICE, (String)"org.eclipse.ease.ui.scripts", (String)"Created clean script repository");
        } else if (!this.fRepository.getScripts().isEmpty()) {
            updateDelay = 60000L;
        }
        if (!this.equals((Collection<IScriptLocation>)this.fRepository.getEntries(), PreferencesHelper.getLocations())) {
            Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_REPOSITORY_SERVICE, (String)"org.eclipse.ease.ui.scripts", (String)"Cached scripts are dirty, cleanup");
            this.fRepository.getEntries().clear();
            this.fRepository.getEntries().addAll(PreferencesHelper.getLocations());
            this.save();
        }
        this.fUpdateJob = new UpdateRepositoryJob(this);
        for (IScriptLocation location : this.getLocations()) {
            location.setUpdatePending(true);
        }
        this.fUpdateJob.schedule(updateDelay);
        for (IScriptLocation location : this.getLocations()) {
            if (!location.getLocation().startsWith("workspace://")) continue;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            break;
        }
    }

    private void startKeywordHandlers() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_KEYWORD_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (EXTENSION_KEYWORD_HANDLER.equals(e.getName())) {
                try {
                    Object listener = e.createExecutableExtension(EXTENSION_KEYWORD_HANDLER_CLASS);
                    if (listener instanceof EventHandler) {
                        String keywords = e.getAttribute(EXTENSION_KEYWORD_HANDLER_KEYWORDS);
                        String[] stringArray = keywords.split(",");
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String keyword = stringArray[n4];
                            this.fEventBroker.subscribe("org/eclipse/ease/scripts/keyword/" + keyword, (EventHandler)listener);
                            ++n4;
                        }
                    } else {
                        Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Invalid keyword handler detected: " + e.getAttribute("id")));
                    }
                }
                catch (Exception e1) {
                    Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Invalid keyword handler detected: " + e.getAttribute("id")), (Throwable)e1);
                }
            }
            ++n2;
        }
    }

    private void fireKeywordEvent(IScript script, String key, String value, String oldValue) {
        Object service = PlatformUI.getWorkbench().getService(IEventBroker.class);
        if (service instanceof IEventBroker) {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("script", script);
            eventData.put("keyword", key);
            eventData.put("value", value);
            eventData.put("oldValue", oldValue);
            ((IEventBroker)service).post("org/eclipse/ease/scripts/keyword/" + key, eventData);
        }
    }

    private boolean equals(Collection<IScriptLocation> first, Collection<IScriptLocation> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (IScriptLocation firstEntry : first) {
            boolean found = false;
            for (IScriptLocation secondEntry : second) {
                if (!firstEntry.getLocation().equals(secondEntry.getLocation())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(boolean force) {
        if (force) {
            for (IScript script : this.getScripts()) {
                script.setTimestamp(0L);
            }
        }
        this.fUpdateJob.update();
    }

    @Override
    public IScript getScript(String name) {
        for (IScript script : this.fRepository.getScripts()) {
            if (!name.equals(script.getPath().toString())) continue;
            return script;
        }
        return null;
    }

    void save() {
        this.fSaveJob.cancel();
        this.fSaveJob.schedule(500L);
    }

    @Override
    public Collection<IScript> getScripts() {
        return Collections.unmodifiableCollection(this.fRepository.getScripts());
    }

    @Override
    public Collection<IScriptLocation> getLocations() {
        return Collections.unmodifiableCollection(this.fRepository.getEntries());
    }

    @Override
    public void updateLocation(IScriptLocation entry, String location, long lastChanged) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        IScript script = this.getScriptByLocation(location);
        ScriptType scriptType = scriptService.getScriptType(location);
        if (scriptType != null) {
            if (script == null) {
                script = IRepositoryFactory.eINSTANCE.createScript();
                script.setEntry(entry);
                script.setLocation(location);
                entry.getScripts().add((Object)script);
                HashMap<String, IScript> eventData = new HashMap<String, IScript>();
                eventData.put("script", script);
                this.fEventBroker.post("org/eclipse/ease/scripts/new", eventData);
            } else if (script.getTimestamp() == lastChanged) {
                script.setUpdatePending(false);
                return;
            }
            Map<String, String> oldKeywords = script.getKeywords();
            script.refreshScriptKeywords();
            Map<String, String> newKeywords = script.getKeywords();
            script.updateSignatureState();
            if (!oldKeywords.equals(newKeywords)) {
                for (String string : oldKeywords.keySet()) {
                    if (newKeywords.containsKey(string)) continue;
                    this.fireKeywordEvent(script, string, null, oldKeywords.get(string));
                }
                for (Map.Entry entry2 : newKeywords.entrySet()) {
                    if (((String)entry2.getValue()).equals(oldKeywords.get(entry2.getKey()))) continue;
                    this.fireKeywordEvent(script, (String)entry2.getKey(), (String)entry2.getValue(), oldKeywords.get(entry2.getKey()));
                }
            }
            script.setTimestamp(lastChanged);
            script.setUpdatePending(false);
        } else if (script != null) {
            this.removeScript(script);
        }
    }

    private IScript getScriptByLocation(String location) {
        for (IScript script : this.getScripts()) {
            if (!script.getLocation().equals(location)) continue;
            return script;
        }
        return null;
    }

    void removeScript(IScript script) {
        script.getEntry().getScripts().remove((Object)script);
        for (Map.Entry<String, String> entry : script.getKeywords().entrySet()) {
            this.fireKeywordEvent(script, entry.getKey(), null, entry.getValue());
        }
        HashMap<String, IScript> eventData = new HashMap<String, IScript>();
        eventData.put("script", script);
        this.fEventBroker.post("org/eclipse/ease/scripts/removed", eventData);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        String location = "workspace:/" + resource.getFullPath();
                        for (IScriptLocation entry : RepositoryService.this.getLocations()) {
                            if (!entry.getLocation().equals(location)) continue;
                            RepositoryService.this.fUpdateJob.update(entry);
                            return false;
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addLocation(String locationURI, boolean defaultLocation, boolean recursive) {
        IScriptLocation entry = IRepositoryFactory.eINSTANCE.createScriptLocation();
        entry.setLocation(locationURI);
        entry.setRecursive(recursive);
        entry.setDefault(defaultLocation);
        for (IScriptLocation location : new HashSet<IScriptLocation>(this.getLocations())) {
            if (!location.getLocation().equals(locationURI)) continue;
            if (!EcoreUtil.equals((EObject)location, (EObject)entry)) {
                this.removeLocation(location.getLocation());
                continue;
            }
            return;
        }
        PreferencesHelper.addLocation(entry);
        Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_REPOSITORY_SERVICE, (String)"org.eclipse.ease.ui.scripts", (String)("Script location added: " + locationURI));
        this.fRepository.getEntries().add((Object)entry);
        if (entry.getLocation().startsWith("workspace://")) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.fUpdateJob.update(entry);
    }

    @Override
    public void removeLocation(String locationURI) {
        for (IScriptLocation entry : new HashSet<IScriptLocation>((Collection<IScriptLocation>)this.fRepository.getEntries())) {
            if (!entry.getLocation().equals(locationURI)) continue;
            this.fRepository.getEntries().remove((Object)entry);
            for (IScript script : new HashSet<IScript>((Collection<IScript>)entry.getScripts())) {
                this.removeScript(script);
            }
            this.save();
            Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_REPOSITORY_SERVICE, (String)"org.eclipse.ease.ui.scripts", (String)("Script location removed: " + locationURI));
            break;
        }
        PreferencesHelper.removeLocation(locationURI);
    }

    public static Collection<String> getSupportedKeywords() {
        IConfigurationElement[] config;
        HashSet<String> keywords = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_KEYWORD_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (EXTENSION_KEYWORD_HANDLER.equals(e.getName())) {
                String handlerKeywords = e.getAttribute(EXTENSION_KEYWORD_HANDLER_KEYWORDS);
                keywords.addAll(Arrays.asList(handlerKeywords.split(",")));
            }
            ++n2;
        }
        return keywords;
    }
}

