/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.bind;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.bind.steps.CommonSteps;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.internal.databinding.bind.CommonStepsImpl;
import org.eclipse.core.internal.databinding.bind.UpdataStrategyEntry;

public final class BindingBuilder {
    private ActiveEnd activeEnd = null;
    protected final UpdataStrategyEntry fromEntry = new UpdataStrategyEntry();
    protected final UpdataStrategyEntry toEntry = new UpdataStrategyEntry();
    BindDirection bindDirection = BindDirection.TARGET_TO_MODEL;

    void updateFromObservable(IObservable observable) {
        this.fromEntry.setObservable(observable);
        this.activeEnd = ActiveEnd.FROM;
    }

    void updateToObservable(IObservable observable) {
        this.toEntry.setObservable(observable);
        this.activeEnd = ActiveEnd.TO;
    }

    static void verifyNotSet(Object value) {
        if (value != null) {
            throw new IllegalStateException("Trying to set a value twice");
        }
    }

    void doFromStep(IObservable from, boolean isTwoWay) {
        this.toEntry.setDefaultUpdatePolicy(UpdateValueStrategy.POLICY_UPDATE);
        this.fromEntry.setDefaultUpdatePolicy(isTwoWay ? UpdateValueStrategy.POLICY_UPDATE : UpdateValueStrategy.POLICY_NEVER);
        this.updateFromObservable(from);
    }

    public static CommonSteps.TwoWayConfigAndFromStep<?> twoWay() {
        return new CommonStepsImpl.TwoWayConfigAndFromStepImpl(new BindingBuilder());
    }

    public static CommonSteps.OneWayConfigAndFromStep<?> oneWay() {
        return new CommonStepsImpl.OneWayConfigAndFromStepImpl(new BindingBuilder());
    }

    UpdataStrategyEntry getActiveEntry() {
        return this.activeEnd == ActiveEnd.TO ? this.toEntry : this.fromEntry;
    }

    UpdataStrategyEntry getPassiveEntry() {
        return this.activeEnd == ActiveEnd.TO ? this.fromEntry : this.toEntry;
    }

    void setDefaultConvert() {
        this.fromEntry.setProvideDefaults(true);
        this.toEntry.setProvideDefaults(true);
    }

    static class AbstractStep {
        final BindingBuilder builder;

        public AbstractStep(BindingBuilder builder) {
            this.builder = builder;
        }
    }

    static enum ActiveEnd {
        TO,
        FROM;

    }

    static enum BindDirection {
        MODEL_TO_TARGET,
        TARGET_TO_MODEL;

    }
}

