/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.DeduplicationUtil;
import org.eclipse.jdt.internal.core.util.Util;

public class JarPackageFragmentRoot
extends PackageFragmentRoot {
    protected final IPath jarPath;
    private volatile boolean knownToBeModuleLess;
    private volatile boolean multiVersion;
    protected final IClasspathAttribute[] extraAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarPackageFragmentRoot(IResource resource, IPath externalJarPath, JavaProject project, IClasspathAttribute[] attributes) {
        super(resource, project);
        this.jarPath = externalJarPath;
        if (attributes == null) {
            try {
                JavaModelManager.PerProjectInfo perProjectInfo;
                JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = project.getPerProjectInfo();
                synchronized (perProjectInfo2) {
                    IClasspathEntry classpathEntry;
                    if (perProjectInfo.resolvedClasspath != null && perProjectInfo.unresolvedEntryStatus == JavaModelStatus.VERIFIED_OK && (classpathEntry = project.getClasspathEntryFor(externalJarPath)) != null) {
                        attributes = classpathEntry.getExtraAttributes();
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        this.extraAttributes = attributes;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, IResource underlyingResource) throws JavaModelException {
        Map<Object, Object> rawPackageInfo = new HashMap();
        Map<String, Object> overridden = new HashMap();
        IJavaElement[] children = NO_ELEMENTS;
        try {
            rawPackageInfo.put(new ArrayList(), new JarPackageFragmentRootInfo.PackageContent());
            Object file = JavaModel.getTarget(this, true);
            long classLevel = Util.getJdkLevel(file);
            String projectCompliance = this.getJavaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true);
            long projectLevel = CompilerOptions.versionToJdkLevel((String)projectCompliance);
            ZipFile jar = null;
            try {
                String[] supportedVersions;
                Object versionPath;
                jar = this.getJar();
                String version = "META-INF/versions/";
                ArrayList<CallSite> versions = new ArrayList<CallSite>();
                if (projectLevel >= 0x350000L && jar.getEntry(version) != null) {
                    int latestJavaVer;
                    int earliestJavaVersion = 53;
                    long latestJDK = CompilerOptions.versionToJdkLevel((String)projectCompliance);
                    int i = latestJavaVer = (int)(latestJDK >> 16);
                    while (i >= earliestJavaVersion) {
                        String s = "" + (i - 44);
                        versionPath = version + s;
                        if (jar.getEntry((String)versionPath) != null) {
                            versions.add((CallSite)((Object)s));
                        }
                        --i;
                    }
                }
                if ((supportedVersions = versions.toArray(new String[versions.size()])).length > 0) {
                    this.multiVersion = true;
                }
                int length = version.length();
                Enumeration<? extends ZipEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    ZipEntry member = e.nextElement();
                    String name = Util.getEntryName(jar.getName(), member);
                    if (name == null) continue;
                    if (this.multiVersion && name.length() > length + 2 && name.startsWith(version)) {
                        int end = name.indexOf(47, length);
                        if (end >= name.length()) continue;
                        versionPath = name.substring(0, end);
                        String ver = name.substring(length, end);
                        if (versions.contains(ver) && org.eclipse.jdt.internal.compiler.util.Util.isClassFileName((String)name)) {
                            name = name.substring(end + 1);
                            overridden.put(name, versionPath);
                        }
                    }
                    JarPackageFragmentRoot.initRawPackageInfo(rawPackageInfo, this.getClassNameSubFolder(), name, member.isDirectory(), CompilerOptions.versionFromJdkLevel((long)classLevel));
                }
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
            }
            rawPackageInfo = JarPackageFragmentRoot.unmodifiableCopy(rawPackageInfo);
            children = this.createChildren(rawPackageInfo.keySet());
        }
        catch (ZipException zipex) {
            Util.log(zipex, "Invalid ZIP archive: " + this.toStringWithAncestors());
            children = NO_ELEMENTS;
            rawPackageInfo = Map.of();
            overridden = Map.of();
        }
        catch (CoreException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ZipException) {
                ZipException zipex = (ZipException)throwable;
                Util.log(zipex, "Invalid ZIP archive: " + this.toStringWithAncestors());
                children = NO_ELEMENTS;
                rawPackageInfo = Map.of();
                overridden = Map.of();
            }
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
        info.setChildren(children);
        ((JarPackageFragmentRootInfo)info).rawPackageInfo = rawPackageInfo;
        ((JarPackageFragmentRootInfo)info).overriddenClasses = overridden;
        return true;
    }

    protected IJavaElement[] createChildren(Collection<List<String>> packagenames) {
        ArrayList<String[]> keys = new ArrayList<String[]>(packagenames.stream().map(s -> (String[])s.toArray(String[]::new)).toList());
        Collections.sort(keys, (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compare(java.lang.Comparable[] java.lang.Comparable[] ), ([Ljava/lang/String;[Ljava/lang/String;)I)());
        IJavaElement[] children = new IJavaElement[packagenames.size()];
        int index = 0;
        for (String[] pkgName : keys) {
            children[index++] = this.getPackageFragment(pkgName);
        }
        return children;
    }

    @Override
    protected JarPackageFragmentRootInfo createElementInfo() {
        return new JarPackageFragmentRootInfo();
    }

    @Override
    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot other = (JarPackageFragmentRoot)o;
            return this.jarPath.equals((Object)other.jarPath) && Arrays.equals(this.extraAttributes, other.extraAttributes);
        }
        return false;
    }

    @Override
    protected int calculateHashCode() {
        return this.jarPath.hashCode() + Arrays.hashCode(this.extraAttributes);
    }

    @Override
    public String getElementName() {
        return this.jarPath.lastSegment();
    }

    public ZipFile getJar() throws CoreException {
        return JavaModelManager.getJavaModelManager().getZipFile(this.getPath());
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    int internalKind() throws JavaModelException {
        return 2;
    }

    @Override
    public Object[] getNonJavaResources() throws JavaModelException {
        Object[] defaultPkgResources = ((JarPackageFragment)this.getPackageFragment(CharOperation.NO_STRINGS)).storedNonJavaResources();
        int length = defaultPkgResources.length;
        if (length == 0) {
            return defaultPkgResources;
        }
        Object[] nonJavaResources = new Object[length];
        int i = 0;
        while (i < length) {
            JarEntryResource nonJavaResource = (JarEntryResource)defaultPkgResources[i];
            nonJavaResources[i] = nonJavaResource.clone(this);
            ++i;
        }
        return nonJavaResources;
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName, String mod) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public String getClassFilePath(String classname) {
        if (this.multiVersion) {
            try {
                JarPackageFragmentRootInfo elementInfo = (JarPackageFragmentRootInfo)this.getElementInfo();
                String versionPath = elementInfo.overriddenClasses.get(classname);
                return versionPath == null ? classname : versionPath + "/" + classname;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return classname;
    }

    @Override
    public IModuleDescription getModuleDescription() {
        if (this.knownToBeModuleLess) {
            return null;
        }
        IModuleDescription module = super.getModuleDescription();
        if (module == null) {
            this.knownToBeModuleLess = true;
        }
        return module;
    }

    @Override
    public IPath internalPath() {
        if (this.isExternal()) {
            return this.jarPath;
        }
        return super.internalPath();
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (this.resource == null) {
            return null;
        }
        return super.resource(root);
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    static void initRawPackageInfo(Map<List<String>, JarPackageFragmentRootInfo.PackageContent> rawPackageInfo, String classNameSubFolder, String entryName, boolean isDirectory, String compliance) {
        int length;
        String className = JarPackageFragmentRoot.entryToClassName(classNameSubFolder, entryName);
        int lastSeparator = isDirectory ? (className.charAt(className.length() - 1) == '/' ? className.length() - 1 : className.length()) : className.lastIndexOf(47);
        ArrayList<String> pkgName = new ArrayList<String>(Arrays.asList(Util.splitOn('/', className, 0, lastSeparator)));
        JarPackageFragmentRootInfo.PackageContent existing = null;
        int existingLength = length = pkgName.size();
        while (existing == null) {
            existing = rawPackageInfo.get(pkgName.subList(0, existingLength));
            --existingLength;
        }
        int i = ++existingLength;
        while (i < length) {
            if (!Util.isValidFolderNameForPackage(pkgName.get(i), null, compliance)) {
                if (!isDirectory) {
                    existing.resources().add(className);
                }
                return;
            }
            List<String> path = pkgName.subList(0, i + 1);
            existing = new JarPackageFragmentRootInfo.PackageContent();
            rawPackageInfo.put(path, existing);
            ++i;
        }
        if (isDirectory) {
            return;
        }
        JarPackageFragmentRootInfo.PackageContent children = rawPackageInfo.get(pkgName);
        if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName((String)className)) {
            String nameWithoutExtension = className.substring(lastSeparator + 1, className.length() - 6);
            children.javaClasses().add(nameWithoutExtension);
        } else {
            children.resources().add(className);
        }
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.resource() == null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected boolean resourceExists(IResource underlyingResource) {
        if (underlyingResource == null) {
            return JavaModel.getExternalTarget(this.getPath(), true) != null;
        }
        return super.resourceExists(underlyingResource);
    }

    @Override
    protected void toStringAncestors(StringBuilder buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public URL getIndexPath() {
        try {
            IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(this.getPath());
            if (entry != null) {
                return ((ClasspathEntry)entry).getLibraryIndexLocation();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Manifest getManifest() {
        block15: {
            ZipFile jar = null;
            try {
                Manifest manifest;
                block16: {
                    jar = this.getJar();
                    ZipEntry mfEntry = jar.getEntry("META-INF/MANIFEST.MF");
                    if (mfEntry == null) break block15;
                    Throwable throwable = null;
                    Object var4_6 = null;
                    InputStream is = jar.getInputStream(mfEntry);
                    try {
                        manifest = new Manifest(is);
                        if (is == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | CoreException throwable4) {
                            break block15;
                        }
                    }
                    is.close();
                }
                return manifest;
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
            }
        }
        return null;
    }

    protected String getClassNameSubFolder() {
        return null;
    }

    static String entryToClassName(String classNameSubFolder, String entryName) {
        if (classNameSubFolder != null && entryName.startsWith(classNameSubFolder)) {
            return entryName.substring(classNameSubFolder.length());
        }
        return entryName;
    }

    static Map<List<String>, JarPackageFragmentRootInfo.PackageContent> unmodifiableCopy(Map<List<String>, JarPackageFragmentRootInfo.PackageContent> rawPackageInfo) {
        HashMap<List<String>, JarPackageFragmentRootInfo.PackageContent> deduplicatedPackageInfo = new HashMap<List<String>, JarPackageFragmentRootInfo.PackageContent>();
        for (Map.Entry<List<String>, JarPackageFragmentRootInfo.PackageContent> e : rawPackageInfo.entrySet()) {
            List<String> key = e.getKey();
            JarPackageFragmentRootInfo.PackageContent p = e.getValue();
            JarPackageFragmentRootInfo.PackageContent packageContent = new JarPackageFragmentRootInfo.PackageContent(DeduplicationUtil.intern(p.javaClasses()), DeduplicationUtil.intern(p.resources()));
            deduplicatedPackageInfo.put(DeduplicationUtil.intern(key), packageContent);
        }
        return Map.copyOf(deduplicatedPackageInfo);
    }
}

