/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUnaryTypeTransformation;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPUnaryTypeTransformation
implements ICPPUnaryTypeTransformation,
ISerializableType {
    ICPPUnaryTypeTransformation.Operator fOperator;
    IType fOperand;

    public CPPUnaryTypeTransformation(ICPPUnaryTypeTransformation.Operator operator, IType operand) {
        this.fOperator = operator;
        this.fOperand = operand;
    }

    @Override
    public boolean isSameType(IType other) {
        if (this == other) {
            return false;
        }
        if (!(other instanceof ICPPUnaryTypeTransformation)) {
            return false;
        }
        ICPPUnaryTypeTransformation otherType = (ICPPUnaryTypeTransformation)other;
        return this.getOperator() == otherType.getOperator() && this.getOperand().isSameType(otherType.getOperand());
    }

    @Override
    public ICPPUnaryTypeTransformation.Operator getOperator() {
        return this.fOperator;
    }

    @Override
    public IType getOperand() {
        return this.fOperand;
    }

    @Override
    public CPPUnaryTypeTransformation clone() {
        return new CPPUnaryTypeTransformation(this.fOperator, (IType)this.fOperand.clone());
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        buffer.putShort((short)15);
        buffer.putByte((byte)this.getOperator().ordinal());
        buffer.marshalType(this.getOperand());
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int operator = buffer.getByte();
        if (operator >= ICPPUnaryTypeTransformation.Operator.values().length) {
            throw new CoreException(CCorePlugin.createStatus("Cannot unmarshal CPPUnaryTypeTransformation - unrecognized type transformation operator"));
        }
        return new CPPUnaryTypeTransformation(ICPPUnaryTypeTransformation.Operator.values()[operator], buffer.unmarshalType());
    }
}

