/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.PotentialLeakSegment;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.UstMemoryStateProvider;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventRequirement;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class UstMemoryAnalysisModule
extends TmfStateSystemAnalysisModule
implements ISegmentStoreProvider {
    public static final @NonNull String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.memory";
    private @Nullable Set<TmfAbstractAnalysisRequirement> fAnalysisRequirements;
    private final ListenerList<IAnalysisProgressListener> fListeners = new ListenerList(1);
    private @Nullable ISegmentStore<@NonNull ISegment> fSegmentStore = null;
    private Map<Long, UstMemoryStateProvider.MemoryAllocation> fPotentialLeaks;

    public ITmfStateProvider createStateProvider() {
        return new UstMemoryStateProvider((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()), this);
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) {
        if (!super.executeAnalysis(monitor)) {
            return false;
        }
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        String segmentFileName = String.valueOf(this.getSsFileName()) + ".seg";
        String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        Path file = Paths.get(dir, segmentFileName);
        boolean needsBuilding = true;
        Map<Long, UstMemoryStateProvider.MemoryAllocation> unfreedMemory = this.fPotentialLeaks;
        if (unfreedMemory == null || unfreedMemory.isEmpty()) {
            needsBuilding = false;
        }
        ISegmentStore segmentStore = null;
        try {
            if (needsBuilding) {
                Files.deleteIfExists(file);
            }
            segmentStore = SegmentStoreFactory.createOnDiskSegmentStore((Path)file, PotentialLeakSegment.MEMORY_SEGMENT_READ_FACTORY, (int)1);
        }
        catch (IOException iOException) {
            return false;
        }
        if (needsBuilding) {
            UstMemoryAnalysisModule.fillStore((ISegmentStore<ISegment>)segmentStore, unfreedMemory);
        }
        this.fSegmentStore = segmentStore;
        this.sendUpdate((ISegmentStore<ISegment>)segmentStore);
        return true;
    }

    private static void fillStore(ISegmentStore<@NonNull ISegment> segmentStore, Map<Long, UstMemoryStateProvider.MemoryAllocation> unfreedMemory) {
        for (Map.Entry<Long, UstMemoryStateProvider.MemoryAllocation> unfreedMem : unfreedMemory.entrySet()) {
            UstMemoryStateProvider.MemoryAllocation memAlloc = unfreedMem.getValue();
            segmentStore.add((Object)new PotentialLeakSegment(memAlloc.getTs(), memAlloc.getTs(), memAlloc.getTid()));
        }
        segmentStore.close(false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        ImmutableSet requirements = this.fAnalysisRequirements;
        if (requirements == null) {
            ITmfTrace trace = this.getTrace();
            ILttngUstEventLayout layout = !(trace instanceof LttngUstTrace) ? ILttngUstEventLayout.DEFAULT_LAYOUT : ((LttngUstTrace)trace).getEventLayout();
            @NonNull @NonNull ImmutableSet requiredEvents = ImmutableSet.of((Object)layout.eventLibcMalloc(), (Object)layout.eventLibcFree(), (Object)layout.eventLibcCalloc(), (Object)layout.eventLibcRealloc(), (Object)layout.eventLibcMemalign(), (Object)layout.eventLibcPosixMemalign(), (Object[])new String[0]);
            TmfAnalysisEventRequirement eventsReq = new TmfAnalysisEventRequirement((Collection)requiredEvents, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
            eventsReq.addInformation(NonNullUtils.nullToEmptyString((Object)Messages.UstMemoryAnalysisModule_EventsLoadingInformation));
            eventsReq.addInformation(NonNullUtils.nullToEmptyString((Object)Messages.UstMemoryAnalysisModule_EventsLoadingExampleInformation));
            this.fAnalysisRequirements = requirements = ImmutableSet.of((Object)eventsReq);
        }
        return requirements;
    }

    public void addListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void sendUpdate(@NonNull ISegmentStore<@NonNull ISegment> store) {
        for (Object listener : this.fListeners) {
            ((IAnalysisProgressListener)listener).onComplete((ISegmentStoreProvider)this, store);
        }
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        return Collections.singletonList(PotentialLeakTidAspect.INSTANCE);
    }

    public @Nullable ISegmentStore<@NonNull ISegment> getSegmentStore() {
        return this.fSegmentStore;
    }

    public void setPotentialLeaks(Map<Long, UstMemoryStateProvider.MemoryAllocation> memory) {
        this.fPotentialLeaks = memory;
    }

    public void dispose() {
        super.dispose();
        ISegmentStore<@NonNull ISegment> store = this.fSegmentStore;
        if (store != null) {
            store.dispose();
        }
    }

    private static final class PotentialLeakTidAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new PotentialLeakTidAspect();

        private PotentialLeakTidAspect() {
        }

        public String getHelpText() {
            return (String)NonNullUtils.checkNotNull((Object)Messages.SegmentAspectHelpText_PotentialLeakTid);
        }

        public String getName() {
            return OsStrings.tid();
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable Integer resolve(ISegment segment) {
            if (segment instanceof PotentialLeakSegment) {
                return ((PotentialLeakSegment)segment).getTid();
            }
            return -1;
        }
    }
}

