/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.wizards;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.wizards.SelectGrammarWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;

public final class TextMateGrammarImportWizard
extends Wizard
implements IImportWizard {
    private final IGrammarRegistryManager.EditSession manager;
    private final boolean saveOnFinish;
    private SelectGrammarWizardPage mainPage = (SelectGrammarWizardPage)((Object)NullSafetyHelper.lazyNonNull());
    private IGrammarDefinition createdDefinition = (IGrammarDefinition)NullSafetyHelper.lazyNonNull();

    public TextMateGrammarImportWizard(IGrammarRegistryManager.EditSession manager, boolean saveOnFinish) {
        this.manager = manager;
        this.saveOnFinish = saveOnFinish;
    }

    public void addPages() {
        this.mainPage = new SelectGrammarWizardPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IGrammarDefinition definition = this.mainPage.getGrammarDefinition();
        this.manager.registerGrammarDefinition(definition);
        if (this.saveOnFinish) {
            try {
                this.manager.save();
            }
            catch (BackingStoreException ex) {
                TMUIPlugin.logError((Exception)((Object)ex));
                return false;
            }
        }
        this.createdDefinition = definition;
        return true;
    }

    public void init(@Nullable IWorkbench workbench, @Nullable IStructuredSelection selection) {
    }

    public IGrammarDefinition getCreatedDefinition() {
        return this.createdDefinition;
    }
}

