/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.ui.internal.widgets.TableWidget;

public abstract class TableWithControlsWidget<T>
extends Composite {
    protected final TableWidget<T> table;
    private final Composite buttonsArea;

    protected TableWithControlsWidget(Composite parent, @Nullable String title, boolean enableFiltering) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(5, 2).equalWidth(false).create());
        if (title != null && !title.isEmpty()) {
            this.createTitle(title, this);
        }
        if (enableFiltering) {
            this.createFilter(this);
        }
        this.table = this.createTable(this);
        this.buttonsArea = new Composite((Composite)this, 0);
        this.buttonsArea.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 5).create());
        this.buttonsArea.setLayoutData((Object)new GridData(1042));
        this.createButtons();
        if (this.buttonsArea.getChildren().length == 0) {
            ((GridLayout)parent.getLayout()).horizontalSpacing = 0;
        }
    }

    protected void createButtons() {
    }

    protected Button createButton(String title, Runnable onClick) {
        Button button = new Button(this.buttonsArea, 8);
        button.setText(title);
        button.setLayoutData((Object)new GridData(768));
        button.addListener(13, e -> onClick.run());
        return button;
    }

    private void createTitle(String title, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(title);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
    }

    private void createFilter(Composite parent) {
        Text filterInput = new Text((Composite)this, 0x800380);
        filterInput.setMessage(" type filter text");
        filterInput.addModifyListener(e -> this.onFilterChanged(filterInput.getText()));
        filterInput.setLayoutData((Object)new GridData(768));
        Label spacing = new Label(parent, 0);
    }

    protected abstract TableWidget<T> createTable(Composite var1);

    protected void onFilterChanged(String newFilterText) {
        if (newFilterText.isEmpty()) {
            this.table.resetFilters();
        } else {
            final String filterText = newFilterText.toLowerCase();
            final Table swtTable = this.table.getTable();
            final int colCount = swtTable.getColumnCount();
            this.table.resetFilters();
            this.table.setFilters(new ViewerFilter[]{new ViewerFilter(){

                @NonNullByDefault(value={})
                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    int i = 0;
                    int l = swtTable.getItemCount();
                    while (i < l) {
                        if (TableWithControlsWidget.this.table.getElementAt(i) == element) {
                            TableItem row = swtTable.getItem(i);
                            int j = 0;
                            while (j < colCount) {
                                if (row.getText(j).toLowerCase().contains(filterText)) {
                                    return true;
                                }
                                ++j;
                            }
                            return false;
                        }
                        ++i;
                    }
                    return false;
                }
            }});
        }
    }

    public TableWidget<T> getTable() {
        return this.table;
    }
}

