/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.internal.dstore.universal.miners.processes.ProcessDEComparator;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.clientserver.processes.handlers.IRemoteServerProcess;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessComparator;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandlerManager;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalServerProcessImpl;

public class UniversalProcessMiner
extends Miner {
    private ProcessHandler handler = ProcessHandlerManager.getInstance().getNewProcessHandler();
    private static final String _minerVersion = "7.0.0";
    private DataElement deUniversalProcessObject;
    private DataElement deUniversalProcessFilter;
    private DataElement deKillInfoNode;
    private ProcessDEComparator _processDEcomparator;

    private ProcessDEComparator getProcessDEComparator() {
        if (this._processDEcomparator == null) {
            try {
                this._processDEcomparator = new ProcessDEComparator();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Error err) {
                err.printStackTrace();
            }
        }
        return this._processDEcomparator;
    }

    public DataElement handleCommand(DataElement theCommand) {
        String name = this.getCommandName(theCommand);
        DataElement status = this.getCommandStatus(theCommand);
        DataElement subject = this.getCommandArgument(theCommand, 0);
        UniversalServerUtilities.logInfo(this.getMinerName(), String.valueOf(name) + ":" + subject, this._dataStore);
        if (subject == null) {
            UniversalServerUtilities.logError("UniversalProcessMiner", "Subject for UniversalProcessMiner command " + name + " is null", null, this._dataStore);
            status.setAttribute(2, "done");
            return status;
        }
        String subjectType = (String)subject.getElementProperty((Object)"type");
        if (name.equals("C_PROCESS_QUERY_USERNAME")) {
            return this.handleQueryUserName(subject, status);
        }
        if (subjectType.equals("universal.process.filter")) {
            if (name.equals("C_PROCESS_FILTER_QUERY_ALL")) {
                status = this.handleQuery(subject, status);
            } else {
                UniversalServerUtilities.logError("UniversalProcessMiner", "Unknown filter command: " + name, null, this._dataStore);
                status.setAttribute(2, "done");
            }
        } else if (subjectType.equals("universal.process.descriptor")) {
            if (name.equals("C_PROCESS_QUERY_ALL_PROPERTIES")) {
                this.handleQueryJobAllProperties(subject, status);
            } else if (name.equals("C_PROCESS_KILL")) {
                status = this.handleKill(subject, status);
            } else {
                UniversalServerUtilities.logError("UniversalProcessMiner", "Unsupported process command: " + name, null, this._dataStore);
                status.setAttribute(2, "done");
            }
        } else {
            UniversalServerUtilities.logError("UniversalProcessMiner", "Unsupported subject for command: " + subject, null, this._dataStore);
            status.setAttribute(2, "done");
        }
        return status;
    }

    protected DataElement handleQueryUserName(DataElement subject, DataElement status) {
        String userName = null;
        if (this._dataStore.getClient() != null) {
            userName = this._dataStore.getClient().getProperty("client.username");
        }
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        subject.setAttribute(3, userName);
        this._dataStore.refresh(subject);
        status.setAttribute(2, "done");
        this._dataStore.refresh(status);
        return status;
    }

    public void extendSchema(DataElement schemaRoot) {
        this.deUniversalProcessFilter = this.createObjectDescriptor(schemaRoot, "universal.process.filter");
        this.deUniversalProcessObject = this.createObjectDescriptor(schemaRoot, "universal.process.descriptor");
        DataElement tempnode = this.createObjectDescriptor(schemaRoot, "universal.process.temp");
        this.createCommandDescriptor(this.deUniversalProcessFilter, "Filter", "C_PROCESS_FILTER_QUERY_ALL");
        this.createCommandDescriptor(this.deUniversalProcessObject, "Kill", "C_PROCESS_KILL");
        this.createCommandDescriptor(this.deUniversalProcessObject, "ProcessQueryAllProperties", "C_PROCESS_QUERY_ALL_PROPERTIES");
        this.createCommandDescriptor(tempnode, "QueryUsername", "C_PROCESS_QUERY_USERNAME");
        this._dataStore.refresh(schemaRoot);
    }

    public void load() {
        this.deKillInfoNode = this._dataStore.createObject(this._minerData, "universal.node", "universal.killinfo");
        this.deKillInfoNode.setAttribute(3, this.getSignalTypes());
        this._dataStore.refresh(this._minerData);
    }

    protected String getSignalTypes() {
        try {
            Process kill = Runtime.getRuntime().exec("kill -l");
            InputStreamReader isr = new InputStreamReader(kill.getInputStream());
            BufferedReader reader = new BufferedReader(isr);
            String nextLine = reader.readLine();
            String output = "";
            while (nextLine != null) {
                output = String.valueOf(output) + nextLine + "\n";
                nextLine = reader.readLine();
            }
            reader.close();
            isr.close();
            return output;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private DataElement handleQuery(DataElement subject, DataElement status) {
        try {
            HostProcessFilterImpl pfs = new HostProcessFilterImpl(subject.getSource());
            this.lookupProcesses(pfs, subject);
        }
        catch (Exception e) {
            e.printStackTrace();
            UniversalServerUtilities.logError("UniversalProcessMiner", "handleQuery()", e, this._dataStore);
            status.setAttribute(3, e.getMessage());
            status.setAttribute(2, "done");
            this._dataStore.refresh(status);
            return status;
        }
        this._dataStore.refresh(subject);
        status.setAttribute(2, "done");
        status.setAttribute(3, "SUCCESS");
        return status;
    }

    private void lookupProcesses(HostProcessFilterImpl fsObj, DataElement subject) throws Exception {
        Object[] oldDEs;
        if (this.handler == null) {
            throw new Exception("No handler for this system type");
        }
        SortedSet processes = this.handler.lookupProcesses((IHostProcessFilter)fsObj);
        TreeSet<Object> sortedDEs = null;
        List nested = subject.getNestedData();
        if (nested != null && (oldDEs = nested.toArray()) != null && oldDEs.length > 0) {
            sortedDEs = new TreeSet<Object>(this.getProcessDEComparator());
            int i = 0;
            while (i < oldDEs.length) {
                if (fsObj.allows(((DataElement)oldDEs[i]).getValue())) {
                    sortedDEs.add(oldDEs[i]);
                }
                ++i;
            }
        }
        if (processes == null || processes.size() == 0) {
            this.deleteDataElements(fsObj, subject);
            return;
        }
        if (sortedDEs == null || sortedDEs.size() == 0) {
            this.createDataElements(processes.toArray(), subject);
            return;
        }
        Iterator pIter = processes.iterator();
        Iterator deIter = sortedDEs.iterator();
        DataElement nextDE = null;
        IRemoteServerProcess nextP = null;
        UniversalServerProcessImpl nextDEP = null;
        try {
            ProcessComparator comparator = new ProcessComparator();
            nextDE = (DataElement)deIter.next();
            nextDEP = new UniversalServerProcessImpl(nextDE.getValue());
            nextP = (IRemoteServerProcess)pIter.next();
            while (true) {
                int comparison;
                if ((comparison = comparator.compare((Object)nextDEP, (Object)nextP)) < 0) {
                    this._dataStore.deleteObject(subject, nextDE);
                    deIter.remove();
                    nextDE = (DataElement)deIter.next();
                    nextDEP = new UniversalServerProcessImpl(nextDE.getValue());
                }
                if (comparison == 0) {
                    nextDE.setAttribute(3, nextP.getAllProperties());
                    deIter.remove();
                    pIter.remove();
                    nextDE = (DataElement)deIter.next();
                    nextDEP = new UniversalServerProcessImpl(nextDE.getValue());
                    nextP = (IRemoteServerProcess)pIter.next();
                }
                if (comparison <= 0) continue;
                this.createDataElement(nextP, subject);
                pIter.remove();
                nextP = (IRemoteServerProcess)pIter.next();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (!pIter.hasNext() && !deIter.hasNext()) {
                return;
            }
            if (deIter.hasNext()) {
                this.deleteRemainingElements(deIter, subject);
            } else {
                this.createDataElements(processes.toArray(), subject);
            }
            return;
        }
    }

    private void deleteRemainingElements(Iterator iter, DataElement subject) {
        while (iter.hasNext()) {
            DataElement next = (DataElement)iter.next();
            this._dataStore.deleteObject(subject, next);
        }
    }

    private void deleteDataElements(HostProcessFilterImpl fsObj, DataElement subject) {
        List nested = subject.getNestedData();
        if (nested != null) {
            Object[] oldDEs = nested.toArray();
            if (oldDEs == null || oldDEs.length == 0) {
                return;
            }
            int i = 0;
            while (i < oldDEs.length) {
                DataElement currentDE = (DataElement)oldDEs[i];
                if (fsObj.allows(currentDE.getValue())) {
                    this._dataStore.deleteObject(subject, currentDE);
                }
                ++i;
            }
        }
    }

    private void createDataElements(Object[] processes, DataElement subject) {
        if (processes == null || processes.length == 0) {
            return;
        }
        int i = 0;
        while (i < processes.length) {
            this.createDataElement((IRemoteServerProcess)processes[i], subject);
            ++i;
        }
    }

    private void createDataElement(IRemoteServerProcess process, DataElement subject) {
        DataElement dsObj = null;
        dsObj = this._dataStore.createObject(subject, this.deUniversalProcessObject, "" + process.getPid());
        dsObj.setAttribute(3, process.getAllProperties());
    }

    private void handleQueryJobAllProperties(DataElement subject, DataElement status) {
    }

    private DataElement handleKill(DataElement subject, DataElement status) {
        try {
            String statusLine = subject.getValue();
            UniversalServerProcessImpl usp = new UniversalServerProcessImpl(statusLine);
            if (this.handler == null) {
                throw new Exception("No handler for this system type");
            }
            IHostProcess result = this.handler.kill((IHostProcess)usp, subject.getSource());
            if (result == null) {
                this._dataStore.deleteObject(subject.getParent(), subject);
            } else {
                subject.setAttribute(4, "");
                subject.setAttribute(3, result.getAllProperties());
            }
        }
        catch (Exception e) {
            UniversalServerUtilities.logError("UniversalProcessMiner", "handleQuery()", e, this._dataStore);
            status.setAttribute(3, e.getMessage());
            status.setAttribute(2, "done");
            this._dataStore.refresh(status);
            return status;
        }
        this._dataStore.refresh(subject.getParent());
        status.setAttribute(2, "done");
        status.setAttribute(3, "SUCCESS");
        return status;
    }

    public String getVersion() {
        return _minerVersion;
    }
}

