/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api;

import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class LayeredSettingsStore
implements ISettingsStore {
    private final ISettingsStore[] fStores;

    public LayeredSettingsStore(ISettingsStore[] stores) {
        this.fStores = stores;
    }

    public LayeredSettingsStore(ISettingsStore s1, ISettingsStore s2) {
        this(new ISettingsStore[]{s1, s2});
    }

    public String get(String key) {
        int i = 0;
        while (i < this.fStores.length) {
            String value = this.fStores[i].get(key);
            if (value != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        return value;
    }

    public void put(String key, String value) {
        this.fStores[0].put(key, value);
    }
}

