/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.testsubsystem;

import java.util.ArrayList;
import org.eclipse.rse.tests.testsubsystem.TestSubSystemNode;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNode;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNodeContainer;

public class TestSubSystemContainerNode
extends TestSubSystemNode
implements ITestSubSystemNode,
ITestSubSystemNodeContainer {
    private ArrayList fChildren = new ArrayList();

    public TestSubSystemContainerNode(String name) {
        super(name);
    }

    public boolean addChildNode(ITestSubSystemNode node) {
        if (node != null && !this.fChildren.contains(node)) {
            node.setSubSystem(this.getSubSystem());
            node.setParent(this);
            this.fChildren.add(node);
            return true;
        }
        return false;
    }

    public boolean removeChildNode(ITestSubSystemNode node) {
        if (node != null && this.fChildren.contains(node)) {
            if (node instanceof ITestSubSystemNodeContainer) {
                ((ITestSubSystemNodeContainer)((Object)node)).removeAllChildNodes();
            }
            this.fChildren.remove(node);
            return true;
        }
        return false;
    }

    public boolean removeAllChildNodes() {
        if (!this.fChildren.isEmpty()) {
            ITestSubSystemNode[] childs = this.getChildNodes();
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof ITestSubSystemNodeContainer) {
                    ((ITestSubSystemNodeContainer)((Object)childs[i])).removeAllChildNodes();
                }
                ++i;
            }
            this.fChildren.clear();
            return true;
        }
        return false;
    }

    public boolean hasChildNodes() {
        return !this.fChildren.isEmpty();
    }

    public int getChildNodeCount() {
        return this.fChildren.size();
    }

    public ITestSubSystemNode[] getChildNodes() {
        return this.fChildren.toArray(new ITestSubSystemNode[this.fChildren.size()]);
    }
}

