/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.shells;

import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;

public class ShellSubSystemTest
extends RSEBaseConnectionTestCase {
    private String fPropertiesFileName;
    public static String fDefaultPropertiesFile = "localConnection.properties";
    private IShellServiceSubSystem shellSubSystem;
    private IProgressMonitor mon = new NullProgressMonitor();

    public ShellSubSystemTest(String name) {
        this(name, fDefaultPropertiesFile);
    }

    public ShellSubSystemTest(String name, String propertiesFileName) {
        super(name);
        this.fPropertiesFileName = propertiesFileName;
        if (propertiesFileName != null) {
            int idx = propertiesFileName.indexOf("Connection.properties");
            String targetName = propertiesFileName.substring(0, idx);
            this.setTargetName(targetName);
        }
    }

    public static Test suite() {
        String baseName = ShellSubSystemTest.class.getName();
        TestSuite suite = new TestSuite(baseName);
        String[] connTypes = new String[]{"local", "ssh"};
        int i = 0;
        while (i < connTypes.length) {
            String suiteName = connTypes[i];
            String propFileName = connTypes[i] == null ? null : String.valueOf(connTypes[i]) + "Connection.properties";
            TestSuite subSuite = new TestSuite(String.valueOf(baseName) + "." + suiteName);
            Method[] m = ShellSubSystemTest.class.getMethods();
            int j = 0;
            while (j < m.length) {
                String testName = m[j].getName();
                if (testName.startsWith("test")) {
                    subSuite.addTest((Test)new ShellSubSystemTest(testName, propFileName));
                }
                ++j;
            }
            suite.addTest((Test)subSuite);
            ++i;
        }
        return suite;
    }

    protected IShellServiceSubSystem getShellServiceSubSystem() {
        if (this.fPropertiesFileName == null) {
            return null;
        }
        IHost host = this.getHost(this.fPropertiesFileName);
        ISubSystem[] ss = RSECorePlugin.getTheSystemRegistry().getServiceSubSystems(host, IShellService.class);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof ShellServiceSubSystem) {
                return (ShellServiceSubSystem)ss[i];
            }
            ++i;
        }
        return null;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.shellSubSystem = this.getShellServiceSubSystem();
        this.shellSubSystem.checkIsConnected(this.getDefaultProgressMonitor());
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public boolean isWindows() {
        return this.shellSubSystem.getHost().getSystemType().isWindows();
    }

    public void testRunShell() throws Exception {
        if (this.shellSubSystem.canRunShell()) {
            IRemoteCommandShell cmd = this.shellSubSystem.runShell(null, this.mon);
            ShellSubSystemTest.assertNotNull((Object)cmd);
            this.shellSubSystem.sendCommandToShell("echo test" + this.shellSubSystem.getParentRemoteCmdSubSystemConfiguration().getCommandSeparator() + " exit", (Object)cmd, this.mon);
            while (cmd.isActive()) {
                Thread.sleep(200L);
            }
            ShellSubSystemTest.assertNotNull((Object)cmd.getOutputAt(0));
            this.shellSubSystem.removeShell((Object)cmd);
        }
    }

    public void testRunCommand() throws Exception {
        if (this.shellSubSystem.canRunCommand()) {
            String commandSeparator = this.shellSubSystem.getParentRemoteCmdSubSystemConfiguration().getCommandSeparator();
            String cmd = "echo test" + commandSeparator + "exit";
            Object[] results = this.shellSubSystem.runCommand(cmd, null, this.mon);
            boolean matchFound = false;
            Object cmdObject = results[0];
            ShellSubSystemTest.assertTrue((boolean)(cmdObject instanceof IRemoteCommandShell));
            while (((IRemoteCommandShell)cmdObject).isActive()) {
                Thread.sleep(200L);
            }
            Object[] result = ((IRemoteCommandShell)cmdObject).listOutput();
            int i = 0;
            while (i < result.length) {
                System.out.println(((IRemoteOutput)result[i]).getText());
                matchFound = ((IRemoteOutput)result[i]).getText().equals("test");
                if (matchFound) break;
                ++i;
            }
            ShellSubSystemTest.assertTrue((String)("Missing output of \"echo test\": " + Arrays.asList(result)), (boolean)matchFound);
        }
    }

    public void testCancelShell() throws Exception {
        if (this.shellSubSystem.canRunShell()) {
            IRemoteCommandShell cmd = this.shellSubSystem.runShell(null, this.mon);
            this.shellSubSystem.cancelShell((Object)cmd, this.mon);
            int tries = 0;
            while (tries < 20 && cmd.isActive()) {
                Thread.sleep(100L);
                ++tries;
            }
            ShellSubSystemTest.assertFalse((String)"Shell not canceled", (boolean)cmd.isActive());
            System.out.println("Shell canceled after " + tries * 100 + " msec.");
        }
    }
}

