/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.framework;

import java.io.StringWriter;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.tests.framework.AnnotatingTestCase;
import org.eclipse.rse.tests.framework.ITestSuiteHolder;
import org.eclipse.rse.tests.framework.ITestSuiteHolderListener;
import org.eclipse.ui.IActionFilter;

public abstract class AbstractTestSuiteHolder
implements ITestSuiteHolder,
TestListener,
IActionFilter {
    private Calendar myCalendar = null;
    private TestResult testResult = null;
    private StringWriter stringWriter = null;
    private IProgressMonitor monitor = null;
    private List listeners = new Vector();
    private TestFailure failure;

    protected AbstractTestSuiteHolder() {
    }

    public final void run(IProgressMonitor monitor) {
        this.stringWriter = new StringWriter(1000);
        this.myCalendar = Calendar.getInstance();
        TestSuite suite = this.getTestSuite();
        monitor.beginTask("Running " + suite.getName(), suite.countTestCases());
        this.setTestResult(new TestResult());
        this.monitor = monitor;
        this.testResult.addListener((TestListener)this);
        suite.run(this.testResult);
        this.testResult.removeListener((TestListener)this);
        this.monitor = null;
        monitor.done();
    }

    public final void reset() {
        this.stringWriter = null;
        this.monitor = null;
        this.testResult = null;
        this.myCalendar = null;
        Iterator z = this.listeners.iterator();
        while (z.hasNext()) {
            ITestSuiteHolderListener listener = (ITestSuiteHolderListener)z.next();
            listener.testHolderReset(this);
        }
    }

    public final String getResultString() {
        if (this.stringWriter == null) {
            return "Results not available.\n";
        }
        return this.stringWriter.toString();
    }

    public final void addListener(ITestSuiteHolderListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(ITestSuiteHolderListener listener) {
        this.listeners.remove(listener);
    }

    public final synchronized TestResult getTestResult() {
        return this.testResult;
    }

    private final synchronized void setTestResult(TestResult testResult) {
        this.testResult = testResult;
    }

    public final Calendar getLastRunTime() {
        return this.myCalendar;
    }

    public final void addError(Test test, Throwable t) {
        this.failure = new TestFailure(test, t);
    }

    public final void addFailure(Test test, AssertionFailedError t) {
        this.failure = new TestFailure(test, (Throwable)t);
    }

    public final void startTest(Test test) {
        this.failure = null;
        if (test instanceof AnnotatingTestCase) {
            AnnotatingTestCase a = (AnnotatingTestCase)test;
            a.reset();
        }
    }

    public final void endTest(Test test) {
        this.monitor.worked(1);
        this.writeRemarks(test);
        if (this.failure != null) {
            this.stringWriter.write(this.failure.trace());
            this.stringWriter.write("*** " + this.failure.toString() + "\n");
        } else {
            this.stringWriter.write("*** " + test.toString() + " passed\n");
        }
        Iterator z = this.listeners.iterator();
        while (z.hasNext()) {
            ITestSuiteHolderListener listener = (ITestSuiteHolderListener)z.next();
            listener.testEnded(this);
        }
        if (this.monitor.isCanceled()) {
            this.testResult.stop();
        }
    }

    private void writeRemarks(Test test) {
        if (test instanceof AnnotatingTestCase) {
            this.stringWriter.write("\n");
            AnnotatingTestCase a = (AnnotatingTestCase)test;
            this.stringWriter.write(a.getAnnotations());
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        return target == this && name.equals("hasResult") && value.equals("true") && this.testResult != null;
    }

    public abstract TestSuite getTestSuite();

    public abstract String getName();
}

