/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.services.RSEServicesMessages;
import org.eclipse.rse.internal.services.dstore.ServiceResources;
import org.eclipse.rse.internal.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.internal.services.dstore.files.DStoreInputStream;
import org.eclipse.rse.internal.services.dstore.files.DStoreOutputStream;
import org.eclipse.rse.internal.services.dstore.files.DStoreVirtualHostFile;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.dstore.AbstractDStoreService;
import org.eclipse.rse.services.dstore.util.DownloadListener;
import org.eclipse.rse.services.dstore.util.FileSystemMessageUtil;
import org.eclipse.rse.services.files.CodePageConverterManager;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IFileServiceCodePageConverter;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.rse.services.files.PendingHostFilePermissions;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;

public class DStoreFileService
extends AbstractDStoreService
implements IFileService,
IFilePermissionsService {
    protected DataElement _uploadLogElement = null;
    protected Map _fileElementMap = new HashMap();
    protected Map _dstoreFileMap = new HashMap();
    private int _bufferUploadSize = 10240;
    private int _bufferDownloadSize = 10240;
    protected ISystemFileTypes _fileTypeRegistry;
    private String remoteEncoding;
    protected boolean unixStyle = false;
    private static String[] _filterAttributes = new String[]{"attributes", "filter", "filter.id", "doc", "", "", "false", "2"};
    static /* synthetic */ Class class$0;

    public DStoreFileService(IDataStoreProvider dataStoreProvider, ISystemFileTypes fileTypeRegistry) {
        super(dataStoreProvider);
        this._fileTypeRegistry = fileTypeRegistry;
    }

    public void uninitService(IProgressMonitor monitor) {
        this._fileElementMap.clear();
        this._dstoreFileMap.clear();
        this._uploadLogElement = null;
        this.remoteEncoding = null;
        super.uninitService(monitor);
    }

    public String getName() {
        return ServiceResources.DStore_File_Service_Label;
    }

    public String getDescription() {
        return ServiceResources.DStore_File_Service_Description;
    }

    public void setBufferUploadSize(int size) {
        this._bufferUploadSize = size;
    }

    public void setBufferDownloadSize(int size) {
        this._bufferDownloadSize = size;
    }

    protected int getBufferUploadSize() {
        return this._bufferUploadSize;
    }

    protected int getBufferDownloadSize() {
        return this._bufferDownloadSize;
    }

    protected String getMinerId() {
        return "org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner";
    }

    protected DataElement getMinerElement() {
        super.getMinerElement();
        if (this._minerElement == null) {
            this._minerElement = this.getMinerElement("com.ibm.etools.systems.universal.miners.UniversalFileSystemMiner");
        }
        return this._minerElement;
    }

    private boolean isOldIBMMiner() {
        if (this._minerElement != null) {
            return this._minerElement.getSource().equals("com.ibm.etools.systems.universal.miners.UniversalFileSystemMiner");
        }
        return false;
    }

    protected String getByteStreamHandlerId() {
        if (this.isOldIBMMiner()) {
            return "com.ibm.etools.systems.universal.miners.UniversalByteStreamHandler";
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.dstore.universal.miners.UniversalByteStreamHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    protected String getDataStoreRoot() {
        DataStore ds = this.getDataStore();
        if (ds != null) {
            return ds.getAttribute(7);
        }
        return null;
    }

    protected String prepareForDownload(String localPath) {
        int index = localPath.lastIndexOf(File.separator);
        String parentDir = localPath.substring(0, index + 1);
        this.setDataStoreRoot(parentDir);
        String dataStoreLocalPath = localPath.substring(index + 1);
        if (!dataStoreLocalPath.startsWith("/")) {
            dataStoreLocalPath = "/" + dataStoreLocalPath;
        }
        return dataStoreLocalPath;
    }

    protected void setDataStoreRoot(String root) {
        DataStore ds = this.getDataStore();
        if (ds != null) {
            ds.setAttribute(7, root);
        }
    }

    protected DataElement findUploadLog() {
        DataElement minerInfo = this.getMinerElement();
        DataStore ds = this.getDataStore();
        if (this._uploadLogElement == null || this._uploadLogElement.getDataStore() != ds) {
            if (ds != null) {
                this._uploadLogElement = ds.find(minerInfo, 2, "universal.uploadlog", 2);
            } else {
                return null;
            }
        }
        return this._uploadLogElement;
    }

    protected DataElement getAttributes(String fileNameFilter, boolean showHidden) {
        DataStore ds = this.getDataStore();
        if (ds != null) {
            String[] clonedAttributes = (String[])_filterAttributes.clone();
            clonedAttributes[1] = fileNameFilter;
            DataElement attributes = ds.createTransientObject(clonedAttributes);
            String version = "version_1";
            StringBuffer buffer = new StringBuffer();
            String filter = fileNameFilter == null ? "*" : fileNameFilter;
            buffer.append(version).append("|").append(filter).append("|").append(showHidden);
            attributes.setAttribute(4, buffer.toString());
            return attributes;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upload(InputStream inputStream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        bufInputStream = null;
        isCancelled = false;
        try {
            try {
                byteStreamHandlerId = this.getByteStreamHandlerId();
                remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
                this.getDataStore().replaceFile(remotePath, new byte[0], 0, isBinary, byteStreamHandlerId);
                this.findUploadLog();
                buffer_size = this.getBufferUploadSize();
                bufInputStream = new BufferedInputStream(inputStream, buffer_size);
                buffer = new byte[buffer_size];
                numToRead = 0;
                available = bufInputStream.available();
                localLineSep = System.getProperty("line.separator");
                targetLineSep = "\n";
                if (!this.unixStyle) {
                    targetLineSep = "\r\n";
                }
                localLineSepLength = localLineSep.length();
                if (true) ** GOTO lbl49
                do {
                    if ((bytesRead = bufInputStream.read(buffer, 0, numToRead = available < buffer_size ? available : buffer_size)) == -1) {
                        return;
                    }
                    if (!isBinary && hostEncoding != null) {
                        tempStr = new String(buffer, 0, bytesRead);
                        if (!localLineSep.equals(targetLineSep)) {
                            index = tempStr.indexOf(localLineSep);
                            buf = new StringBuffer();
                            lineEndFound = false;
                            lastIndex = 0;
                            while (index != -1) {
                                buf = buf.append(tempStr.substring(lastIndex, index));
                                buf = buf.append(targetLineSep);
                                if (!lineEndFound) {
                                    lineEndFound = true;
                                }
                                lastIndex = index + localLineSepLength;
                                index = tempStr.indexOf(localLineSep, lastIndex);
                            }
                            if (lineEndFound) {
                                buf = buf.append(tempStr.substring(lastIndex));
                                tempStr = buf.toString();
                            }
                        }
                        convBytes = tempStr.getBytes(hostEncoding);
                        this.getDataStore().replaceAppendFile(remotePath, convBytes, convBytes.length, true, byteStreamHandlerId);
                    } else {
                        this.getDataStore().replaceAppendFile(remotePath, buffer, bytesRead, true, byteStreamHandlerId);
                    }
                    if (monitor != null) {
                        isCancelled = monitor.isCanceled();
                    }
                    available = bufInputStream.available();
lbl49:
                    // 2 sources

                    if (available <= 0) return;
                } while (!isCancelled);
                return;
            }
            catch (FileNotFoundException e) {
                throw new RemoteFileIOException((Exception)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RemoteFileIOException((Exception)e);
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
            catch (Exception e) {
                throw new RemoteFileIOException(e);
            }
        }
        finally {
            try {
                if (bufInputStream != null) {
                    bufInputStream.close();
                }
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
            if (isCancelled) {
                throw new SystemOperationCancelledException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void upload(File file, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        block39: {
            block40: {
                inputStream = null;
                bufInputStream = null;
                isCancelled = false;
                transferSuccessful = false;
                totalBytes = file.length();
                uploadLog = this.findUploadLog();
                remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
                ds = this.getDataStore();
                stdRemotePath = remotePath.replace('\\', '/');
                numTransfers = 0;
                result = ds.find(uploadLog, 2, stdRemotePath, 1);
                if (result == null) {
                    result = ds.createObject(uploadLog, "uploadstatus", stdRemotePath);
                    result.setAttribute(4, "running");
                    result.setAttribute(3, "");
                    cmd = this.getDataStore().findCommandDescriptor("C_SET");
                    ds.command(cmd, uploadLog, true);
                }
                try {
                    try {
                        byteStreamHandlerId = this.getByteStreamHandlerId();
                        this.getDataStore().replaceFile(remotePath, new byte[0], 0, isBinary, byteStreamHandlerId);
                        if (monitor != null) {
                            monitor.setTaskName(file.getName());
                        }
                        buffer_size = this.getBufferUploadSize();
                        inputStream = new FileInputStream(file);
                        bufInputStream = new BufferedInputStream(inputStream, buffer_size);
                        buffer = new byte[buffer_size];
                        numToRead = 0;
                        available = bufInputStream.available();
                        totalSent = 0L;
                        localLineSep = System.getProperty("line.separator");
                        targetLineSep = "\n";
                        if (!this.unixStyle) {
                            targetLineSep = "\r\n";
                        }
                        localLineSepLength = localLineSep.length();
                        codePageConverter = CodePageConverterManager.getCodePageConverter((String)hostEncoding, (IFileService)this);
                        while (available > 0 && !isCancelled) {
                            ++numTransfers;
                            numToRead = available < buffer_size ? available : buffer_size;
                            bytesRead = bufInputStream.read(buffer, 0, numToRead);
                            if (bytesRead == -1) break;
                            totalSent += (long)bytesRead;
                            if (!isBinary && srcEncoding != null && hostEncoding != null) {
                                tempStr = new String(buffer, 0, bytesRead, srcEncoding);
                                if (!localLineSep.equals(targetLineSep)) {
                                    index = tempStr.indexOf(localLineSep);
                                    buf = new StringBuffer();
                                    lineEndFound = false;
                                    lastIndex = 0;
                                    while (index != -1) {
                                        buf = buf.append(tempStr.substring(lastIndex, index));
                                        buf = buf.append(targetLineSep);
                                        if (!lineEndFound) {
                                            lineEndFound = true;
                                        }
                                        lastIndex = index + localLineSepLength;
                                        index = tempStr.indexOf(localLineSep, lastIndex);
                                    }
                                    if (lineEndFound) {
                                        buf = buf.append(tempStr.substring(lastIndex));
                                        tempStr = buf.toString();
                                    }
                                }
                                convBytes = codePageConverter.convertClientStringToRemoteBytes(remotePath, tempStr, hostEncoding, (IFileService)this);
                                this.getDataStore().replaceAppendFile(remotePath, convBytes, convBytes.length, true, byteStreamHandlerId);
                            } else {
                                this.getDataStore().replaceAppendFile(remotePath, buffer, bytesRead, true, byteStreamHandlerId);
                            }
                            if (monitor != null) {
                                percent = (double)totalSent * 1.0 / (double)totalBytes;
                                monitor.worked(bytesRead);
                                str = MessageFormat.format(ServiceResources.DStore_Service_Percent_Complete_Message, new Object[]{new Long(totalSent / 1024L), new Long(totalBytes / 1024L), new Double(percent)});
                                monitor.subTask(str);
                                isCancelled = monitor.isCanceled();
                            }
                            available = bufInputStream.available();
                        }
                        transferSuccessful = true;
                        break block39;
                    }
                    catch (FileNotFoundException e) {
                        throw new RemoteFileIOException((Exception)e);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RemoteFileIOException((Exception)e);
                    }
                    catch (IOException e) {
                        throw new RemoteFileIOException((Exception)e);
                    }
                    catch (Exception e) {
                        throw new RemoteFileIOException(e);
                    }
                }
                catch (Throwable var38_41) {
                    try {
                        if (bufInputStream != null) {
                            bufInputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RemoteFileIOException((Exception)e);
                    }
                    if (isCancelled) {
                        throw new SystemOperationCancelledException();
                    }
                    if (totalBytes <= 0L || !transferSuccessful) break block40;
                    if (numTransfers > 1) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException v0) {}
                    }
                    resultStr = result.getSource();
                    ** while (!resultStr.equals((Object)"success"))
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException v1) {}
                    resultStr = result.getSource();
                    if (!resultStr.equals("failed") && (monitor == null || !monitor.isCanceled())) continue;
                    msgTxt = NLS.bind((String)ServiceResources.FILEMSG_COPY_FILE_FAILED, (Object)remotePath);
                    msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", 4, msgTxt);
                    throw new SystemMessageException((SystemMessage)msg);
                }
            }
            throw var38_41;
        }
        try {
            if (bufInputStream != null) {
                bufInputStream.close();
            }
        }
        catch (IOException e) {
            throw new RemoteFileIOException((Exception)e);
        }
        if (isCancelled) {
            throw new SystemOperationCancelledException();
        }
        if (totalBytes > 0L && transferSuccessful) {
            if (numTransfers > 1) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException v2) {}
            }
            resultStr = result.getSource();
            while (!resultStr.equals("success")) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException v3) {}
                resultStr = result.getSource();
                if (!resultStr.equals("failed") && (monitor == null || !monitor.isCanceled())) continue;
                msgTxt = NLS.bind((String)ServiceResources.FILEMSG_COPY_FILE_FAILED, (Object)remotePath);
                msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", 4, msgTxt);
                throw new SystemMessageException((SystemMessage)msg);
            }
        }
    }

    public void download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String encoding, IProgressMonitor monitor) throws SystemMessageException {
        DataStore ds = this.getDataStore();
        DataElement universaltemp = this.getMinerElement();
        int mode = -2;
        this.makeSureLocalExists(localFile);
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
        DataElement de = this.getElementFor(remotePath);
        if (de.getType().equals("universal.FilterObject")) {
            DStoreHostFile hostFile = (DStoreHostFile)this.getFile(remoteParent, remoteFile, monitor);
            de = hostFile._element;
        }
        long fileLength = DStoreHostFile.getFileLength(de.getSource());
        if (monitor != null) {
            monitor.beginTask(remotePath, (int)fileLength);
        }
        DataElement remoteElement = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
        DataElement localElement = ds.createObject(universaltemp, de.getType(), localFile.getAbsolutePath(), encoding);
        DataElement bufferSizeElement = ds.createObject(universaltemp, "buffer_size", "" + this.getBufferDownloadSize(), "");
        DataElement queryCmd = this.getCommandDescriptor(de, "C_DOWNLOAD_FILE");
        ArrayList<DataElement> argList = new ArrayList<DataElement>();
        argList.add(remoteElement);
        argList.add(localElement);
        argList.add(bufferSizeElement);
        DataElement subject = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
        DataElement status = ds.command(queryCmd, argList, subject);
        if (status == null) {
            System.out.println("no download descriptor for " + remoteElement);
        }
        try {
            DownloadListener dlistener = new DownloadListener(status, localFile, remotePath, fileLength, monitor);
            if (!dlistener.isDone()) {
                try {
                    dlistener.waitForUpdate();
                }
                catch (InterruptedException interruptedException) {
                    if (monitor != null && !monitor.isCanceled()) {
                        monitor.setCanceled(true);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        long localBytes = localFile.length();
        long lastLocalBytes = 0L;
        while (!(localBytes >= fileLength || monitor != null && monitor.isCanceled() || lastLocalBytes == localBytes)) {
            try {
                lastLocalBytes = localBytes;
                Thread.sleep(100L);
                localBytes = localFile.length();
            }
            catch (Exception e) {
                throw new RemoteFileIOException(e);
            }
        }
        List resultList = remoteElement.getNestedData();
        DataElement resultChild = null;
        int i = 0;
        while (i < resultList.size()) {
            resultChild = (DataElement)resultList.get(i);
            if (resultChild.getType().equals("universal.download.success")) {
                String localEncoding;
                if (!isBinary && fileLength > 0L && !(localEncoding = SystemEncodingUtil.getInstance().getLocalDefaultEncoding()).equals(encoding)) {
                    IFileServiceCodePageConverter codePageConverter = CodePageConverterManager.getCodePageConverter((String)encoding, (IFileService)this);
                    try {
                        codePageConverter.convertFileFromRemoteEncoding(remotePath, localFile, encoding, localEncoding, (IFileService)this);
                    }
                    catch (RuntimeException e) {
                        Throwable ex = e.getCause();
                        StringBuffer msgTxtBuffer = new StringBuffer(RSEServicesMessages.FILEMSG_OPERATION_FAILED);
                        msgTxtBuffer.append('\n');
                        msgTxtBuffer.append('\n');
                        msgTxtBuffer.append(remotePath);
                        msgTxtBuffer.append('\n');
                        msgTxtBuffer.append(encoding);
                        msgTxtBuffer.append(" -> ");
                        msgTxtBuffer.append(localEncoding);
                        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1002", 4, msgTxtBuffer.toString(), ex);
                        throw new SystemMessageException((SystemMessage)msg);
                    }
                }
            } else {
                String msgDetails;
                String msgTxt;
                if (resultChild.getType().equals("FileNotFoundException")) {
                    localFile.delete();
                    msgTxt = ServiceResources.FILEMSG_SECURITY_ERROR;
                    msgDetails = NLS.bind((String)ServiceResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)"FileNotFoundException");
                    SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1001", 4, msgTxt, msgDetails);
                    throw new SystemMessageException((SystemMessage)msg);
                }
                if (resultChild.getType().equals("UnsupportedEncodingException")) {
                    UnsupportedEncodingException e = new UnsupportedEncodingException(resultChild.getName());
                    throw new RemoteFileIOException((Exception)e);
                }
                if (resultChild.getType().equals("IOException")) {
                    localFile.delete();
                    msgTxt = ServiceResources.FILEMSG_SECURITY_ERROR;
                    msgDetails = NLS.bind((String)ServiceResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)"IOException");
                    SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1001", 4, msgTxt, msgDetails);
                    throw new SystemMessageException((SystemMessage)msg);
                }
            }
            ++i;
        }
    }

    private void makeSureLocalExists(File localFile) throws SystemMessageException {
        if (!localFile.exists()) {
            File parentDir = localFile.getParentFile();
            parentDir.mkdirs();
        }
        try {
            if (localFile.exists()) {
                localFile.delete();
            }
            localFile.createNewFile();
        }
        catch (IOException e) {
            SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.services.dstore", 4, e.getLocalizedMessage());
            throw new SystemMessageException((SystemMessage)message);
        }
    }

    public void downloadMultiple(String[] remoteParents, String[] remoteFiles, File[] localFiles, boolean[] isBinaries, String[] hostEncodings, IProgressMonitor monitor) throws SystemMessageException {
        ArrayList<DownloadListener> downloadListeners = new ArrayList<DownloadListener>();
        ArrayList<DataElement> remoteElements = new ArrayList<DataElement>();
        DataStore ds = this.getDataStore();
        DataElement universaltemp = this.getMinerElement();
        String[] paths = this.getPathsFor(remoteParents, remoteFiles);
        DataElement[] des = this.getElementsFor(paths);
        DataElement queryCmd = null;
        DataElement bufferSizeElement = null;
        ArrayList<DataElement> unresolved = new ArrayList<DataElement>();
        int d = 0;
        while (d < des.length) {
            DataElement de = des[d];
            if (de.getType().equals("universal.FilterObject")) {
                unresolved.add(de);
            }
            ++d;
        }
        if (!unresolved.isEmpty()) {
            String[] parents = new String[unresolved.size()];
            String[] names = new String[unresolved.size()];
            int u = 0;
            while (u < unresolved.size()) {
                DataElement de = (DataElement)unresolved.get(u);
                parents[u] = de.getValue();
                names[u] = de.getName();
                ++u;
            }
            this.getFileMultiple(parents, names, new ArrayList(10), monitor);
        }
        int i = 0;
        while (i < des.length) {
            int mode = -2;
            DataElement de = des[i];
            String remotePath = paths[i];
            File localFile = localFiles[i];
            String hostEncoding = hostEncodings[i];
            this.makeSureLocalExists(localFile);
            long fileLength = DStoreHostFile.getFileLength(de.getSource());
            if (monitor != null) {
                monitor.beginTask(remotePath, (int)fileLength);
            }
            DataElement remoteElement = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
            DataElement localElement = ds.createObject(universaltemp, de.getType(), localFile.getAbsolutePath(), hostEncoding);
            if (bufferSizeElement == null) {
                bufferSizeElement = ds.createObject(universaltemp, "buffer_size", "" + this.getBufferDownloadSize(), "");
            }
            if (queryCmd == null) {
                queryCmd = this.getCommandDescriptor(de, "C_DOWNLOAD_FILE");
            }
            ArrayList<DataElement> argList = new ArrayList<DataElement>();
            argList.add(remoteElement);
            argList.add(localElement);
            argList.add(bufferSizeElement);
            DataElement subject = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
            DataElement status = ds.command(queryCmd, argList, subject);
            DownloadListener dlistener = new DownloadListener(status, localFile, remotePath, fileLength, monitor);
            downloadListeners.add(dlistener);
            remoteElements.add(remoteElement);
            ++i;
        }
        int j = 0;
        while (j < downloadListeners.size()) {
            DownloadListener dlistener;
            block27: {
                dlistener = (DownloadListener)downloadListeners.get(j);
                try {
                    block28: {
                        if (dlistener.isDone()) break block27;
                        try {
                            dlistener.waitForUpdate();
                        }
                        catch (InterruptedException interruptedException) {
                            if (monitor == null || monitor.isCanceled()) break block28;
                            monitor.setCanceled(true);
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            File localFile = localFiles[j];
            long localBytes = localFile.length();
            long lastLocalBytes = 0L;
            long fileLength = dlistener.getTotalLength();
            while (!(localBytes >= fileLength || monitor != null && monitor.isCanceled() || lastLocalBytes == localBytes)) {
                try {
                    lastLocalBytes = localBytes;
                    Thread.sleep(100L);
                    localBytes = localFile.length();
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            DataElement remoteElement = (DataElement)remoteElements.get(j);
            List resultList = remoteElement.getNestedData();
            DataElement resultChild = null;
            if (resultList != null) {
                int i2 = 0;
                while (i2 < resultList.size()) {
                    resultChild = (DataElement)resultList.get(i2);
                    if (resultChild.getType().equals("universal.download.success")) {
                        String localEncoding;
                        if (!isBinaries[j] && fileLength > 0L && !(localEncoding = SystemEncodingUtil.getInstance().getLocalDefaultEncoding()).equals(hostEncodings[j])) {
                            IFileServiceCodePageConverter codePageConverter = CodePageConverterManager.getCodePageConverter((String)hostEncodings[j], (IFileService)this);
                            try {
                                codePageConverter.convertFileFromRemoteEncoding(remoteElement.getName(), localFile, hostEncodings[j], localEncoding, (IFileService)this);
                            }
                            catch (RuntimeException e) {
                                Throwable ex = e.getCause();
                                StringBuffer msgTxtBuffer = new StringBuffer(RSEServicesMessages.FILEMSG_OPERATION_FAILED);
                                msgTxtBuffer.append('\n');
                                msgTxtBuffer.append('\n');
                                msgTxtBuffer.append(remoteFiles[j]);
                                msgTxtBuffer.append('\n');
                                msgTxtBuffer.append(hostEncodings[j]);
                                msgTxtBuffer.append(" -> ");
                                msgTxtBuffer.append(localEncoding);
                                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1002", 4, msgTxtBuffer.toString(), ex);
                                throw new SystemMessageException((SystemMessage)msg);
                            }
                        }
                    } else {
                        String msgDetails;
                        String msgTxt;
                        if (resultChild.getType().equals("FileNotFoundException")) {
                            localFile.delete();
                            msgTxt = ServiceResources.FILEMSG_SECURITY_ERROR;
                            msgDetails = NLS.bind((String)ServiceResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)"FileNotFoundException");
                            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1001", 4, msgTxt, msgDetails);
                            throw new SystemMessageException((SystemMessage)msg);
                        }
                        if (resultChild.getType().equals("UnsupportedEncodingException")) {
                            localFile.delete();
                            msgTxt = ServiceResources.FILEMSG_SECURITY_ERROR;
                            msgDetails = NLS.bind((String)ServiceResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)"UnsupportedEncodingException");
                            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1001", 4, msgTxt, msgDetails);
                            throw new SystemMessageException((SystemMessage)msg);
                        }
                        if (resultChild.getType().equals("IOException")) {
                            localFile.delete();
                            msgTxt = ServiceResources.FILEMSG_SECURITY_ERROR;
                            msgDetails = NLS.bind((String)ServiceResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)"IOException");
                            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1001", 4, msgTxt, msgDetails);
                            throw new SystemMessageException((SystemMessage)msg);
                        }
                        localFile.delete();
                        msgTxt = ServiceResources.FILEMSG_SECURITY_ERROR;
                        msgDetails = NLS.bind((String)ServiceResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)"IOException");
                        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1001", 4, msgTxt, msgDetails);
                        throw new SystemMessageException((SystemMessage)msg);
                    }
                    ++i2;
                }
            }
            ++j;
        }
    }

    public void uploadMultiple(File[] localFiles, String[] remoteParents, String[] remoteFiles, boolean[] isBinaries, String[] srcEncodings, String[] hostEncodings, IProgressMonitor monitor) throws SystemMessageException {
        int i = 0;
        while (i < localFiles.length) {
            File localFile = localFiles[i];
            String remoteParent = remoteParents[i];
            String remoteFile = remoteFiles[i];
            boolean isBinary = isBinaries[i];
            String srcEncoding = srcEncodings[i];
            String hostEncoding = hostEncodings[i];
            this.upload(localFile, remoteParent, remoteFile, isBinary, srcEncoding, hostEncoding, monitor);
            ++i;
        }
    }

    private DataElement getSubjectFor(String remoteParent, String name) {
        DataElement de = null;
        if (name.equals(".") && name.equals(remoteParent)) {
            de = this.getElementFor(name);
        } else {
            StringBuffer buf = new StringBuffer(remoteParent);
            String sep = this.getSeparator(remoteParent);
            if (sep.length() > 0 && !remoteParent.endsWith(sep)) {
                buf.append(sep);
            }
            buf.append(name);
            de = this.getElementFor(buf.toString());
        }
        return de;
    }

    private DataElement[] getSubjectsFor(String[] remoteParents, String[] names) {
        ArrayList<DataElement> subjects = new ArrayList<DataElement>();
        int i = 0;
        while (i < remoteParents.length) {
            DataElement de = this.getSubjectFor(remoteParents[i], names[i]);
            subjects.add(de);
            ++i;
        }
        return subjects.toArray(new DataElement[subjects.size()]);
    }

    public IHostFile getFile(String remoteParent, String name, IProgressMonitor monitor) {
        DataElement de = null;
        de = remoteParent != null && remoteParent.length() > 0 ? this.getSubjectFor(remoteParent, name) : this.getElementFor(name);
        if (de != null) {
            if (this.isOldIBMMiner() && !de.getType().equals("universal.FilterObject")) {
                StringBuffer buf = new StringBuffer();
                if (remoteParent != null) {
                    buf.append(remoteParent);
                    String sep = this.getSeparator(remoteParent);
                    if (sep.length() > 0 && !remoteParent.endsWith(sep)) {
                        buf.append(sep);
                    }
                }
                buf.append(name);
                String fullPath = buf.toString();
                de.setAttribute(2, fullPath);
                de.setAttribute(3, fullPath);
                de.setAttribute(0, "universal.FilterObject");
            }
            this.dsQueryCommand(de, null, "C_QUERY_GET_REMOTE_OBJECT", monitor);
            return this.convertToHostFile(de);
        }
        return null;
    }

    public void getFileMultiple(String[] remoteParents, String[] names, List hostFiles, IProgressMonitor monitor) throws SystemMessageException {
        DataElement[] subjects = this.getSubjectsFor(remoteParents, names);
        String[] queryStrings = new String[remoteParents.length];
        boolean oldMiner = this.isOldIBMMiner();
        int i = 0;
        while (i < queryStrings.length) {
            queryStrings[i] = "C_QUERY_GET_REMOTE_OBJECT";
            if (oldMiner && !subjects[i].getType().equals("universal.FilterObject")) {
                StringBuffer buf = new StringBuffer(remoteParents[i]);
                String sep = this.getSeparator(remoteParents[i]);
                if (sep.length() > 0 && !remoteParents[i].endsWith(sep)) {
                    buf.append(sep);
                }
                buf.append(names[i]);
                String fullPath = buf.toString();
                subjects[i].setAttribute(2, fullPath);
                subjects[i].setAttribute(3, fullPath);
                subjects[i].setAttribute(0, "universal.FilterObject");
            }
            ++i;
        }
        this.dsQueryCommandMulti(subjects, null, queryStrings, monitor);
        IHostFile[] result = this.convertToHostFiles(subjects, "C_QUERY_GET_REMOTE_OBJECT", "*");
        hostFiles.addAll(Arrays.asList(result));
    }

    protected String getSeparator(String parentPath) {
        if (parentPath == null || parentPath.length() < 1) {
            return "/";
        }
        if (parentPath.length() == 1) {
            if (parentPath.charAt(0) == '/') {
                return "";
            }
            return "/";
        }
        if (parentPath.endsWith("#virtual#/")) {
            return "";
        }
        if (parentPath.endsWith("#virtual#")) {
            return "/";
        }
        if (parentPath.charAt(1) == ':') {
            if (parentPath.indexOf("#virtual#") != -1) {
                if (parentPath.endsWith("/")) {
                    return "";
                }
                return "/";
            }
            if (ArchiveHandlerManager.getInstance().isArchive(new File(parentPath))) {
                return "#virtual#/";
            }
            if (parentPath.endsWith("\\")) {
                return "";
            }
            return "\\";
        }
        if (parentPath.charAt(0) == '/') {
            if (ArchiveHandlerManager.getInstance().isArchive(new File(parentPath))) {
                return "#virtual#/";
            }
            if (parentPath.endsWith("/")) {
                return "";
            }
            return "/";
        }
        return "/";
    }

    protected IHostFile convertToHostFile(DataElement element) {
        String type = element.getType();
        DStoreHostFile file = null;
        file = type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject") ? new DStoreVirtualHostFile(element) : new DStoreHostFile(element);
        String path = file.getAbsolutePath();
        this._fileElementMap.put(path, element);
        this._dstoreFileMap.put(path, file);
        return file;
    }

    protected IHostFile[] convertToHostFiles(DataElement[] elements, String queryType, String fileFilter) {
        NamePatternMatcher filematcher = null;
        if (fileFilter.endsWith(",")) {
            String[] types = fileFilter.split(",");
            filematcher = new FileTypeMatcher(types, true);
        } else {
            filematcher = new NamePatternMatcher(fileFilter, true, true);
        }
        ArrayList<IHostFile> results = new ArrayList<IHostFile>(elements.length);
        int i = 0;
        while (i < elements.length) {
            DataElement element = elements[i];
            if (element != null && !element.isDeleted() && element.getType() != null) {
                String type = element.getType();
                if (type.equals("universal.FileObject") || type.equals("universal.VirtualFileObject")) {
                    if (filematcher.matches(element.getName()) && !queryType.equals("C_QUERY_VIEW_FOLDERS")) {
                        results.add(this.convertToHostFile(element));
                    }
                } else if (!queryType.equals("C_QUERY_VIEW_FILES")) {
                    results.add(this.convertToHostFile(element));
                }
            }
            ++i;
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public IHostFile getUserHome() {
        return this.getFile(".", ".", null);
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + fileName;
        DataElement de = this.getElementFor(remotePath);
        DataElement status = this.dsStatusCommand(de, "C_CREATE_FILE", monitor);
        if (status == null) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED);
            throw new SystemMessageException((SystemMessage)msg);
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return new DStoreHostFile(de);
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("failed with exist")) {
            String msgTxt = ServiceResources.FILEMSG_CREATE_FILE_FAILED_EXIST;
            String msgDetails = NLS.bind((String)ServiceResources.FILEMSG_CREATE_FILE_FAILED_EXIST_DETAILS, (Object)remotePath);
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1303", 4, msgTxt, msgDetails);
            throw new SystemMessageException((SystemMessage)msg);
        }
        String msgTxt = ServiceResources.FILEMSG_CREATE_FILE_FAILED;
        String msgDetails = ServiceResources.FILEMSG_CREATE_FILE_FAILED_DETAILS;
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1302", 4, msgTxt, msgDetails);
        SystemMessageException e = new SystemMessageException((SystemMessage)msg);
        RemoteFileSecurityException messageException = new RemoteFileSecurityException((Exception)((Object)e));
        throw messageException;
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + folderName;
        DataElement de = this.getElementFor(remotePath);
        DataElement status = this.dsStatusCommand(de, "C_CREATE_FOLDER", monitor);
        if (status == null) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED));
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return new DStoreHostFile(de);
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("failed with exist")) {
            String msgTxt = ServiceResources.FILEMSG_CREATE_FOLDER_FAILED_EXIST;
            String msgDetails = NLS.bind((String)ServiceResources.FILEMSG_CREATE_FOLDER_FAILED_EXIST_DETAILS, (Object)remotePath);
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1309", 4, msgTxt, msgDetails);
            throw new SystemMessageException((SystemMessage)msg);
        }
        String msgTxt = ServiceResources.FILEMSG_CREATE_FILE_FAILED;
        String msgDetails = NLS.bind((String)ServiceResources.FILEMSG_CREATE_FILE_FAILED_DETAILS, (Object)remotePath);
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1302", 4, msgTxt, msgDetails);
        SystemMessageException e = new SystemMessageException((SystemMessage)msg);
        RemoteFileSecurityException messageException = new RemoteFileSecurityException((Exception)((Object)e));
        throw messageException;
    }

    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        DataElement status;
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + fileName;
        DataElement de = this.getElementFor(remotePath);
        if (de.getType().equals("universal.FilterObject")) {
            this.dsQueryCommand(de, null, "C_QUERY_GET_REMOTE_OBJECT", monitor);
        }
        if ((status = this.dsStatusCommand(de, "C_DELETE", monitor)) == null) {
            throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED));
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED));
        }
        String sourceMsg = FileSystemMessageUtil.getSourceMessage(status);
        if (sourceMsg.equals("success") || sourceMsg.equals("")) {
            return;
        }
        String msgTxt = NLS.bind((String)ServiceResources.FILEMSG_DELETE_FILE_FAILED, (Object)FileSystemMessageUtil.getSourceLocation(status));
        String msgDetails = ServiceResources.FILEMSG_DELETE_FILE_FAILED_DETAILS;
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1300", 4, msgTxt, msgDetails);
        throw new SystemMessageException((SystemMessage)msg);
    }

    public void deleteBatch(String[] remoteParents, String[] fileNames, IProgressMonitor monitor) throws SystemMessageException {
        if (remoteParents.length == 1) {
            this.delete(remoteParents[0], fileNames[0], monitor);
            return;
        }
        ArrayList<DataElement> dataElements = new ArrayList<DataElement>(remoteParents.length);
        int i = 0;
        while (i < remoteParents.length) {
            String remotePath = String.valueOf(remoteParents[i]) + this.getSeparator(remoteParents[i]) + fileNames[i];
            DataElement de = this.getElementFor(remotePath);
            if (de.getType().equals("universal.FilterObject")) {
                this.dsQueryCommand(de, null, "C_QUERY_GET_REMOTE_OBJECT", monitor);
            }
            if (de != null) {
                dataElements.add(de);
            }
            ++i;
        }
        DataElement status = this.dsStatusCommand((DataElement)dataElements.get(0), dataElements, "C_DELETE_BATCH", monitor);
        if (status != null) {
            if (monitor != null && monitor.isCanceled()) {
                throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED));
            }
            String sourceMsg = FileSystemMessageUtil.getSourceMessage(status);
            if (sourceMsg.equals("success") || sourceMsg.equals("")) {
                return;
            }
            String msgTxt = NLS.bind((String)ServiceResources.FILEMSG_DELETE_FILE_FAILED, (Object)FileSystemMessageUtil.getSourceLocation(status));
            String msgDetails = ServiceResources.FILEMSG_DELETE_FILE_FAILED_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1300", 4, msgTxt, msgDetails);
            throw new SystemMessageException((SystemMessage)msg);
        }
        int i2 = 0;
        while (i2 < remoteParents.length) {
            String parent = remoteParents[i2];
            String name = fileNames[i2];
            this.delete(parent, name, monitor);
            ++i2;
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        String oldPath;
        String newPath = null;
        if (remoteParent == null || remoteParent == "") {
            oldPath = oldName;
            newPath = newName;
        } else {
            oldPath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + oldName;
            newPath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + newName;
        }
        DataElement de = this.getElementFor(oldPath);
        if (de.getType().equals("universal.FilterObject")) {
            this.dsQueryCommand(de, null, "C_QUERY_GET_REMOTE_OBJECT", monitor);
        }
        de.setAttribute(4, newPath);
        DataElement status = this.dsStatusCommand(de, "C_RENAME", monitor);
        if (status != null && status.getAttribute(4).equals("failed")) {
            de.setAttribute(4, newName);
            status = this.dsStatusCommand(de, "C_RENAME", monitor);
        }
        if (status == null) {
            throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED));
        }
        if (monitor != null && monitor.isCanceled()) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED);
            throw new SystemMessageException((SystemMessage)msg);
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return;
        }
        String msgTxt = NLS.bind((String)ServiceResources.FILEMSG_RENAME_FILE_FAILED, (Object)FileSystemMessageUtil.getSourceLocation(status));
        String msgDetails = ServiceResources.FILEMSG_RENAME_FILE_FAILED_DETAILS;
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1301", 4, msgTxt, msgDetails);
        throw new SystemMessageException((SystemMessage)msg);
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
        this.rename(remoteParent, oldName, newName, monitor);
        String newPath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + newName;
        oldFile.renameTo(newPath);
    }

    protected void moveByCopy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        this.copy(srcParent, srcName, tgtParent, tgtName, monitor);
        try {
            this.delete(srcParent, srcName, monitor);
        }
        catch (SystemMessageException exc) {
            if (monitor != null && monitor.isCanceled()) {
                this.getFile(tgtParent, tgtName, null);
                this.delete(tgtParent, tgtName, null);
            }
            throw exc;
        }
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        String src = String.valueOf(srcParent) + this.getSeparator(srcParent) + srcName;
        String tgt = String.valueOf(tgtParent) + this.getSeparator(tgtParent) + tgtName;
        boolean isVirtual = ArchiveHandlerManager.isVirtual((String)src) || ArchiveHandlerManager.isVirtual((String)tgt);
        boolean isArchive = ArchiveHandlerManager.getInstance().isRegisteredArchive(tgt);
        if (isVirtual || isArchive) {
            this.moveByCopy(srcParent, srcName, tgtParent, tgtName, monitor);
            return;
        }
        try {
            this.rename("", src, tgt, monitor);
            return;
        }
        catch (SystemMessageException systemMessageException) {
            this.moveByCopy(srcParent, srcName, tgtParent, tgtName, monitor);
            return;
        }
    }

    protected boolean isSpecialChar(char c) {
        return c == '$' || c == '`' || c == '\"' || c == '\\';
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        block7: {
            DataElement cpCmd;
            DataStore ds = this.getDataStore();
            String srcRemotePath = String.valueOf(srcParent) + this.getSeparator(srcParent) + srcName;
            DataElement srcDE = this.getElementFor(srcRemotePath);
            DataElement tgtDE = this.getElementFor(tgtParent);
            if (tgtDE.getType().equals("universal.FilterObject")) {
                this.dsQueryCommand(tgtDE, "C_QUERY_GET_REMOTE_OBJECT", monitor);
            }
            if ((cpCmd = this.getCommandDescriptor(tgtDE, "C_COPY")) != null) {
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                args.add(srcDE);
                DataElement nameObj = ds.createObject(null, "name", tgtName);
                args.add(nameObj);
                DataElement status = ds.command(cpCmd, args, tgtDE, true);
                try {
                    this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                    if (status.getAttribute(4).equals("failed")) {
                        String msgTxt = NLS.bind((String)ServiceResources.FILEMSG_COPY_FILE_FAILED, (Object)srcName);
                        String msgDetails = ServiceResources.FILEMSG_COPY_FILE_FAILED_DETAILS;
                        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1306", 4, msgTxt, msgDetails);
                        throw new SystemMessageException((SystemMessage)msg);
                    }
                    break block7;
                }
                catch (InterruptedException interruptedException) {
                    if (monitor != null && monitor.isCanceled()) {
                        throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED));
                    }
                    if (monitor != null && !monitor.isCanceled()) {
                        monitor.setCanceled(true);
                    }
                    break block7;
                }
            }
            throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED));
        }
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        block10: {
            DataElement cpCmd;
            DataStore ds = this.getDataStore();
            DataElement tgtDE = this.getElementFor(tgtParent);
            if (tgtDE.getType().equals("universal.FilterObject")) {
                this.dsQueryCommand(tgtDE, "C_QUERY_GET_REMOTE_OBJECT", monitor);
            }
            if ((cpCmd = this.getCommandDescriptor(tgtDE, "C_COPY_BATCH")) != null) {
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                int i = 0;
                while (i < srcParents.length) {
                    String srcRemotePath = String.valueOf(srcParents[i]) + this.getSeparator(srcParents[i]) + srcNames[i];
                    DataElement srcDE = this.getElementFor(srcRemotePath);
                    if (srcDE.getType().equals("universal.FilterObject")) {
                        this.dsQueryCommand(srcDE, null, "C_QUERY_GET_REMOTE_OBJECT", monitor);
                    }
                    args.add(srcDE);
                    ++i;
                }
                DataElement status = ds.command(cpCmd, args, tgtDE, true);
                try {
                    this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                    if (status.getAttribute(4).equals("failed")) {
                        String msgTxt = NLS.bind((String)ServiceResources.FILEMSG_COPY_FILE_FAILED, (Object)srcNames[0]);
                        String msgDetails = ServiceResources.FILEMSG_COPY_FILE_FAILED_DETAILS;
                        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEF1306", 4, msgTxt, msgDetails);
                        throw new SystemMessageException((SystemMessage)msg);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (monitor != null && monitor.isCanceled()) {
                        throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED));
                    }
                    if (monitor == null || monitor.isCanceled()) break block10;
                    monitor.setCanceled(true);
                }
            } else {
                int i = 0;
                while (i < srcParents.length) {
                    String parent = srcParents[i];
                    String name = srcNames[i];
                    this.copy(parent, name, tgtParent, name, monitor);
                    ++i;
                }
            }
        }
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        DataStore ds = this.getDataStore();
        DataElement universaltemp = this.getMinerElement();
        DataElement deObj = ds.createObject(universaltemp, "universal.FilterObject", "", "", "", false);
        DataElement[] results = this.dsQueryCommand(deObj, "C_QUERY_ROOTS", monitor);
        return this.convertToHostFiles(results, "C_QUERY_ROOTS", "*");
    }

    private String getQueryString(int fileType) {
        String queryString = null;
        switch (fileType) {
            case 1: {
                queryString = "C_QUERY_VIEW_FILES";
                break;
            }
            case 2: {
                queryString = "C_QUERY_VIEW_FOLDERS";
                break;
            }
            default: {
                queryString = "C_QUERY_VIEW_ALL";
            }
        }
        return queryString;
    }

    private String[] getQueryStrings(int[] fileTypes) {
        String[] queryStrings = new String[fileTypes.length];
        int i = 0;
        while (i < fileTypes.length) {
            switch (fileTypes[i]) {
                case 1: {
                    queryStrings[i] = "C_QUERY_VIEW_FILES";
                    break;
                }
                case 2: {
                    queryStrings[i] = "C_QUERY_VIEW_FOLDERS";
                    break;
                }
                default: {
                    queryStrings[i] = "C_QUERY_VIEW_ALL";
                }
            }
            ++i;
        }
        return queryStrings;
    }

    public IHostFile[] list(String remoteParent, String fileFilter, int fileType, IProgressMonitor monitor) {
        String queryString = this.getQueryString(fileType);
        return this.fetch(remoteParent, fileFilter, queryString, monitor);
    }

    public void listMultiple(String[] remoteParents, String[] fileFilters, int[] fileTypes, List hostFiles, IProgressMonitor monitor) throws SystemMessageException {
        String[] queryStrings = this.getQueryStrings(fileTypes);
        IHostFile[] result = this.fetchMulti(remoteParents, fileFilters, queryStrings, monitor);
        hostFiles.addAll(Arrays.asList(result));
    }

    public void listMultiple(String[] remoteParents, String[] fileFilters, int fileType, List hostFiles, IProgressMonitor monitor) throws SystemMessageException {
        String queryString = this.getQueryString(fileType);
        String[] queryStrings = new String[remoteParents.length];
        int i = 0;
        while (i < remoteParents.length) {
            queryStrings[i] = queryString;
            ++i;
        }
        IHostFile[] result = this.fetchMulti(remoteParents, fileFilters, queryStrings, monitor);
        hostFiles.addAll(Arrays.asList(result));
    }

    protected String[] getPathsFor(String[] remoteParents, String[] remoteFiles) {
        String[] results = new String[remoteParents.length];
        String sep = null;
        int i = 0;
        while (i < remoteParents.length) {
            String remoteParent = remoteParents[i];
            String remoteFile = remoteFiles[i];
            if (sep == null) {
                sep = this.getSeparator(remoteParent);
            }
            results[i] = String.valueOf(remoteParent) + sep + remoteFile;
            ++i;
        }
        return results;
    }

    protected DataElement[] getElementsFor(String[] paths) {
        DataElement[] results = new DataElement[paths.length];
        int i = 0;
        while (i < paths.length) {
            results[i] = this.getElementFor(paths[i]);
            ++i;
        }
        return results;
    }

    protected DataElement getElementFor(String path) {
        DataStore ds;
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        if ((ds = this.getDataStore()) == null) {
            return null;
        }
        String normalizedPath = PathUtility.normalizeUnknown((String)path);
        DataElement element = (DataElement)this._fileElementMap.get(normalizedPath);
        if (element != null) {
            if (element.isDeleted()) {
                this._fileElementMap.remove(normalizedPath);
                element = null;
            } else {
                String fparent = element.getValue();
                StringBuffer pathBuf = new StringBuffer(fparent);
                String sep = PathUtility.getSeparator((String)fparent);
                if (!fparent.endsWith(sep)) {
                    pathBuf.append(sep);
                }
                pathBuf.append(element.getName());
                if (!normalizedPath.equals(pathBuf.toString())) {
                    this._fileElementMap.remove(normalizedPath);
                    element = null;
                }
            }
        }
        if (element == null || element.isDeleted()) {
            DataElement universaltemp = this.getMinerElement();
            element = ds.createObject(universaltemp, "universal.FilterObject", normalizedPath, normalizedPath, "", false);
        }
        return element;
    }

    public IHostFile getHostFile(String path) {
        return (IHostFile)this._dstoreFileMap.get(path);
    }

    protected IHostFile[] fetch(String remoteParent, String fileFilter, String queryType, IProgressMonitor monitor) {
        DataStore ds = this.getDataStore();
        if (ds == null) {
            return new IHostFile[0];
        }
        DataElement deObj = this.getElementFor(remoteParent);
        if (deObj == null) {
            DataElement universaltemp = this.getMinerElement();
            ds.createObject(universaltemp, "universal.FilterObject", remoteParent, remoteParent, "", false);
        }
        DataElement attributes = this.getAttributes(fileFilter, true);
        ArrayList<DataElement> args = new ArrayList<DataElement>(1);
        args.add(attributes);
        DataElement[] results = this.dsQueryCommand(deObj, args, queryType, monitor);
        return this.convertToHostFiles(results, queryType, fileFilter);
    }

    protected IHostFile[] fetchMulti(String[] remoteParents, String[] fileFilters, String[] queryTypes, IProgressMonitor monitor) {
        DataStore ds = this.getDataStore();
        if (ds == null) {
            return new IHostFile[0];
        }
        ArrayList[] argses = new ArrayList[remoteParents.length];
        DataElement[] subjects = new DataElement[remoteParents.length];
        int i = 0;
        while (i < remoteParents.length) {
            DataElement deObj = this.getElementFor(remoteParents[i]);
            if (deObj == null) {
                DataElement universaltemp = this.getMinerElement();
                deObj = ds.createObject(universaltemp, "universal.FilterObject", remoteParents[i], remoteParents[i], "", false);
            }
            subjects[i] = deObj;
            DataElement attributes = this.getAttributes(fileFilters[i], true);
            ArrayList<DataElement> args = new ArrayList<DataElement>(1);
            args.add(attributes);
            argses[i] = args;
            ++i;
        }
        List consolidatedResults = this.dsQueryCommandMulti(subjects, argses, queryTypes, monitor);
        ArrayList<IHostFile> convertedResults = new ArrayList<IHostFile>();
        int r = 0;
        while (r < consolidatedResults.size()) {
            IHostFile[] results = this.convertToHostFiles((DataElement[])consolidatedResults.get(r), queryTypes[r], fileFilters[r]);
            int c = 0;
            while (c < results.length) {
                convertedResults.add(results[c]);
                ++c;
            }
            ++r;
        }
        return convertedResults.toArray(new IHostFile[consolidatedResults.size()]);
    }

    public boolean isCaseSensitive() {
        return this.unixStyle;
    }

    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        DataElement setCmd;
        DataStore ds;
        String remotePath = String.valueOf(parent) + this.getSeparator(parent) + name;
        DataElement de = this.getElementFor(remotePath);
        if (de.getType().equals("universal.FilterObject")) {
            this.dsQueryCommand(de, null, "C_QUERY_GET_REMOTE_OBJECT", monitor);
        }
        if ((ds = de.getDataStore()) != null && (setCmd = this.getCommandDescriptor(de, "C_SET_LASTMODIFIED")) != null) {
            de.setAttribute(4, String.valueOf(timestamp));
            ds.command(setCmd, de, true);
            return;
        }
        throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED));
    }

    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        DataElement setCmd;
        DataStore ds;
        String remotePath = String.valueOf(parent) + this.getSeparator(parent) + name;
        DataElement de = this.getElementFor(remotePath);
        if (de.getType().equals("universal.FilterObject")) {
            this.dsQueryCommand(de, null, "C_QUERY_GET_REMOTE_OBJECT", monitor);
        }
        if ((ds = de.getDataStore()) != null && (setCmd = this.getCommandDescriptor(de, "C_SET_READONLY")) != null) {
            String flag = readOnly ? "true" : "false";
            de.setAttribute(4, flag);
            DataElement status = ds.command(setCmd, de, true);
            try {
                this.getStatusMonitor(ds).waitForUpdate(status);
            }
            catch (Exception e) {
                throw new RemoteFileIOException(e);
            }
            return;
        }
        throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.dstore", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED));
    }

    public String getEncoding(IProgressMonitor monitor) throws SystemMessageException {
        DataStore ds;
        if (this.remoteEncoding == null && (ds = this.getDataStore()) != null) {
            DataElement encodingElement = ds.createObject(null, "universal.temp", "");
            DataElement queryCmd = ds.localDescriptorQuery(encodingElement.getDescriptor(), "C_SYSTEM_ENCODING");
            DataElement status = ds.command(queryCmd, encodingElement, true);
            try {
                this.getStatusMonitor(ds).waitForUpdate(status);
            }
            catch (Exception e) {
                throw new RemoteFileIOException(e);
            }
            this.remoteEncoding = encodingElement.getValue();
        }
        return this.remoteEncoding;
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
        int mode = isBinary ? -2 : -1;
        DStoreInputStream inputStream = new DStoreInputStream(this.getDataStore(), remotePath, this.getMinerElement(), this.getEncoding(monitor), mode, this.getBufferDownloadSize());
        return inputStream;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        int options = isBinary ? 0 : 2;
        return this.getOutputStream(remoteParent, remoteFile, options, monitor);
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, int options, IProgressMonitor monitor) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
        int mode = (options & 2) == 0 ? -2 : -1;
        DStoreOutputStream outputStream = new DStoreOutputStream(this.getDataStore(), remotePath, this.getEncoding(monitor), mode, this.unixStyle, options);
        return outputStream;
    }

    public void setIsUnixStyle(boolean isUnixStyle) {
        this.unixStyle = isUnixStyle;
    }

    public boolean supportsEncodingConversion() {
        return true;
    }

    public IHostFilePermissions getFilePermissions(IHostFile rfile, IProgressMonitor monitor) throws SystemMessageException {
        DataElement remoteFile;
        DataElement status;
        DStoreHostFile file = (DStoreHostFile)rfile;
        IHostFilePermissions result = file.getPermissions();
        if ((result == null || result instanceof PendingHostFilePermissions) && (status = this.dsStatusCommand(remoteFile = file.getDataElement(), "C_QUERY_FILE_PERMISSIONS", monitor)) != null) {
            int permissionsInt = 0;
            String permissionsStr = status.getSource();
            if (permissionsStr != null && permissionsStr.length() > 0) {
                String[] permAttributes = permissionsStr.split("\\|");
                String accessString = permAttributes[0];
                try {
                    int accessInt;
                    permissionsInt = accessInt = Integer.parseInt(accessString, 8);
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
                String user = permAttributes[1];
                String group = permAttributes[2];
                result = new HostFilePermissions(permissionsInt, user, group);
                file.setPermissions(result);
            }
        }
        return result;
    }

    public void setFilePermissions(IHostFile file, IHostFilePermissions permissions, IProgressMonitor monitor) throws SystemMessageException {
        DataElement remoteFile = ((DStoreHostFile)file).getDataElement();
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        int bits = permissions.getPermissionBits();
        String permissionsInOctal = Integer.toOctalString(bits);
        String user = permissions.getUserOwner();
        String group = permissions.getGroupOwner();
        String permissionsStr = String.valueOf(permissionsInOctal) + '|' + user + '|' + group;
        DataElement newPermissionsElement = this.getDataStore().createObject(null, "permissions", permissionsStr);
        args.add(newPermissionsElement);
        DataElement status = this.dsStatusCommand(remoteFile, args, "C_SET_FILE_PERMISSIONS", monitor);
        if (status != null && file instanceof IHostFilePermissionsContainer) {
            ((IHostFilePermissionsContainer)file).setPermissions(permissions);
        }
    }

    public int getCapabilities(IHostFile file) {
        int capabilities = 0;
        if (file == null) {
            capabilities = 63;
        } else {
            if (file instanceof DStoreVirtualHostFile) {
                return capabilities;
            }
            DataElement remoteFile = ((DStoreHostFile)file).getDataElement();
            DataElement getCmd = this.getCommandDescriptor(remoteFile, "C_QUERY_FILE_PERMISSIONS");
            DataElement setCmd = this.getCommandDescriptor(remoteFile, "C_SET_FILE_PERMISSIONS");
            if (getCmd != null) {
                capabilities |= 7;
            }
            if (setCmd != null) {
                capabilities |= 0x38;
            }
        }
        return capabilities;
    }
}

