/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.files.ftp;

import java.io.File;
import org.apache.commons.net.ftp.FTPFile;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;

public class FTPHostFile
implements IHostFile,
IHostFilePermissionsContainer {
    private String _name;
    private String _parentPath;
    private boolean _isDirectory;
    private boolean _isLink;
    private boolean _isArchive;
    private long _lastModified;
    private long _size;
    private boolean _canRead = true;
    private boolean _canWrite = true;
    private boolean _isRoot;
    private boolean _exists;
    private IHostFilePermissions _permissions;
    private FTPFile _ftpFile;

    public FTPHostFile(String parentPath, String name, boolean isDirectory, boolean isRoot, long lastModified, long size, boolean exists) {
        this._parentPath = parentPath;
        this._name = name;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._isDirectory = isDirectory;
        this._lastModified = lastModified;
        this._size = size;
        this._isArchive = this.internalIsArchive();
        this._canRead = true;
        this._canWrite = false;
        this._isRoot = isRoot;
        this._exists = exists;
    }

    public FTPHostFile(String parentPath, FTPFile ftpFile) {
        this._parentPath = parentPath;
        this._ftpFile = ftpFile;
        this._name = ftpFile.getName();
        this._isDirectory = ftpFile.isDirectory();
        this._isLink = ftpFile.isSymbolicLink();
        this._lastModified = ftpFile.getTimestamp().getTimeInMillis();
        this._size = ftpFile.getSize();
        this._isArchive = this.internalIsArchive();
        this._canRead = ftpFile.hasPermission(0, 0);
        this._canWrite = ftpFile.hasPermission(0, 1);
        this._isRoot = false;
        this._exists = true;
        this.initPermissions(ftpFile);
    }

    public long getSize() {
        return this._size;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public boolean isFile() {
        return !this._isDirectory && !this._isRoot;
    }

    public boolean isLink() {
        return this._isLink;
    }

    public String getName() {
        return this._name;
    }

    public boolean canRead() {
        return this._canRead;
    }

    public boolean canWrite() {
        return this._canWrite;
    }

    public boolean exists() {
        return this._exists;
    }

    public String getAbsolutePath() {
        String sep;
        if (this.isRoot() || this._parentPath == null) {
            return this.getName();
        }
        String parentPath = this.getParentPath();
        StringBuffer path = new StringBuffer(parentPath);
        if (!(parentPath.endsWith("/") || parentPath.endsWith("\\") || parentPath.endsWith(sep = PathUtility.getSeparator((String)parentPath)))) {
            path.append(sep);
        }
        path.append(this.getName());
        return path.toString();
    }

    public long getModifiedDate() {
        return this._lastModified;
    }

    public String geParentPath() {
        return this._parentPath;
    }

    public boolean isArchive() {
        return this._isArchive;
    }

    public boolean isHidden() {
        String name = this.getName();
        return name.charAt(0) == '.';
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getParentPath() {
        return this._parentPath;
    }

    public void renameTo(String newAbsolutePath) {
        int i = newAbsolutePath.lastIndexOf("/");
        if (i == -1) {
            this._name = newAbsolutePath;
        } else if (i == 0) {
            if (newAbsolutePath.length() == 1) {
                this._parentPath = null;
                this._isRoot = true;
                this._name = newAbsolutePath;
            } else {
                this._parentPath = "/";
                this._name = newAbsolutePath.substring(i + 1);
            }
        } else {
            this._parentPath = newAbsolutePath.substring(0, i);
            this._name = newAbsolutePath.substring(i + 1);
        }
        this._isArchive = this.internalIsArchive();
    }

    public int getUserPermissions() {
        int userRead = 0;
        int userWrite = 0;
        int userExec = 0;
        if (this._ftpFile != null) {
            userRead = this._ftpFile.hasPermission(0, 0) ? 1 : 0;
            userWrite = this._ftpFile.hasPermission(0, 1) ? 1 : 0;
            userExec = this._ftpFile.hasPermission(0, 2) ? 1 : 0;
        } else {
            userRead = this._canRead ? 1 : 0;
            userWrite = this._canWrite ? 1 : 0;
            userExec = 0;
        }
        return userRead << 2 | userWrite << 1 | userExec;
    }

    public int getGroupPermissions() {
        int groupRead = 0;
        int groupWrite = 0;
        int groupExec = 0;
        if (this._ftpFile != null) {
            groupRead = this._ftpFile.hasPermission(1, 0) ? 1 : 0;
            groupWrite = this._ftpFile.hasPermission(1, 1) ? 1 : 0;
            groupExec = this._ftpFile.hasPermission(1, 2) ? 1 : 0;
        }
        return groupRead << 2 | groupWrite << 1 | groupExec;
    }

    public int getOtherPermissions() {
        int otherRead = 0;
        int otherWrite = 0;
        int otherExec = 0;
        if (this._ftpFile != null) {
            otherRead = this._ftpFile.hasPermission(2, 0) ? 1 : 0;
            otherWrite = this._ftpFile.hasPermission(2, 1) ? 1 : 0;
            otherExec = this._ftpFile.hasPermission(2, 2) ? 1 : 0;
        }
        return otherRead << 2 | otherWrite << 1 | otherExec;
    }

    protected boolean internalIsArchive() {
        return ArchiveHandlerManager.getInstance().isArchive(new File(this.getAbsolutePath())) && !ArchiveHandlerManager.isVirtual((String)this.getAbsolutePath());
    }

    public void setIsDirectory(boolean isDirectory) {
        this._isDirectory = isDirectory;
    }

    public String getClassification() {
        String result;
        if (this.isLink()) {
            result = "symbolic link";
            String linkTarget = this._ftpFile.getLink();
            if (linkTarget != null) {
                result = this.isDirectory() ? String.valueOf(result) + "(directory):" + linkTarget : ((this.getUserPermissions() & 1) == 1 ? String.valueOf(result) + "(executable):" + linkTarget : String.valueOf(result) + "(file):" + linkTarget);
            }
        } else {
            result = this.isFile() ? ((this.getUserPermissions() & 1) == 1 ? "executable" : "file") : (this.isDirectory() ? "directory" : "unknown");
        }
        return result;
    }

    private void initPermissions(FTPFile ftpFile) {
        this._permissions = new HostFilePermissions();
        this._permissions.setPermission(256, ftpFile.hasPermission(0, 0));
        this._permissions.setPermission(128, ftpFile.hasPermission(0, 1));
        this._permissions.setPermission(64, ftpFile.hasPermission(0, 2));
        this._permissions.setPermission(32, ftpFile.hasPermission(1, 0));
        this._permissions.setPermission(16, ftpFile.hasPermission(1, 1));
        this._permissions.setPermission(8, ftpFile.hasPermission(1, 2));
        this._permissions.setPermission(4, ftpFile.hasPermission(2, 0));
        this._permissions.setPermission(2, ftpFile.hasPermission(2, 1));
        this._permissions.setPermission(1, ftpFile.hasPermission(2, 2));
        this._permissions.setUserOwner(ftpFile.getUser());
        this._permissions.setGroupOwner(ftpFile.getGroup());
    }

    public IHostFilePermissions getPermissions() {
        return this._permissions;
    }

    public void setPermissions(IHostFilePermissions permissions) {
        this._permissions = permissions;
    }
}

