/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;

public class EnvironmentMiner
extends Miner {
    private DataElement _system;

    public void load() {
        this.getSystemNode();
    }

    protected ArrayList getDependencies() {
        ArrayList dependencies = new ArrayList();
        return dependencies;
    }

    private DataElement getSystemNode() {
        if (this._system == null) {
            this._system = this._dataStore.createObject(this._minerData, "Environment Variable", "System Environment");
            this._dataStore.refresh(this._minerData);
        }
        return this._system;
    }

    public void extendSchema(DataElement schemaRoot) {
        DataElement envVar = this._dataStore.createObjectDescriptor(schemaRoot, "Environment Variable");
        this._dataStore.createReference(envVar, this._dataStore.createRelationDescriptor(schemaRoot, "Parent Environment"));
        DataElement containerObjectD = this._dataStore.findObjectDescriptor("Container Object");
        this._dataStore.createReference(containerObjectD, envVar, "abstracts", "abstracted by");
        this.createCommandDescriptor(containerObjectD, "Set Environment Variables", "C_SET_ENVIRONMENT_VARIABLES", false);
        this.createCommandDescriptor(containerObjectD, "Set Environment Variables", "C_SET_ENVIRONMENT_VARIABLES_NO_SYSTEM", false);
        DataElement fsObj = this._dataStore.findObjectDescriptor("Filesystem Objects");
        DataElement inhabits = this._dataStore.createRelationDescriptor(schemaRoot, "inhabits");
        DataElement sustains = this._dataStore.createRelationDescriptor(schemaRoot, "sustains");
        this._dataStore.createReference(envVar, sustains);
        this._dataStore.createReference(fsObj, inhabits);
        DataElement systemInfo = this._dataStore.createObject(this._minerData, "dstore.structureNode", "systemInfo");
        if (this._dataStore.getClient() != null) {
            this._dataStore.createObject(systemInfo, "system.property", "user.home", this._dataStore.getClient().getProperty("user.home"));
            this._dataStore.createObject(systemInfo, "system.property", "temp.dir", this._dataStore.getClient().getProperty("java.io.tmpdir"));
        } else {
            this._dataStore.createObject(systemInfo, "system.property", "user.home", System.getProperty("user.home"));
            this._dataStore.createObject(systemInfo, "system.property", "temp.dir", System.getProperty("java.io.tmpdir"));
        }
        this._dataStore.createObject(systemInfo, "system.property", "os.name", System.getProperty("os.name"));
        this._dataStore.createObject(systemInfo, "system.property", "os.version", System.getProperty("os.version"));
        this.getSystemNode();
        this._dataStore.refresh(this._minerData);
        this.getSystemEnvironment();
    }

    public DataElement handleCommand(DataElement theElement) {
        String name = this.getCommandName(theElement);
        DataElement status = this.getCommandStatus(theElement);
        DataElement subject = this.getCommandArgument(theElement, 0);
        DataElement env = this.getCommandArgument(theElement, 1);
        if (name.equals("C_SET_ENVIRONMENT_VARIABLES")) {
            if (this._system.getNestedSize() == 0) {
                this.getSystemEnvironment();
            }
            this.handleSetEnvironment(subject, env);
        } else if (name.equals("C_SET_ENVIRONMENT_VARIABLES_NO_SYSTEM")) {
            this.handleSetEnvironment(subject, env);
        }
        status.setAttribute(2, "done");
        return status;
    }

    public void handleSetEnvironment(DataElement theElement, DataElement environment) {
        String envName = String.valueOf(theElement.getValue()) + ".env";
        DataElement envRoot = this._dataStore.find(this._minerData, 2, envName, 1);
        if (envRoot != null) {
            this._dataStore.deleteObject(this._minerData, envRoot);
            this._dataStore.refresh(this._minerData);
            List theReferences = theElement.getAssociated("inhabits");
            if (theReferences.size() > 0) {
                this._dataStore.deleteObject(theElement, (DataElement)theReferences.get(0));
                this._dataStore.refresh(theElement);
            }
        }
        environment.setAttribute(2, envName);
        environment.setAttribute(3, envName);
        this._minerData.addNestedData(environment, false);
        environment.setParent(this._minerData);
        this._dataStore.refresh(this._minerData);
        this._dataStore.createReference(theElement, environment, "inhabits", "sustains");
        this._dataStore.refresh(environment);
        this._dataStore.refresh(theElement);
    }

    private void getSystemEnvironment() {
        String envCommand = "sh -c env";
        String theOS = System.getProperty("os.name").toLowerCase();
        if (theOS.startsWith("win")) {
            envCommand = "cmd /C set";
        }
        if (theOS.startsWith("os/400")) {
            envCommand = "/QOpenSys/usr/bin/sh -c env";
        }
        String specialEncoding = System.getProperty("dstore.stdin.encoding");
        try {
            String curLine;
            Process _process = Runtime.getRuntime().exec(envCommand);
            BufferedReader _output = null;
            _output = specialEncoding != null ? new BufferedReader(new InputStreamReader(_process.getInputStream(), specialEncoding)) : new BufferedReader(new InputStreamReader(_process.getInputStream()));
            while ((curLine = _output.readLine()) != null) {
                int eqIndex = curLine.indexOf("=");
                if (eqIndex <= 0) continue;
                if (curLine.indexOf("=()") > 0) {
                    String multiLine = new String(curLine);
                    if (!curLine.endsWith("}")) {
                        boolean complete = false;
                        String subLine = null;
                        while (!complete && (subLine = _output.readLine()) != null) {
                            multiLine = String.valueOf(multiLine) + subLine;
                            if (subLine.indexOf(125) <= -1) continue;
                            complete = true;
                        }
                    }
                    DataElement var = this._dataStore.createObject(this._system, "Environment Variable", curLine, multiLine);
                    var.setAttribute(3, multiLine);
                    continue;
                }
                if (curLine.startsWith("PATH=")) {
                    curLine = String.valueOf(curLine) + ":.";
                }
                this._dataStore.createObject(this._system, "Environment Variable", curLine, curLine);
            }
            this._dataStore.refresh(this._system);
        }
        catch (IOException e) {
            System.err.println("Error getting System Environment Variables\n" + e.getMessage());
        }
    }

    public String getVersion() {
        return "6.4.0";
    }
}

