/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.server;

import java.net.Socket;
import java.util.ArrayList;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.UpdateHandler;
import org.eclipse.dstore.core.util.CommandGenerator;
import org.eclipse.dstore.internal.core.util.Sender;

public class ServerUpdateHandler
extends UpdateHandler {
    private ArrayList _senders = new ArrayList();
    private CommandGenerator _commandGenerator = new CommandGenerator();
    protected DataElement _classDocumentElement;
    protected DataElement _keepAliveDocumentElement;
    protected DataElement _confirmKeepAliveDocumentElement;
    protected DataElement _pendingKeepAliveRequest;
    protected DataElement _pendingKeepAliveConfirmation;
    private static String[] _keepAliveAttributes = new String[]{"KEEPALIVE", "server.keepalive.root.id", "server.keepalive", "doc", "", "", "false", "2"};
    private static String[] _confirmKeepAliveAttributes = new String[]{"CONFIRMKEEPALIVE", "server.keepalive.confirm.root.id", "server.confirmkeepalive", "doc", "", "", "false", "2"};
    private static String[] _docAttributes = new String[]{"DOCUMENT", "server.doc.root.id", "server.document", "doc", "", "", "false", "2"};
    private static String[] _fileAttributes = new String[]{"FILE", "server.file.root.id", "server.file", "doc", "", "", "false", "2"};
    private static String[] _classAttributes = new String[]{"CLASS", "server.class.root.id", "server.class", "doc", "", "", "false", "2"};
    private static String[] _requestClassAttributes = new String[]{"REQUEST_CLASS", "server.requestclass.root.id", "server.requestclass", "doc", "", "", "false", "2"};
    private static String[] _serializeAttributes = new String[]{"SERIALIZED", "server.serialized.root.id", "server.serialized", "doc", "", "", "false", "2"};
    protected DataElement _fileDocumentElement;
    protected DataElement _docDocumentElement;
    protected DataElement _requestClassDocumentElement;
    protected DataElement _serializedDocumentElement;

    public void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
        this._commandGenerator.setDataStore(dataStore);
        this._fileDocumentElement = dataStore.createTransientObject(_fileAttributes);
        this._docDocumentElement = dataStore.createObject(null, _docAttributes);
        this._requestClassDocumentElement = dataStore.createTransientObject(_requestClassAttributes);
        this._serializedDocumentElement = dataStore.createTransientObject(_serializeAttributes);
        this._classDocumentElement = dataStore.createTransientObject(_classAttributes);
        this._keepAliveDocumentElement = dataStore.createTransientObject(_keepAliveAttributes);
        this._confirmKeepAliveDocumentElement = dataStore.createTransientObject(_confirmKeepAliveAttributes);
    }

    public void addSender(Sender sender) {
        this._senders.add(sender);
    }

    public void removeSender(Sender sender) {
        this._senders.remove(sender);
        if (this._senders.size() == 0) {
            this.finish();
        }
    }

    public synchronized void updateFile(String path, byte[] bytes, int size, boolean binary) {
        this.updateFile(path, bytes, size, binary, "default");
    }

    public synchronized void updateFile(String path, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        DataElement document = this._fileDocumentElement;
        document.setAttribute(2, byteStreamHandlerId);
        document.setAttribute(3, byteStreamHandlerId);
        document.setAttribute(4, path);
        document.setPendingTransfer(true);
        document.setParent(null);
        int j = 0;
        while (j < this._senders.size()) {
            Sender sender = (Sender)this._senders.get(j);
            sender.sendFile(document, bytes, size, binary);
            ++j;
        }
    }

    public synchronized void updateAppendFile(String path, byte[] bytes, int size, boolean binary) {
        this.updateAppendFile(path, bytes, size, binary, "default");
    }

    public synchronized void updateAppendFile(String path, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        DataElement document = this._fileDocumentElement;
        document.setAttribute(2, byteStreamHandlerId);
        document.setAttribute(3, byteStreamHandlerId);
        document.setAttribute(4, path);
        document.setPendingTransfer(true);
        document.setParent(null);
        int j = 0;
        while (j < this._senders.size()) {
            Sender sender = (Sender)this._senders.get(j);
            sender.sendAppendFile(document, bytes, size, binary);
            ++j;
        }
    }

    public void handle() {
        if (!this._dataObjects.isEmpty() || this._pendingKeepAliveConfirmation != null || this._pendingKeepAliveRequest != null || !this._classesToSend.isEmpty()) {
            this.sendUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sendUpdates() {
        var1_1 = this._dataObjects;
        synchronized (var1_1) {
            document = this._docDocumentElement;
            document.removeNestedData();
            document.setPendingTransfer(true);
            document.setUpdated(true);
            document.setParent(null);
            this._commandGenerator.generateResponse(document, this._dataObjects);
            j = 0;
            while (j < this._senders.size()) {
                sender = (Sender)this._senders.get(j);
                sender.sendDocument(document, 5);
                if (this._pendingKeepAliveConfirmation != null) {
                    sender.sendKeepAliveConfirmation(this._pendingKeepAliveConfirmation);
                    this._pendingKeepAliveConfirmation = null;
                }
                if (this._pendingKeepAliveRequest != null) {
                    sender.sendKeepAliveRequest(this._pendingKeepAliveRequest);
                    this._pendingKeepAliveRequest = null;
                }
                ++j;
            }
            i = 0;
            while (i < this._dataObjects.size()) {
                obj = (DataElement)this._dataObjects.get(i);
                this.clean(obj);
                ++i;
            }
            this._dataObjects.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl30 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl49
        }
        do {
            document = null;
            var2_2 = this._classesToSend;
            synchronized (var2_2) {
                document = (DataElement)this._classesToSend.remove(0);
                i = 0;
                while (i < this._senders.size()) {
                    sender = (Sender)this._senders.get(i);
                    sender.sendClass(document);
                    ++i;
                }
            }
lbl49:
            // 2 sources

        } while (this._classesToSend.size() > 0);
    }

    public void removeSenderWith(Socket socket) {
        int i = 0;
        while (i < this._senders.size()) {
            Sender sender = (Sender)this._senders.get(i);
            if (sender.socket() == socket) {
                DataElement document = this._dataStore.createObject(null, "DOCUMENT", "exit", "exit");
                sender.sendDocument(document, 2);
                this.removeSender(sender);
            }
            ++i;
        }
    }

    public synchronized void requestClass(String className) {
        DataElement document = this._requestClassDocumentElement;
        document.setPendingTransfer(true);
        document.setAttribute(2, className);
        document.setAttribute(3, className);
        document.setParent(null);
        int j = 0;
        while (j < this._senders.size()) {
            Sender sender = (Sender)this._senders.get(j);
            sender.requestClass(document);
            ++j;
        }
    }

    public synchronized void updateClassInstance(IRemoteClassInstance runnable, String deserializebyteStreamHandlerId) {
        DataElement document = this._serializedDocumentElement;
        document.setAttribute(2, runnable.toString());
        document.setAttribute(4, deserializebyteStreamHandlerId);
        document.setPendingTransfer(true);
        document.setParent(null);
        int j = 0;
        while (j < this._senders.size()) {
            Sender sender = (Sender)this._senders.get(j);
            sender.sendRemoteClassRunnable(document, runnable);
            ++j;
        }
        this.notifyInput();
    }

    public synchronized void sendClass(String className, String classByteStreamHandlerId) {
        if (this._dataObjects.size() > 0) {
            this.sendUpdates();
        }
        DataElement document = this._classDocumentElement;
        document.setAttribute(2, className);
        document.setAttribute(4, classByteStreamHandlerId);
        document.setPendingTransfer(true);
        document.setParent(null);
        this.addClassToSend(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassToSend(DataElement classElement) {
        ArrayList arrayList = this._classesToSend;
        synchronized (arrayList) {
            if (!this._classesToSend.contains(classElement)) {
                this._classesToSend.add(classElement);
            }
        }
    }

    public synchronized void sendClass(String className) {
        this.sendClass(className, "default");
    }

    public void sendKeepAliveRequest() {
        DataElement document = this._keepAliveDocumentElement;
        document.setPendingTransfer(true);
        document.setAttribute(2, "request");
        document.setAttribute(3, "request");
        document.setParent(null);
        this._pendingKeepAliveRequest = document;
        this.notifyInput();
    }

    public void sendKeepAliveConfirmation() {
        DataElement document = this._confirmKeepAliveDocumentElement;
        document.setPendingTransfer(true);
        document.setAttribute(2, "confirm");
        document.setAttribute(3, "confirm");
        document.setParent(null);
        this._pendingKeepAliveConfirmation = document;
        this.notifyInput();
    }

    public synchronized void waitForInput() {
        if (this._dataObjects.size() == 0 && this._classesToSend.size() == 0 && this._pendingKeepAliveConfirmation == null && this._pendingKeepAliveRequest == null) {
            super.waitForInput();
        }
    }

    public void setGenerateBuffer(boolean flag) {
        int i = 0;
        while (i < this._senders.size()) {
            Sender sender = (Sender)this._senders.get(i);
            sender.setGenerateBuffer(flag);
            ++i;
        }
    }
}

