/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.IRSEInitListener;
import org.eclipse.rse.core.IRSEModelInitializer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.model.SystemModelChangeEvent;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;

public final class RSEInitJob
extends Job {
    public static final String NAME = "Initialize RSE";
    private static RSEInitJob instance = new RSEInitJob();
    private Phase finalPhase = new Phase(0);
    private Phase modelPhase = new Phase(1);
    private Phase initializerPhase = new Phase(2);
    private List listeners = new ArrayList(10);
    private Logger logger = RSECorePlugin.getDefault().getLogger();
    private MyJobChangeListener myJobChangeListener = new MyJobChangeListener();

    public static RSEInitJob getInstance() {
        return instance;
    }

    private RSEInitJob() {
        super(NAME);
        this.setSystem(true);
        this.addJobChangeListener(this.myJobChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitListener(IRSEInitListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInitListener(IRSEInitListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int phase) {
        IRSEInitListener[] myListeners = new IRSEInitListener[this.listeners.size()];
        List list = this.listeners;
        synchronized (list) {
            this.listeners.toArray(myListeners);
        }
        int i = 0;
        while (i < myListeners.length) {
            IRSEInitListener listener = myListeners[i];
            try {
                listener.phaseComplete(phase);
            }
            catch (RuntimeException e) {
                this.logger.logError(RSECoreMessages.InitRSEJob_listener_ended_in_error, e);
            }
            ++i;
        }
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        RSECorePlugin.getThePersistenceManager().restoreProfiles(5000L);
        ISystemProfile defaultProfile = SystemProfileManager.getDefault().getDefaultPrivateSystemProfile();
        SystemModelChangeEvent event = new SystemModelChangeEvent(128, 1, defaultProfile);
        RSECorePlugin.getTheSystemRegistry().fireEvent(event);
        this.modelPhase.done(result);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rse.core.modelInitializers");
        monitor.beginTask(RSECoreMessages.InitRSEJob_initializing_rse, elements.length);
        int i = 0;
        while (i < elements.length && !monitor.isCanceled()) {
            boolean isWorkspaceType;
            IConfigurationElement element = elements[i];
            SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 1);
            String initializerType = element.getAttribute("type");
            boolean isMarked = this.isMarked(element);
            boolean isSessionType = initializerType == null || initializerType.equals("session");
            boolean bl = isWorkspaceType = initializerType != null && initializerType.equals("workspace");
            if (isSessionType || isWorkspaceType && !isMarked) {
                IStatus status = this.runInitializer(element, (IProgressMonitor)submonitor);
                if (status.getSeverity() < 4 && isWorkspaceType) {
                    this.mark(element);
                }
                if (result.getSeverity() < status.getSeverity()) {
                    result = status;
                }
            }
            submonitor.done();
            ++i;
        }
        SystemEncodingUtil encodingUtil = SystemEncodingUtil.getInstance();
        encodingUtil.setDefaultEncodingProvider(new SystemEncodingUtil.DefaultEncodingProvider(){

            public String getLocalDefaultEncoding() {
                return ResourcesPlugin.getEncoding();
            }
        });
        this.initializerPhase.done(result);
        if (monitor.isCanceled()) {
            result = Status.CANCEL_STATUS;
        } else {
            monitor.done();
        }
        return result;
    }

    private File getMarkFile(IConfigurationElement element) {
        String initializerName = element.getAttribute("class");
        String markName = String.valueOf(initializerName) + ".mark";
        IPath stateLocation = RSECorePlugin.getDefault().getStateLocation();
        IPath marksLocation = stateLocation.append("initializerMarks");
        IPath markPath = marksLocation.append(markName);
        File markFile = new File(markPath.toOSString());
        return markFile;
    }

    private boolean isMarked(IConfigurationElement element) {
        File markFile = this.getMarkFile(element);
        return markFile.exists();
    }

    private IStatus mark(IConfigurationElement element) {
        IStatus status = Status.OK_STATUS;
        File markFile = this.getMarkFile(element);
        File markFolder = markFile.getParentFile();
        try {
            markFolder.mkdirs();
            markFile.createNewFile();
        }
        catch (IOException e) {
            String message = NLS.bind((String)RSECoreMessages.InitRSEJob_error_creating_mark, (Object)markFile.getPath());
            status = new Status(4, "org.eclipse.rse.core", message, (Throwable)e);
            this.logger.logError(message, e);
        }
        return status;
    }

    private IStatus runInitializer(IConfigurationElement element, IProgressMonitor submonitor) {
        IStatus status = Status.OK_STATUS;
        String initializerName = element.getAttribute("class");
        try {
            IRSEModelInitializer initializer = (IRSEModelInitializer)element.createExecutableExtension("class");
            try {
                status = initializer.run(submonitor);
            }
            catch (RuntimeException e) {
                String message = NLS.bind((String)RSECoreMessages.InitRSEJob_initializer_ended_in_error, (Object)initializerName);
                this.logger.logError(message, e);
                status = new Status(4, "org.eclipse.rse.core", message, (Throwable)e);
            }
        }
        catch (CoreException e) {
            String message = NLS.bind((String)RSECoreMessages.InitRSEJob_initializer_failed_to_load, (Object)initializerName);
            this.logger.logError(message, e);
            status = new Status(4, "org.eclipse.rse.core", message, (Throwable)e);
        }
        return status;
    }

    public IStatus waitForCompletion() throws InterruptedException {
        this.waitForCompletion(0);
        return this.getResult();
    }

    public IStatus waitForCompletion(int phase) throws InterruptedException {
        IStatus result = Status.OK_STATUS;
        switch (phase) {
            case 1: {
                result = this.modelPhase.waitForCompletion();
                break;
            }
            case 2: {
                result = this.initializerPhase.waitForCompletion();
                break;
            }
            case 0: {
                result = this.finalPhase.waitForCompletion();
                break;
            }
            default: {
                throw new IllegalArgumentException("undefined phase");
            }
        }
        return result;
    }

    public boolean isComplete(int phase) {
        boolean result = false;
        switch (phase) {
            case 1: {
                result = this.modelPhase.isComplete();
                break;
            }
            case 2: {
                result = this.initializerPhase.isComplete();
                break;
            }
            case 0: {
                result = this.finalPhase.isComplete();
                break;
            }
            default: {
                throw new IllegalArgumentException("undefined phase");
            }
        }
        return result;
    }

    private class MyJobChangeListener
    implements IJobChangeListener {
        private MyJobChangeListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            IStatus status = event.getJob().getResult();
            if (status.getSeverity() == 8) {
                if (!RSEInitJob.this.modelPhase.isComplete()) {
                    RSEInitJob.this.modelPhase.cancel();
                }
                if (!RSEInitJob.this.initializerPhase.isComplete()) {
                    RSEInitJob.this.initializerPhase.cancel();
                }
                RSEInitJob.this.finalPhase.cancel();
            } else {
                RSEInitJob.this.finalPhase.done(status);
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }

    private class Phase {
        private volatile boolean isCancelled = false;
        private volatile boolean isComplete = false;
        private IStatus completionStatus = Status.OK_STATUS;
        private int phaseNumber = 0;

        public Phase(int phaseNumber) {
            this.phaseNumber = phaseNumber;
        }

        public synchronized IStatus waitForCompletion() throws InterruptedException {
            while (!this.isComplete && !this.isCancelled) {
                this.wait();
            }
            if (this.isCancelled) {
                throw new InterruptedException();
            }
            return this.completionStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IStatus status) {
            Phase phase = this;
            synchronized (phase) {
                this.isComplete = true;
                this.completionStatus = status;
                this.notifyAll();
            }
            RSEInitJob.this.notifyListeners(this.phaseNumber);
        }

        public synchronized void cancel() {
            this.isCancelled = true;
            this.completionStatus = Status.CANCEL_STATUS;
            this.notifyAll();
        }

        public boolean isComplete() {
            return this.isComplete;
        }
    }
}

