/*********************************************************************
 * Copyright (c) 2018 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { GDBBackend } from '../GDBBackend';
import { MIResponse, MIRegisterValueInfo } from './base';
interface MIDataReadMemoryBytesResponse {
    memory: Array<{
        begin: string;
        end: string;
        offset: string;
        contents: string;
    }>;
}
interface MIDataDisassembleAsmInsn {
    address: string;
    'func-name': string;
    offset: string;
    opcodes: string;
    inst: string;
}
interface MIDataDisassembleSrcAndAsmLine {
    line: string;
    file: string;
    fullname: string;
    line_asm_insn: MIDataDisassembleAsmInsn[];
}
interface MIDataDisassembleResponse {
    asm_insns: MIDataDisassembleSrcAndAsmLine[];
}
export interface MIListRegisterNamesResponse extends MIResponse {
    'register-names': string[];
}
export interface MIListRegisterValuesResponse extends MIResponse {
    'register-values': MIRegisterValueInfo[];
}
export interface MIGDBDataEvaluateExpressionResponse extends MIResponse {
    value?: string;
}
export declare function sendDataReadMemoryBytes(gdb: GDBBackend, address: string, size: number, offset?: number): Promise<MIDataReadMemoryBytesResponse>;
export declare function sendDataWriteMemoryBytes(gdb: GDBBackend, memoryReference: string, data: string): Promise<void>;
export declare function sendDataEvaluateExpression(gdb: GDBBackend, expr: string): Promise<MIGDBDataEvaluateExpressionResponse>;
export declare function sendDataDisassemble(gdb: GDBBackend, startAddress: string, endAddress: string): Promise<MIDataDisassembleResponse>;
export declare function sendDataListRegisterNames(gdb: GDBBackend, params: {
    regno?: number[];
    frameId: number;
    threadId: number;
}): Promise<MIListRegisterNamesResponse>;
export declare function sendDataListRegisterValues(gdb: GDBBackend, params: {
    fmt: string;
    regno?: number[];
    frameId: number;
    threadId: number;
}): Promise<MIListRegisterValuesResponse>;
export {};
