import { DebugClient } from '@vscode/debugadapter-testsupport';
import { DebugProtocol } from '@vscode/debugprotocol';
export type ReverseRequestHandler<A = any, R extends DebugProtocol.Response = DebugProtocol.Response> = (args: A) => Promise<R['body']>;
export interface ReverseRequestHandlers {
    [key: string]: ReverseRequestHandler | undefined;
    runInTerminal: ReverseRequestHandler<DebugProtocol.RunInTerminalRequestArguments, DebugProtocol.RunInTerminalResponse>;
}
/**
 * Extend the standard DebugClient to support additional client features
 */
export declare class CdtDebugClient extends DebugClient {
    private _cdt_args;
    private _cdt_adapterProcess?;
    constructor(adapter?: string, extraArgs?: string[]);
    /**
     * Start a debug session allowing command line arguments to be supplied
     */
    start(port?: number): Promise<void>;
    stop(): Promise<void>;
    private killAdapter;
    /**
     * Reverse Request Handlers:
     */
    protected reverseRequestHandlers: ReverseRequestHandlers;
    /**
     * Notify the Debug Adapter by default that this client supports `runInTerminal`.
     */
    initializeRequest(args?: DebugProtocol.InitializeRequestArguments): Promise<DebugProtocol.InitializeResponse>;
    /**
     * Send a continueRequest and wait for target to stop
     */
    continue(args: DebugProtocol.ContinueArguments, reason: string, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a nextRequest and wait for target to stop
     */
    next(args: DebugProtocol.NextArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a stepInRequest and wait for target to stop
     */
    stepIn(args: DebugProtocol.StepInArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a stepOutRequest and wait for target to stop
     */
    stepOut(args: DebugProtocol.StepOutArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    /**
     * Send a stepBackRequest and wait for target to stop
     */
    stepBack(args: DebugProtocol.StepBackArguments, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    waitForOutputEvent(category: string, output?: string, timeout?: number): Promise<DebugProtocol.OutputEvent>;
    /**
     * Send a response following a Debug Adapter Reverse Request.
     * @param request original request to respond to.
     * @param handler processes the request and returns the response body.
     */
    private doRespond;
    readMemoryRequest(args: DebugProtocol.ReadMemoryArguments): Promise<DebugProtocol.ReadMemoryResponse>;
    writeMemoryRequest(args: DebugProtocol.WriteMemoryArguments): Promise<DebugProtocol.WriteMemoryResponse>;
    attachHitBreakpoint(attachArgs: any, breakpoint: {
        line: number;
        path: string;
    }): Promise<any>;
    /**
     * Obtain the value of the expression in the context of the
     * top frame, of the first returned thread.
     * @param name name of the variable
     */
    evaluate(expression: string): Promise<string | undefined>;
}
