"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMonacoBaseAPI = exports.KeyMod = void 0;
const cancellation_1 = require("../../../base/common/cancellation");
const event_1 = require("../../../base/common/event");
const keyCodes_1 = require("../../../base/common/keyCodes");
const uri_1 = require("../../../base/common/uri");
const position_1 = require("../core/position");
const range_1 = require("../core/range");
const selection_1 = require("../core/selection");
const languages_1 = require("../languages");
const standaloneEnums = require("../standalone/standaloneEnums");
class KeyMod {
    static chord(firstPart, secondPart) {
        return (0, keyCodes_1.KeyChord)(firstPart, secondPart);
    }
}
exports.KeyMod = KeyMod;
KeyMod.CtrlCmd = 2048 /* CtrlCmd */;
KeyMod.Shift = 1024 /* Shift */;
KeyMod.Alt = 512 /* Alt */;
KeyMod.WinCtrl = 256 /* WinCtrl */;
function createMonacoBaseAPI() {
    return {
        editor: undefined,
        languages: undefined,
        CancellationTokenSource: cancellation_1.CancellationTokenSource,
        Emitter: event_1.Emitter,
        KeyCode: standaloneEnums.KeyCode,
        KeyMod: KeyMod,
        Position: position_1.Position,
        Range: range_1.Range,
        Selection: selection_1.Selection,
        SelectionDirection: standaloneEnums.SelectionDirection,
        MarkerSeverity: standaloneEnums.MarkerSeverity,
        MarkerTag: standaloneEnums.MarkerTag,
        Uri: uri_1.URI,
        Token: languages_1.Token
    };
}
exports.createMonacoBaseAPI = createMonacoBaseAPI;
//# sourceMappingURL=editorBaseApi.js.map