"use strict";
/********************************************************************************
 * Copyright (C) 2019 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CDTGDBMemoryProvider = exports.hex2bytes = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const util_1 = require("../../common/util");
/**
 * Convert a hex-encoded string of bytes to the Uint8Array equivalent.
 */
function hex2bytes(hex) {
    return Buffer.from(hex, 'hex');
}
exports.hex2bytes = hex2bytes;
/**
 * Read memory through the current debug session, using the cdt-gdb-adapter
 * extension to read memory.
 */
let CDTGDBMemoryProvider = class CDTGDBMemoryProvider {
    canHandle(session) {
        return session.configuration.type === 'gdb';
    }
    async readMemory(session, readMemoryArguments) {
        var _a;
        const result = await session.sendRequest('readMemory', readMemoryArguments);
        if ((_a = result.body) === null || _a === void 0 ? void 0 : _a.data) {
            const bytes = hex2bytes(result.body.data);
            const address = util_1.hexStrToUnsignedLong(result.body.address);
            return { bytes, address };
        }
        throw new Error('Received no data from debug adapter.');
    }
};
CDTGDBMemoryProvider = __decorate([
    inversify_1.injectable()
], CDTGDBMemoryProvider);
exports.CDTGDBMemoryProvider = CDTGDBMemoryProvider;
//# sourceMappingURL=cdt-gdb-memory-provider.js.map