"use strict";
/********************************************************************************
 * Copyright (C) 2022 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleGeneratorServiceImpl = void 0;
const core_1 = require("@theia/core");
const uri_1 = require("@theia/core/lib/common/uri");
const inversify_1 = require("@theia/core/shared/inversify");
const fs = require("fs-extra");
const protocol_1 = require("../common/protocol");
const EXAMPLE_DIRECTORY = 'resources';
// TODO use fsPath once we upgrade Theia
// https://github.com/eclipse-theia/theia/wiki/Coding-Guidelines#backend-fs-path
let ExampleGeneratorServiceImpl = class ExampleGeneratorServiceImpl {
    async generateExample(exampleId, targetFolderUri) {
        var _a;
        const examplesPath = new core_1.Path(module.path).resolve(`../../${EXAMPLE_DIRECTORY}`);
        if (!examplesPath || !fs.existsSync(examplesPath.toString())) {
            throw new Error('Could not find examples folder');
        }
        const examplePath = examplesPath.resolve(`${exampleId}`);
        if (!examplePath || !fs.existsSync(examplePath.toString())) {
            throw new Error(`Could not find files in ${examplesPath}${examplePath}`);
        }
        const target = new uri_1.default(targetFolderUri);
        fs.copySync(examplePath.toString(), target.path.toString(), { recursive: true, errorOnExist: true });
        const fileToBeOpened = this.getFileToBeOpened(exampleId);
        return fileToBeOpened ? (_a = target.path.resolve(fileToBeOpened)) === null || _a === void 0 ? void 0 : _a.toString() : undefined;
    }
    getFileToBeOpened(exampleId) {
        if (exampleId === protocol_1.Examples.CMAKE_EXAMPLE) {
            return 'CMAKE_EXAMPLE_README.md';
        }
        if (exampleId === protocol_1.Examples.CLANGD_CONTEXTS) {
            return 'CLANGD_CONTEXTS_README.md';
        }
        if (exampleId === protocol_1.Examples.EXAMPLE_TRACES) {
            return 'EXAMPLE_TRACES_README.md';
        }
        return undefined;
    }
};
ExampleGeneratorServiceImpl = __decorate([
    inversify_1.injectable()
], ExampleGeneratorServiceImpl);
exports.ExampleGeneratorServiceImpl = ExampleGeneratorServiceImpl;
//# sourceMappingURL=example-generator-service.js.map