/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.util.SearchUtils;

public class ReferenceFinderUtil {
    private ReferenceFinderUtil() {
    }

    public static IType[] getTypesReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getTypeReferencesIn(elements, null, pm);
        Set<IJavaElement> referencedTypes = ReferenceFinderUtil.extractElements(results, 7);
        return referencedTypes.toArray(new IType[referencedTypes.size()]);
    }

    public static IType[] getTypesReferencedIn(IJavaElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getTypeReferencesIn(elements, owner, pm);
        Set<IJavaElement> referencedTypes = ReferenceFinderUtil.extractElements(results, 7);
        return referencedTypes.toArray(new IType[referencedTypes.size()]);
    }

    private static SearchMatch[] getTypeReferencesIn(IJavaElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        ArrayList<SearchMatch> referencedTypes = new ArrayList<SearchMatch>();
        pm.beginTask("", elements.length);
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            referencedTypes.addAll(ReferenceFinderUtil.getTypeReferencesIn(element, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++n2;
        }
        pm.done();
        return referencedTypes.toArray(new SearchMatch[referencedTypes.size()]);
    }

    private static List<SearchMatch> getTypeReferencesIn(IJavaElement element, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        SearchEngine engine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        engine.searchDeclarationsOfReferencedTypes(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static IField[] getFieldsReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getFieldReferencesIn(elements, null, pm);
        Set<IJavaElement> referencedFields = ReferenceFinderUtil.extractElements(results, 8);
        return referencedFields.toArray(new IField[referencedFields.size()]);
    }

    public static IField[] getFieldsReferencedIn(IJavaElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getFieldReferencesIn(elements, owner, pm);
        Set<IJavaElement> referencedFields = ReferenceFinderUtil.extractElements(results, 8);
        return referencedFields.toArray(new IField[referencedFields.size()]);
    }

    private static SearchMatch[] getFieldReferencesIn(IJavaElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        ArrayList<SearchMatch> referencedFields = new ArrayList<SearchMatch>();
        pm.beginTask("", elements.length);
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            referencedFields.addAll(ReferenceFinderUtil.getFieldReferencesIn(element, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++n2;
        }
        pm.done();
        return referencedFields.toArray(new SearchMatch[referencedFields.size()]);
    }

    private static List<SearchMatch> getFieldReferencesIn(IJavaElement element, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        SearchEngine engine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        engine.searchDeclarationsOfAccessedFields(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static IMethod[] getMethodsReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getMethodReferencesIn(elements, null, pm);
        Set<IJavaElement> referencedMethods = ReferenceFinderUtil.extractElements(results, 9);
        return referencedMethods.toArray(new IMethod[referencedMethods.size()]);
    }

    public static IMethod[] getMethodsReferencedIn(IJavaElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getMethodReferencesIn(elements, owner, pm);
        Set<IJavaElement> referencedMethods = ReferenceFinderUtil.extractElements(results, 9);
        return referencedMethods.toArray(new IMethod[referencedMethods.size()]);
    }

    private static SearchMatch[] getMethodReferencesIn(IJavaElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        ArrayList<SearchMatch> referencedMethods = new ArrayList<SearchMatch>();
        pm.beginTask("", elements.length);
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            referencedMethods.addAll(ReferenceFinderUtil.getMethodReferencesIn(element, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++n2;
        }
        pm.done();
        return referencedMethods.toArray(new SearchMatch[referencedMethods.size()]);
    }

    private static List<SearchMatch> getMethodReferencesIn(IJavaElement element, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        SearchEngine engine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        engine.searchDeclarationsOfSentMessages(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static ITypeBinding[] getTypesReferencedInDeclarations(MethodDeclaration[] methods) {
        HashSet<ITypeBinding> typesUsed = new HashSet<ITypeBinding>();
        MethodDeclaration[] methodDeclarationArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            typesUsed.addAll(ReferenceFinderUtil.getTypesUsedInDeclaration(method));
            ++n2;
        }
        return typesUsed.toArray(new ITypeBinding[typesUsed.size()]);
    }

    public static Set<ITypeBinding> getTypesUsedInDeclaration(MethodDeclaration methodDeclaration) {
        if (methodDeclaration == null) {
            return new HashSet<ITypeBinding>(0);
        }
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        ITypeBinding binding = null;
        Type returnType = methodDeclaration.getReturnType2();
        if (returnType != null && (binding = returnType.resolveBinding()) != null) {
            result.add(binding);
        }
        Iterator iter = methodDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            binding = ((SingleVariableDeclaration)iter.next()).getType().resolveBinding();
            if (binding == null) continue;
            result.add(binding);
        }
        iter = methodDeclaration.thrownExceptionTypes().iterator();
        while (iter.hasNext()) {
            binding = ((Type)iter.next()).resolveBinding();
            if (binding == null) continue;
            result.add(binding);
        }
        return result;
    }

    private static Set<IJavaElement> extractElements(SearchMatch[] searchResults, int elementType) {
        HashSet<IJavaElement> elements = new HashSet<IJavaElement>();
        SearchMatch[] searchMatchArray = searchResults;
        int n = searchResults.length;
        int n2 = 0;
        while (n2 < n) {
            SearchMatch searchResult = searchMatchArray[n2];
            IJavaElement el = SearchUtils.getEnclosingJavaElement(searchResult);
            if (el.exists() && el.getElementType() == elementType) {
                elements.add(el);
            }
            ++n2;
        }
        return elements;
    }
}

