/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractLocalDescriptor;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.ChangedValueChecker;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.SideEffectChecker;
import org.eclipse.jdt.internal.corext.refactoring.util.UnsafeCheckTester;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.CopySourceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditVisitor;

public class ExtractTempRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_REPLACE_ALL = "replaceAllInThisFile";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_TYPE_VAR = "varType";
    private CompilationUnit fCompilationUnitNode;
    private CompilationUnitRewrite fCURewrite;
    private ICompilationUnit fCu;
    private boolean fDeclareFinal;
    private boolean fDeclareVarType;
    private String[] fExcludedVariableNames;
    private boolean fReplaceAllOccurrences;
    private boolean fReplaceAllOccurrencesInThisFile;
    private IExpressionFragment fSelectedExpression;
    private int fSelectionLength;
    private int fSelectionStart;
    private String fTempName;
    private String[] fGuessedTempNames;
    private boolean fCheckResultForCompileProblems;
    private CompilationUnitChange fChange;
    private LinkedProposalModelCore fLinkedProposalModel;
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private int fStartPoint;
    private int fEndPoint;
    private HashSet<IASTFragment> fSeen = new HashSet();
    private String fEnclosingKey;
    private HashSet<String> fEnclosingKeySet;
    private Map<String, String> fFormatterOptions;

    private static boolean allArraysEqual(ASTNode[][] arrays, int position) {
        ASTNode element = arrays[0][position];
        ASTNode[][] aSTNodeArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode[] a = aSTNodeArray[n2];
            ASTNode[] array = a;
            if (!element.equals(array[position])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (ExtractTempRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (parent instanceof LambdaExpression) {
            return false;
        }
        if (ExtractTempRefactoring.isLeftValue(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater((Expression)node)) {
            return false;
        }
        if (parent instanceof SuperConstructorInvocation) {
            return false;
        }
        if (parent instanceof ConstructorInvocation) {
            return false;
        }
        if (parent instanceof SwitchCase) {
            return true;
        }
        if (node instanceof SimpleName && node.getLocationInParent() != null) {
            return !KEY_NAME.equals(node.getLocationInParent().getId());
        }
        return true;
    }

    private static ASTNode[] getArrayPrefix(ASTNode[] array, int prefixLength) {
        Assert.isTrue((prefixLength <= array.length ? 1 : 0) != 0);
        Assert.isTrue((prefixLength >= 0 ? 1 : 0) != 0);
        ASTNode[] prefix = new ASTNode[prefixLength];
        System.arraycopy(array, 0, prefix, 0, prefix.length);
        return prefix;
    }

    private static List<IVariableBinding> getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        for (VariableDeclarationFragment fragment : variableDeclarations.fragments()) {
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    private static ASTNode[] getLongestArrayPrefix(ASTNode[][] arrays) {
        int length = -1;
        if (arrays.length == 0) {
            return new ASTNode[0];
        }
        int minArrayLength = arrays[0].length;
        int i = 1;
        while (i < arrays.length) {
            minArrayLength = Math.min(minArrayLength, arrays[i].length);
            ++i;
        }
        i = 0;
        while (i < minArrayLength) {
            if (!ExtractTempRefactoring.allArraysEqual(arrays, i)) break;
            ++length;
            ++i;
        }
        if (length == -1) {
            return new ASTNode[0];
        }
        return ExtractTempRefactoring.getArrayPrefix(arrays[0], length + 1);
    }

    private static ASTNode[] getParents(ASTNode node) {
        ASTNode current = node;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>();
        do {
            parents.add(current.getParent());
        } while ((current = current.getParent()).getParent() != null);
        Collections.reverse(parents);
        return parents.toArray(new ASTNode[parents.size()]);
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            List initializers;
            ForStatement forStmt;
            if (parent instanceof ForStatement && ((forStmt = (ForStatement)parent).initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                List<IVariableBinding> forInitializerVariables = ExtractTempRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                ForStatementChecker checker = new ForStatementChecker(forInitializerVariables);
                expression.accept((ASTVisitor)checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        IASTFragment[] iASTFragmentArray = allMatches;
        int n = allMatches.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFragment match = iASTFragmentArray[n2];
            if (ExtractTempRefactoring.canReplace(match)) {
                result.add(match);
            }
            ++n2;
        }
        Comparator comparator = (o1, o2) -> o1.getStartPosition() - o2.getStartPosition();
        result.sort(comparator);
        try {
            boolean flag = false;
            IExpressionFragment selectedFragment = this.getSelectedExpression();
            ASTNode associatedNode = selectedFragment.getAssociatedNode();
            IExpressionFragment firstExpression = this.getCertainReplacedExpression(result.toArray(new IASTFragment[result.size()]), 0);
            flag = firstExpression.getStartPosition() < selectedFragment.getStartPosition() ? false : (associatedNode.getParent() instanceof ExpressionStatement || associatedNode.getParent() instanceof LambdaExpression) && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(associatedNode));
            int upper = result.size();
            if (flag) {
                ASTNode parent = associatedNode.getParent();
                StructuralPropertyDescriptor location = parent.getLocationInParent();
                while (parent != null) {
                    if (parent instanceof Block || parent instanceof BodyDeclaration || parent instanceof LambdaExpression && ((LambdaExpression)parent).resolveMethodBinding() != null || parent instanceof EnhancedForStatement || parent instanceof WhileStatement || parent instanceof ForStatement || parent instanceof DoStatement || (location = parent.getLocationInParent()) == IfStatement.ELSE_STATEMENT_PROPERTY || location == IfStatement.THEN_STATEMENT_PROPERTY || location == SwitchStatement.STATEMENTS_PROPERTY) break;
                    parent = parent.getParent();
                }
                if (parent == null) {
                    return result.toArray(new IASTFragment[result.size()]);
                }
                int offset = parent.getStartPosition() + parent.getLength();
                if (location == SwitchStatement.STATEMENTS_PROPERTY) {
                    SwitchStatement ss = (SwitchStatement)parent.getParent();
                    Iterator iterator = ss.statements().iterator();
                    int preOffset = -1;
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!(obj instanceof ASTNode)) continue;
                        ASTNode node = (ASTNode)obj;
                        if (node instanceof SwitchCase && node.getStartPosition() > offset) break;
                        preOffset = node.getStartPosition() + node.getLength();
                    }
                    if (preOffset > 0) {
                        offset = preOffset;
                    }
                }
                int i = 0;
                while (i < result.size()) {
                    if (((IASTFragment)result.get(i)).getStartPosition() > offset) {
                        upper = i;
                        break;
                    }
                    ++i;
                }
            }
            return result.subList(0, upper).toArray(new IASTFragment[upper]);
        }
        catch (JavaModelException javaModelException) {
            return result.toArray(new IASTFragment[result.size()]);
        }
    }

    public ExtractTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        this(unit, selectionStart, selectionLength, null);
    }

    public ExtractTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength, Map<String, String> formatterOptions) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fCompilationUnitNode = null;
        this.fReplaceAllOccurrences = true;
        this.fReplaceAllOccurrencesInThisFile = false;
        this.fDeclareFinal = false;
        this.fDeclareVarType = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
        this.fCheckResultForCompileProblems = true;
        this.fStartPoint = -1;
        this.fEndPoint = -1;
        this.fEnclosingKey = null;
        this.fEnclosingKeySet = new HashSet();
        this.fFormatterOptions = formatterOptions;
    }

    public ExtractTempRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength) {
        this(astRoot, selectionStart, selectionLength, null);
    }

    public ExtractTempRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength, Map<String, String> formatterOptions) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(astRoot.getTypeRoot() instanceof ICompilationUnit));
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = (ICompilationUnit)astRoot.getTypeRoot();
        this.fCompilationUnitNode = astRoot;
        this.fReplaceAllOccurrences = true;
        this.fReplaceAllOccurrencesInThisFile = false;
        this.fDeclareFinal = false;
        this.fDeclareVarType = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
        this.fCheckResultForCompileProblems = true;
        this.fStartPoint = -1;
        this.fEndPoint = -1;
        this.fEnclosingKey = null;
        this.fEnclosingKeySet = new HashSet();
        this.fFormatterOptions = formatterOptions;
    }

    public ExtractTempRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this((ICompilationUnit)null, 0, 0);
        this.fStartPoint = -1;
        this.fEndPoint = -1;
        this.fEnclosingKey = null;
        this.fEnclosingKeySet = new HashSet();
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public void setCheckResultForCompileProblems(boolean checkResultForCompileProblems) {
        this.fCheckResultForCompileProblems = checkResultForCompileProblems;
    }

    public void setLinkedProposalModel(LinkedProposalModelCore linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    private void addReplaceExpressionWithTemp() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = this.retainOnlyReplacableMatches(this.getMatchingFragments());
        if (fragmentsToReplace.length == 0 || this.fEndPoint == -1) {
            return;
        }
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        int i = this.fEndPoint;
        while (i >= this.fStartPoint) {
            IASTFragment fragment = fragmentsToReplace[i];
            if (this.fSeen.add(fragment)) {
                SimpleName tempName = this.fCURewrite.getAST().newSimpleName(this.fTempName);
                TextEditGroup description = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_replace);
                fragment.replace(rewrite, (ASTNode)tempName, description);
                if (this.fLinkedProposalModel != null) {
                    this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track((ASTNode)tempName), false);
                }
            }
            --i;
        }
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (selectedExpression != null) {
            ASTNode parent = selectedExpression.getParent();
            if (selectedExpression instanceof NullLiteral) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
            }
            if (selectedExpression instanceof ArrayInitializer) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
            }
            if (selectedExpression instanceof Assignment) {
                if (parent instanceof Expression && !(parent instanceof ParenthesizedExpression)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
                }
                return null;
            }
            if (selectedExpression instanceof SimpleName) {
                if (((SimpleName)selectedExpression).isDeclaration()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
                }
                if (parent instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || parent instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
                }
            } else if (selectedExpression instanceof VariableDeclarationExpression && parent instanceof TryStatement) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_resource_in_try_with_resources);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, null, (String)JavaManipulationPlugin.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_no_void, null, (String)JavaManipulationPlugin.getPluginId(), (int)65, null);
            }
            case 0: 
            case 3: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private ITypeBinding guessBindingForReference(Expression expression) {
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding == null) {
            binding = ASTResolving.guessBindingForReference((ASTNode)expression);
        }
        return binding;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            RefactoringStatus checkSideEffectsInSelectedExpression;
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 4);
            this.fCURewrite = new CompilationUnitRewrite(null, this.fCu, this.fCompilationUnitNode, this.fFormatterOptions);
            this.fCURewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
            RefactoringStatus result = new RefactoringStatus();
            this.fStartPoint = -1;
            this.fEndPoint = -1;
            this.fSeen.clear();
            boolean replaceAll = this.fReplaceAllOccurrences;
            if (this.fReplaceAllOccurrences && (checkSideEffectsInSelectedExpression = this.checkSideEffectsInSelectedExpression()).hasInfo()) {
                this.fReplaceAllOccurrences = false;
                result.merge(checkSideEffectsInSelectedExpression);
            }
            this.doCreateChange((IProgressMonitor)new SubProgressMonitor(pm, 2));
            this.fChange = this.fCURewrite.createChange(RefactoringCoreMessages.ExtractTempRefactoring_change_name, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.fChange.getEdit().accept(new TextEditVisitor(){

                public void preVisit(TextEdit edit) {
                    TextEdit[] children;
                    TextEdit[] textEditArray = children = edit.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CopySourceEdit cse;
                        TextEdit te = textEditArray[n2];
                        if (te instanceof CopySourceEdit && ((cse = (CopySourceEdit)te).getTargetEdit() == null || cse.getTargetEdit().getOffset() == 0)) {
                            edit.removeChild(te);
                        }
                        ++n2;
                    }
                    super.preVisit(edit);
                }
            });
            if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fTempName)) {
                result.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, BasicElementLabels.getJavaElementName(this.fTempName)));
            }
            result.merge(this.checkMatchingFragments());
            this.fChange.setKeepPreviewEdits(false);
            if (this.fCheckResultForCompileProblems) {
                result.merge(RefactoringAnalyzeUtil.checkNewSource(this.fChange, this.fCu, this.fCompilationUnitNode, pm));
            }
            this.fReplaceAllOccurrences = replaceAll;
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private final ExtractLocalDescriptor createRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fTempName));
        String expression = ASTNodes.asString((ASTNode)this.fSelectedExpression.getAssociatedExpression());
        String header = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fTempName), BasicElementLabels.getJavaCodeString(expression)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_name_pattern, BasicElementLabels.getJavaElementName(this.fTempName)));
        BodyDeclaration decl = ASTNodes.getParent((ASTNode)this.fSelectedExpression.getAssociatedExpression(), BodyDeclaration.class);
        if (decl instanceof MethodDeclaration) {
            IMethodBinding method = ((MethodDeclaration)decl).resolveBinding();
            String label = method != null ? BindingLabelProviderCore.getBindingLabel((IBinding)method, 2235681801344L) : BasicElementLabels.getJavaElementName("{...}");
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_destination_pattern, label));
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_expression_pattern, BasicElementLabels.getJavaCodeString(expression)));
        if (this.fReplaceAllOccurrences) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences);
        }
        if (this.fReplaceAllOccurrencesInThisFile) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences_in_this_file);
        }
        if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_declare_final);
        }
        if (this.fDeclareVarType) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_declare_var_type);
        }
        ExtractLocalDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractLocalDescriptor(project, description, comment.asString(), arguments, 0);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
        arguments.put(KEY_NAME, this.fTempName);
        arguments.put("selection", Integer.toString(this.fSelectionStart) + " " + Integer.toString(this.fSelectionLength));
        arguments.put(ATTRIBUTE_REPLACE, Boolean.toString(this.fReplaceAllOccurrences));
        arguments.put(ATTRIBUTE_REPLACE_ALL, Boolean.toString(this.fReplaceAllOccurrencesInThisFile));
        arguments.put(ATTRIBUTE_FINAL, Boolean.toString(this.fDeclareFinal));
        arguments.put(ATTRIBUTE_TYPE_VAR, Boolean.toString(this.fDeclareVarType));
        return descriptor;
    }

    private void doCreateChange(IProgressMonitor pm) {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            try {
                this.processSelectedExpression();
                if (this.replaceAllOccurrences() && this.replaceAllOccurrencesInThisFile()) {
                    this.processOtherIdenticalExpressions();
                }
            }
            catch (CoreException exception) {
                JavaManipulationPlugin.log(exception);
            }
        }
        finally {
            pm.done();
        }
    }

    private void processSelectedExpression() throws CoreException {
        int cnt = 1;
        this.getSelectedExpression();
        MethodDeclaration methodDeclaration = ASTNodes.getFirstAncestorOrNull(this.fSelectedExpression.getAssociatedNode(), MethodDeclaration.class);
        if (methodDeclaration != null && methodDeclaration.resolveBinding() != null && methodDeclaration.resolveBinding().getMethodDeclaration() != null) {
            this.fEnclosingKey = methodDeclaration.resolveBinding().getMethodDeclaration().getKey();
            this.fEnclosingKeySet.add(this.fEnclosingKey);
        }
        this.fSelectionStart = this.fSelectedExpression.getStartPosition();
        this.fSelectionLength = this.fSelectedExpression.getLength();
        IASTFragment[] retainOnlyReplacableMatches = this.retainOnlyReplacableMatches(this.getMatchingFragments());
        int tmpFSelectionStart = this.fSelectionStart;
        int tmpFSelectionLength = this.fSelectionLength;
        IExpressionFragment tmpFSelectedExpression = this.fSelectedExpression;
        Collection<String> usedNames = this.getUsedLocalNames(this.fSelectedExpression.getAssociatedNode());
        String newName = this.fTempName;
        if (!this.replaceAllOccurrences() || this.shouldReplaceSelectedExpressionWithTempDeclaration() || retainOnlyReplacableMatches.length == 0) {
            this.createTempDeclaration();
            this.addReplaceExpressionWithTemp();
            this.fTempName = newName + ++cnt;
            while (usedNames.contains(this.fTempName)) {
                this.fTempName = newName + ++cnt;
            }
        }
        while (this.replaceAllOccurrences() && retainOnlyReplacableMatches.length > this.fSeen.size()) {
            this.fStartPoint = -1;
            this.fEndPoint = -1;
            boolean flag = false;
            int i = 0;
            while (i < retainOnlyReplacableMatches.length) {
                if (!this.fSeen.contains(retainOnlyReplacableMatches[i])) {
                    this.fSelectionStart = retainOnlyReplacableMatches[i].getStartPosition();
                    this.fSelectionLength = retainOnlyReplacableMatches[i].getLength();
                    this.fSelectedExpression = null;
                    this.getSelectedExpression();
                    flag = true;
                    break;
                }
                ++i;
            }
            if (!flag) break;
            this.createTempDeclaration();
            if (this.fStartPoint == -1 || this.fEndPoint == -1) continue;
            this.addReplaceExpressionWithTemp();
            this.fTempName = newName + ++cnt;
            while (usedNames.contains(this.fTempName)) {
                this.fTempName = newName + ++cnt;
            }
        }
        this.fSelectionStart = tmpFSelectionStart;
        this.fSelectionLength = tmpFSelectionLength;
        this.fSelectedExpression = tmpFSelectedExpression;
        this.fTempName = newName;
    }

    private void processOtherIdenticalExpressions() throws CoreException {
        ASTNode associatedNode = this.getSelectedExpression().getAssociatedNode();
        CompilationUnit cuNode = ASTNodes.getFirstAncestorOrNull(associatedNode, CompilationUnit.class);
        IdenticalExpressionFinder identicalExpressionFinder = new IdenticalExpressionFinder(associatedNode);
        cuNode.accept((ASTVisitor)identicalExpressionFinder);
        ASTNode[] matchedFragments = identicalExpressionFinder.getIdenticalFragments();
        HashMap<ASTNode, String> enclosingKeyMap = identicalExpressionFinder.getEclosingKeyMap();
        int realStartOffset = this.getRealStartOffset(matchedFragments, enclosingKeyMap);
        int realLength = this.fSelectionLength;
        ASTNode[] aSTNodeArray = matchedFragments;
        int n = matchedFragments.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode fragment = aSTNodeArray[n2];
            this.fSeen.clear();
            if (!this.fEnclosingKeySet.contains(enclosingKeyMap.get(fragment))) {
                this.fSelectedExpression = this.getSelectedExpression(fragment.getStartPosition() + realStartOffset, realLength);
                this.processSelectedExpression();
            }
            ++n2;
        }
    }

    private int getRealStartOffset(ASTNode[] matchedFragments, HashMap<ASTNode, String> enclosingKeyMap) {
        int realStartOffset = 0;
        ASTNode[] aSTNodeArray = matchedFragments;
        int n = matchedFragments.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode fragment = aSTNodeArray[n2];
            if (fragment.getLength() == this.fSelectionLength) {
                return realStartOffset;
            }
            if (this.fEnclosingKeySet.contains(enclosingKeyMap.get(fragment))) {
                int startOffset = Math.abs(this.fSelectionStart - fragment.getStartPosition());
                realStartOffset = realStartOffset != 0 ? Math.min(realStartOffset, startOffset) : startOffset;
            }
            ++n2;
        }
        return realStartOffset;
    }

    private Collection<String> getUsedLocalNames(ASTNode selected) {
        ASTNode surroundingBlock = selected;
        while ((surroundingBlock = surroundingBlock.getParent()) != null) {
            if (surroundingBlock instanceof Block || surroundingBlock instanceof MethodDeclaration) break;
        }
        if (surroundingBlock == null) {
            return new ArrayList<String>();
        }
        Collection<String> localUsedNames = new ScopeAnalyzer((CompilationUnit)selected.getRoot()).getUsedVariableNames(surroundingBlock.getStartPosition(), surroundingBlock.getLength());
        return localUsedNames;
    }

    private String getUsedNameForIdenticalExpressionInCu(ASTNode selected) {
        ASTNode surroundingBlock = selected;
        if ((surroundingBlock = ASTNodes.getFirstAncestorOrNull(surroundingBlock, CompilationUnit.class)) == null) {
            return null;
        }
        LocalVariableWithIdenticalExpressionFinder localVariableWithIdenticalExpressionFinder = new LocalVariableWithIdenticalExpressionFinder(selected, Boolean.TRUE);
        String usedNameForIdenticalExpressionInCu = null;
        try {
            surroundingBlock.accept((ASTVisitor)localVariableWithIdenticalExpressionFinder);
        }
        catch (AbortSearchException abortSearchException) {
            usedNameForIdenticalExpressionInCu = localVariableWithIdenticalExpressionFinder.getUsedName();
        }
        return usedNameForIdenticalExpressionInCu;
    }

    private Collection<String> getUsedNameForIdenticalExpressionInMethod(ASTNode selected) {
        ASTNode surroundingBlock = selected;
        if ((surroundingBlock = ASTNodes.getFirstAncestorOrNull(surroundingBlock, MethodDeclaration.class)) == null) {
            return new ArrayList<String>();
        }
        LocalVariableWithIdenticalExpressionFinder localVariableWithIdenticalExpressionFinder = new LocalVariableWithIdenticalExpressionFinder(selected, Boolean.FALSE);
        surroundingBlock.accept((ASTVisitor)localVariableWithIdenticalExpressionFinder);
        ArrayList<String> UsedNameForIdenticalExpressionInMethod = localVariableWithIdenticalExpressionFinder.getUsedNames();
        return UsedNameForIdenticalExpressionInMethod;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 6);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext(), pm);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fCompilationUnitNode == null) {
                this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            } else {
                pm.worked(3);
            }
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (!result.hasFatalError() && this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkMatchingFragments() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IASTFragment[] iASTFragmentArray = this.getMatchingFragments();
        int n = iASTFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFragment matchingFragment = iASTFragmentArray[n2];
            ASTNode node = matchingFragment.getAssociatedNode();
            if (ExtractTempRefactoring.isLeftValue(node) && !ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
                String msg = RefactoringCoreMessages.ExtractTempRefactoring_assigned_to;
                result.addWarning(msg, JavaStatusContext.create((ITypeRoot)this.fCu, node));
            }
            ++n2;
        }
        return result;
    }

    private RefactoringStatus checkSideEffectsInSelectedExpression() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.replaceAllOccurrences() && this.retainOnlyReplacableMatches(this.getMatchingFragments()).length > 1) {
            SideEffectChecker ev = new SideEffectChecker(this.getSelectedExpression().getAssociatedNode(), this.fEnclosingKey);
            ASTNode node = this.getSelectedExpression().getAssociatedNode();
            node.accept((ASTVisitor)ev);
            if (ev.hasSideEffect()) {
                String msg = RefactoringCoreMessages.ExtractTempRefactoring_side_effcts_in_selected_expression;
                result.addInfo(msg, JavaStatusContext.create((ITypeRoot)this.fCu, node));
            }
        }
        return result;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask("", 8);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.isUsedInExplicitConstructorCall()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_explicit_constructor);
                return refactoringStatus;
            }
            pm.worked(1);
            ASTNode associatedNode = selectedExpression.getAssociatedNode();
            if (this.getEnclosingBodyNode() == null || ASTNodes.getParent(associatedNode, Annotation.class) != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_expr_in_method_or_initializer);
                return refactoringStatus;
            }
            pm.worked(1);
            if (associatedNode instanceof Name && associatedNode.getParent() instanceof ClassInstanceCreation && associatedNode.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpressionFragmentIsRValue());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isReferringToLocalVariableFromFor(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_refers_to_for_variable);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.checkTempName(newName, (IJavaElement)this.fCu);
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, BasicElementLabels.getJavaElementName(newName)));
        }
        return status;
    }

    private boolean hasFinalModifer(List<IExtendedModifier> modifiers) {
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isModifier() || !Modifier.isFinal((int)((Modifier)modifier).getKeyword().toFlagValue())) continue;
            return true;
        }
        return false;
    }

    private void createAndInsertTempDeclaration() throws CoreException {
        IASTFragment[] retainOnlyReplacableMatches;
        IASTFragment[] replacableMatches;
        Expression initializer = this.getSelectedExpression().createCopyTarget(this.fCURewrite.getASTRewrite(), true);
        VariableDeclarationStatement vds = this.createTempDeclaration(initializer);
        boolean insertAtSelection = !this.fReplaceAllOccurrences ? true : (replacableMatches = this.retainOnlyReplacableMatches(this.getMatchingFragments())).length == 0 || replacableMatches.length == 1 && replacableMatches[0].getAssociatedNode().equals((Object)this.getSelectedExpression().getAssociatedExpression());
        Statement node = ASTResolving.findParentStatement(this.getSelectedExpression().getAssociatedNode());
        if (node instanceof SwitchCase) {
            if (!this.hasFinalModifer(vds.modifiers())) {
                vds.modifiers().add(vds.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
            }
            node = ASTNodes.getParent((ASTNode)node, SwitchStatement.class);
            this.fDeclareFinal = true;
        }
        if ((retainOnlyReplacableMatches = this.retainOnlyReplacableMatches(this.getMatchingFragments())) == null) {
            return;
        }
        int selectNumber = -1;
        int i = 0;
        while (i < retainOnlyReplacableMatches.length) {
            if (this.fSelectionStart == retainOnlyReplacableMatches[i].getStartPosition()) {
                selectNumber = i;
                break;
            }
            ++i;
        }
        if (node instanceof SwitchStatement || node instanceof EnhancedForStatement) {
            this.fStartPoint = 0;
            this.fEndPoint = retainOnlyReplacableMatches.length - 1;
            this.insertAt((ASTNode)node, (Statement)vds);
            return;
        }
        if (insertAtSelection) {
            ASTNode realCommonASTNode = null;
            realCommonASTNode = this.evalStartAndEnd(retainOnlyReplacableMatches, selectNumber, null);
            if (realCommonASTNode == null && selectNumber >= 0) {
                this.fSeen.add(retainOnlyReplacableMatches[selectNumber]);
            }
            if (realCommonASTNode != null || retainOnlyReplacableMatches.length == 0) {
                this.insertAt(this.getSelectedExpression().getAssociatedNode(), (Statement)vds);
            }
            return;
        }
        ASTNode realCommonASTNode = null;
        realCommonASTNode = this.evalStartAndEnd(retainOnlyReplacableMatches, selectNumber, null);
        if (realCommonASTNode == null && selectNumber >= 0) {
            this.fSeen.add(retainOnlyReplacableMatches[selectNumber]);
        }
        if (realCommonASTNode != null) {
            this.insertAt(realCommonASTNode, (Statement)vds);
        }
    }

    private ASTNode evalStartAndEnd(IASTFragment[] retainOnlyReplacableMatches, int selectNumber, Integer fixedStartOffset) throws JavaModelException {
        ASTNode realCommonASTNode = null;
        if (selectNumber < 0 || selectNumber >= retainOnlyReplacableMatches.length) {
            return realCommonASTNode;
        }
        int start = selectNumber;
        int end = selectNumber;
        int expandFlag = 2;
        ChangedValueChecker cvc = new ChangedValueChecker(this.getSelectedExpression().getAssociatedNode(), this.fEnclosingKey);
        while (expandFlag > 0 && start <= end) {
            IASTFragment iASTFragment = retainOnlyReplacableMatches[start];
            ASTNode firstReplaceExpression = this.getCertainReplacedExpression(retainOnlyReplacableMatches, start).getAssociatedNode();
            ASTNode[] firstReplaceNodeParents = ExtractTempRefactoring.getParents(firstReplaceExpression);
            ASTNode[] commonPath = start == end ? firstReplaceNodeParents : this.findDeepestCommonSuperNodePathForReplacedNodes(start, end);
            Assert.isTrue((commonPath.length <= firstReplaceNodeParents.length ? 1 : 0) != 0);
            ASTNode deepestCommonParent = firstReplaceNodeParents[commonPath.length - 1];
            ASTNode expression = iASTFragment.getAssociatedNode();
            int endOffset = expression.getStartPosition();
            ASTNode commonASTNode = deepestCommonParent instanceof Block ? firstReplaceNodeParents[commonPath.length] : deepestCommonParent;
            commonASTNode = this.convertToExtractNode(commonASTNode);
            boolean flag = false;
            int startOffset = fixedStartOffset != null ? fixedStartOffset : commonASTNode.getStartPosition() - 1;
            int lastExprOffset = retainOnlyReplacableMatches[end].getStartPosition();
            UnsafeCheckTester uct = new UnsafeCheckTester(this.fCompilationUnitNode, this.fCu, commonASTNode, expression, startOffset, endOffset);
            ArrayList<IASTFragment> candidateList = new ArrayList<IASTFragment>();
            int i = start;
            while (i <= end) {
                candidateList.add(retainOnlyReplacableMatches[i]);
                ++i;
            }
            cvc.detectConflict(startOffset, lastExprOffset, retainOnlyReplacableMatches[end].getAssociatedNode(), deepestCommonParent, candidateList);
            boolean bl = flag = !uct.hasUnsafeCheck() && !cvc.hasConflict();
            if (flag) {
                this.fStartPoint = start;
                this.fEndPoint = end;
                realCommonASTNode = commonASTNode;
                if (expandFlag == 2 && (end == retainOnlyReplacableMatches.length - 1 || this.fSeen.contains(retainOnlyReplacableMatches[end + 1]))) {
                    expandFlag = 1;
                }
                if (expandFlag == 1 && (start == 0 || this.fSeen.contains(retainOnlyReplacableMatches[start - 1]))) {
                    expandFlag = 0;
                }
                if (expandFlag == 1) {
                    --start;
                    continue;
                }
                if (expandFlag != 2) continue;
                ++end;
                continue;
            }
            if (expandFlag == 2) {
                expandFlag = 1;
                if (end != selectNumber) {
                    --end;
                }
                if (start == 0) {
                    expandFlag = 0;
                    continue;
                }
                --start;
                continue;
            }
            expandFlag = 0;
        }
        return realCommonASTNode;
    }

    private ASTNode convertToExtractNode(ASTNode target) {
        ASTNode parent = target.getParent();
        StructuralPropertyDescriptor locationInParent = target.getLocationInParent();
        while (locationInParent != Block.STATEMENTS_PROPERTY && locationInParent != SwitchStatement.STATEMENTS_PROPERTY) {
            if (locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY || locationInParent == LambdaExpression.BODY_PROPERTY && ((LambdaExpression)parent).getBody() instanceof Expression) break;
            target = parent;
            parent = parent.getParent();
            locationInParent = target.getLocationInParent();
        }
        return target;
    }

    private VariableDeclarationStatement createTempDeclaration(Expression initializer) throws CoreException {
        AST ast = this.fCURewrite.getAST();
        VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
        vdf.setName(ast.newSimpleName(this.fTempName));
        vdf.setInitializer(initializer);
        VariableDeclarationStatement vds = ast.newVariableDeclarationStatement(vdf);
        if (this.fDeclareFinal && !this.hasFinalModifer(vds.modifiers())) {
            vds.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        }
        vds.setType(this.createTempType());
        if (this.fLinkedProposalModel != null) {
            ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
            LinkedProposalPositionGroupCore nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            nameGroup.addPosition(rewrite.track((ASTNode)vdf.getName()), true);
            String[] nameSuggestions = this.guessTempNamesWithContext();
            if (nameSuggestions.length > 0 && !nameSuggestions[0].equals(this.fTempName)) {
                nameGroup.addProposal(this.fTempName, nameSuggestions.length + 1);
            }
            int i = 0;
            while (i < nameSuggestions.length) {
                nameGroup.addProposal(nameSuggestions[i], nameSuggestions.length - i);
                ++i;
            }
        }
        return vds;
    }

    private void insertAt(ASTNode target, Statement declaration) {
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        TextEditGroup groupDescription = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable);
        ASTNode parent = target.getParent();
        StructuralPropertyDescriptor locationInParent = target.getLocationInParent();
        while (locationInParent != Block.STATEMENTS_PROPERTY && locationInParent != SwitchStatement.STATEMENTS_PROPERTY) {
            if (locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY) {
                Block replacement = rewrite.getAST().newBlock();
                ListRewrite replacementRewrite = rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst((ASTNode)declaration, null);
                replacementRewrite.insertLast(rewrite.createMoveTarget(target), null);
                rewrite.replace(target, (ASTNode)replacement, groupDescription);
                return;
            }
            if (locationInParent == LambdaExpression.BODY_PROPERTY && ((LambdaExpression)parent).getBody() instanceof Expression) {
                Block replacement = rewrite.getAST().newBlock();
                ListRewrite replacementRewrite = rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst((ASTNode)declaration, null);
                ASTNode moveTarget = rewrite.createMoveTarget(target);
                AST ast = rewrite.getAST();
                if (Bindings.isVoidType(((LambdaExpression)parent).resolveMethodBinding().getReturnType())) {
                    ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)moveTarget);
                    moveTarget = expressionStatement;
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)moveTarget);
                    moveTarget = returnStatement;
                }
                replacementRewrite.insertLast(moveTarget, null);
                rewrite.replace(target, (ASTNode)replacement, groupDescription);
                return;
            }
            target = parent;
            parent = parent.getParent();
            locationInParent = target.getLocationInParent();
        }
        ListRewrite listRewrite = rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)locationInParent);
        listRewrite.insertBefore((ASTNode)declaration, target, groupDescription);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            ExtractLocalDescriptor descriptor = this.createRefactoringDescriptor();
            this.fChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            CompilationUnitChange compilationUnitChange = this.fChange;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void createTempDeclaration() throws CoreException {
        if (this.shouldReplaceSelectedExpressionWithTempDeclaration()) {
            this.replaceSelectedExpressionWithTempDeclaration();
        } else {
            this.createAndInsertTempDeclaration();
        }
    }

    public boolean declareFinal() {
        return this.fDeclareFinal;
    }

    public boolean declareVarType() {
        return this.fDeclareVarType;
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes(int start, int end) throws JavaModelException {
        ASTNode[] matchNodes = this.getMatchNodes();
        ASTNode[][] matchingNodesParents = new ASTNode[end + 1 - start][];
        int i = start;
        while (i < matchNodes.length && i < end + 1) {
            matchingNodesParents[i - start] = ExtractTempRefactoring.getParents(matchNodes[i]);
            ++i;
        }
        List<ASTNode> l = Arrays.asList(ExtractTempRefactoring.getLongestArrayPrefix(matchingNodesParents));
        return l.toArray(new ASTNode[l.size()]);
    }

    private ASTNode getEnclosingBodyNode() throws JavaModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        StructuralPropertyDescriptor location = null;
        while (node != null && !(node instanceof BodyDeclaration)) {
            location = node.getLocationInParent();
            if ((node = node.getParent()) instanceof LambdaExpression) break;
        }
        if (location == MethodDeclaration.BODY_PROPERTY || location == Initializer.BODY_PROPERTY || location == LambdaExpression.BODY_PROPERTY && ((LambdaExpression)node).resolveMethodBinding() != null) {
            if ((node = (ASTNode)node.getStructuralProperty(location)) instanceof MethodDeclaration && ((MethodDeclaration)node).resolveBinding() != null && ((MethodDeclaration)node).resolveBinding().getMethodDeclaration() != null) {
                this.fEnclosingKey = ((MethodDeclaration)node).resolveBinding().getMethodDeclaration().getKey();
            } else if (node instanceof LambdaExpression && ((LambdaExpression)node).resolveMethodBinding().getMethodDeclaration() != null) {
                this.fEnclosingKey = ((LambdaExpression)node).resolveMethodBinding().getMethodDeclaration().getKey();
            }
            return node;
        }
        return null;
    }

    private static boolean excludeVariableName(ASTNode enclosingNode, int modifiers, IBinding binding) {
        if (Modifier.isStatic((int)modifiers) && !Modifier.isStatic((int)binding.getModifiers())) {
            ASTNode bindingMethodDeclarationparent;
            VariableDeclaration bindingDeclaration = ASTNodes.findVariableDeclaration((IVariableBinding)binding, enclosingNode.getRoot());
            return bindingDeclaration != null && enclosingNode == (bindingMethodDeclarationparent = ASTNodes.getParent((ASTNode)bindingDeclaration, 31));
        }
        return true;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 18);
                ASTNode enclosingNode = this.getEnclosingBodyNode().getParent();
                ArrayList<String> excludedVariableNames = new ArrayList<String>();
                IBinding[] iBindingArray = bindings;
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding binding = iBindingArray[n2];
                    BodyDeclaration bodyDeclaration = ASTNodes.getParent(this.getEnclosingBodyNode(), BodyDeclaration.class);
                    int modifiers = bodyDeclaration.getModifiers();
                    int n3 = modifiers = bodyDeclaration instanceof TypeDeclaration ? (modifiers = modifiers & 0xFFFFFFF7) : modifiers;
                    if (ExtractTempRefactoring.excludeVariableName(enclosingNode, modifiers, binding)) {
                        excludedVariableNames.add(binding.getName());
                    }
                    ++n2;
                }
                this.fExcludedVariableNames = excludedVariableNames.toArray(new String[0]);
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private IExpressionFragment getCertainReplacedExpression(IASTFragment[] nodesToReplace, int index) throws JavaModelException {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        if (nodesToReplace.length == 0) {
            return this.getSelectedExpression();
        }
        if (index >= nodesToReplace.length) {
            return (IExpressionFragment)nodesToReplace[nodesToReplace.length - 1];
        }
        return (IExpressionFragment)nodesToReplace[index];
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        if (this.fReplaceAllOccurrences) {
            IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree(this.getEnclosingBodyNode()).getSubFragmentsMatching(this.getSelectedExpression());
            return allMatches;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private ASTNode[] getMatchNodes() throws JavaModelException {
        IASTFragment[] matches = this.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTNode[] result = new ASTNode[matches.length];
        int i = 0;
        while (i < matches.length) {
            result[i] = matches[i].getAssociatedNode();
            ++i;
        }
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractTempRefactoring_name;
    }

    private IExpressionFragment getSelectedExpression(int startOffset, int length) throws JavaModelException {
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)new SourceRange(startOffset, length), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            if (selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
                Expression expression = exprStatement.getExpression();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (selectedFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)selectedFragment.getAssociatedNode();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            }
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            if (selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
                Expression expression = exprStatement.getExpression();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (selectedFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)selectedFragment.getAssociatedNode();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            }
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private Type createTempType() throws CoreException {
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        SimpleType resultingType = null;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        AST ast = rewrite.getAST();
        if (this.isVarTypeAllowed() && this.fDeclareVarType) {
            resultingType = ast.newSimpleType((Name)ast.newSimpleName("var"));
        } else if (expression instanceof ClassInstanceCreation && (typeBinding == null || typeBinding.getTypeArguments().length == 0)) {
            resultingType = (Type)rewrite.createCopyTarget((ASTNode)((ClassInstanceCreation)expression).getType());
        } else if (expression instanceof CastExpression) {
            resultingType = (Type)rewrite.createCopyTarget((ASTNode)((CastExpression)expression).getType());
        } else {
            if (typeBinding == null) {
                typeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
            }
            if (typeBinding != null) {
                typeBinding = Bindings.normalizeForDeclarationUse(typeBinding, ast);
                ImportRewrite importRewrite = this.fCURewrite.getImportRewrite();
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)expression, importRewrite);
                resultingType = importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
            } else {
                resultingType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            }
        }
        if (this.fLinkedProposalModel != null) {
            LinkedProposalPositionGroupCore typeGroup = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
            typeGroup.addPosition(rewrite.track((ASTNode)resultingType), false);
            if (typeBinding != null) {
                ITypeBinding[] relaxingTypes = ASTResolving.getNarrowingTypes(ast, typeBinding);
                int i = 0;
                while (i < relaxingTypes.length) {
                    typeGroup.addProposal(relaxingTypes[i], this.fCURewrite.getCu(), relaxingTypes.length - i);
                    ++i;
                }
            }
        }
        return resultingType;
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.fTempName;
        }
        return proposals[0];
    }

    public String guessTempNameWithContext() {
        String[] proposals = this.guessTempNamesWithContext();
        if (proposals.length == 0) {
            return this.fTempName;
        }
        return proposals[0];
    }

    public String[] guessTempNames() {
        if (this.fGuessedTempNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding binding = this.guessBindingForReference(expression);
                    this.fGuessedTempNames = StubUtility.getVariableNameSuggestions(5, this.fCu.getJavaProject(), binding, expression, Arrays.asList(this.getExcludedVariableNames()));
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
            if (this.fGuessedTempNames == null) {
                this.fGuessedTempNames = new String[0];
            }
        }
        return this.fGuessedTempNames;
    }

    public String[] guessTempNamesWithContext() {
        if (this.fGuessedTempNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding binding = this.guessBindingForReference(expression);
                    String usedNameForIdenticalExpressionInCu = this.getUsedNameForIdenticalExpressionInCu(this.fSelectedExpression.getAssociatedNode());
                    Collection<String> usedNamesForIdenticalExpressionInMethod = this.getUsedNameForIdenticalExpressionInMethod(this.fSelectedExpression.getAssociatedNode());
                    this.fGuessedTempNames = StubUtility.getVariableNameSuggestions(5, this.fCu.getJavaProject(), binding, expression, Arrays.asList(this.getExcludedVariableNames()), usedNameForIdenticalExpressionInCu, usedNamesForIdenticalExpressionInMethod);
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
            if (this.fGuessedTempNames == null) {
                this.fGuessedTempNames = new String[0];
            }
        }
        return this.fGuessedTempNames;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (ASTNodes.getParent((ASTNode)selectedExpression, ConstructorInvocation.class) != null) {
            return true;
        }
        return ASTNodes.getParent((ASTNode)selectedExpression, SuperConstructorInvocation.class) != null;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public boolean replaceAllOccurrencesInThisFile() {
        return this.fReplaceAllOccurrencesInThisFile;
    }

    private void replaceSelectedExpressionWithTempDeclaration() throws CoreException {
        VariableDeclarationStatement replacement;
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        this.evalStartAndEnd(this.retainOnlyReplacableMatches(this.getMatchingFragments()), 0, selectedExpression.getStartPosition() + selectedExpression.getLength());
        Expression initializer = (Expression)rewrite.createMoveTarget((ASTNode)selectedExpression);
        VariableDeclarationStatement tempDeclaration = this.createTempDeclaration(initializer);
        ASTNode parent = selectedExpression.getParent();
        boolean isParentLambda = parent instanceof LambdaExpression;
        AST ast = rewrite.getAST();
        if (isParentLambda) {
            Block blockBody = ast.newBlock();
            blockBody.statements().add(tempDeclaration);
            if (!Bindings.isVoidType(((LambdaExpression)parent).resolveMethodBinding().getReturnType())) {
                List fragments = tempDeclaration.fragments();
                SimpleName varName = ((VariableDeclarationFragment)fragments.get(0)).getName();
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression((Expression)ast.newSimpleName(varName.getIdentifier()));
                blockBody.statements().add(returnStatement);
            }
            replacement = blockBody;
        } else if (ASTNodes.isControlStatementBody(parent.getLocationInParent())) {
            Block block = ast.newBlock();
            block.statements().add(tempDeclaration);
            replacement = block;
        } else {
            replacement = tempDeclaration;
        }
        Expression replacee = isParentLambda || !ASTNodes.hasSemicolon((ExpressionStatement)parent, this.fCu) ? selectedExpression : parent;
        rewrite.replace((ASTNode)replacee, (ASTNode)replacement, this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable));
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareVarType(boolean declareVarType) {
        this.fDeclareVarType = declareVarType;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setReplaceAllOccurrencesInThisFile(boolean replaceAllOccurrencesInThisFile) {
        this.fReplaceAllOccurrencesInThisFile = replaceAllOccurrencesInThisFile;
    }

    public void setTempName(String newName) {
        this.fTempName = newName;
    }

    private boolean shouldReplaceSelectedExpressionWithTempDeclaration() throws JavaModelException {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        ASTNode associatedNode = selectedFragment.getAssociatedNode();
        IExpressionFragment firstExpression = this.getCertainReplacedExpression(this.retainOnlyReplacableMatches(this.getMatchingFragments()), 0);
        if (firstExpression.getStartPosition() < selectedFragment.getStartPosition()) {
            return false;
        }
        return (associatedNode.getParent() instanceof ExpressionStatement || associatedNode.getParent() instanceof LambdaExpression) && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(associatedNode));
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.parseInt(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.extract.temp");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCu = (ICompilationUnit)element;
        String name = arguments.getAttribute(KEY_NAME);
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
        }
        this.fTempName = name;
        String replace = arguments.getAttribute(ATTRIBUTE_REPLACE);
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
        }
        this.fReplaceAllOccurrences = Boolean.parseBoolean(replace);
        String replaceAll = arguments.getAttribute(ATTRIBUTE_REPLACE_ALL);
        if (replaceAll == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE_ALL));
        }
        this.fReplaceAllOccurrencesInThisFile = Boolean.parseBoolean(replaceAll);
        String declareFinal = arguments.getAttribute(ATTRIBUTE_FINAL);
        if (declareFinal == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
        }
        this.fDeclareFinal = Boolean.parseBoolean(declareFinal);
        String declareVarType = arguments.getAttribute(ATTRIBUTE_TYPE_VAR);
        if (declareVarType == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPE_VAR));
        }
        this.fDeclareVarType = Boolean.parseBoolean(declareVarType);
        return new RefactoringStatus();
    }

    public boolean isVarTypeAllowed() {
        IJavaProject javaProject;
        IJavaElement root;
        boolean isAllowed = false;
        if (this.fCompilationUnitNode != null && (root = this.fCompilationUnitNode.getJavaElement()) != null && (javaProject = root.getJavaProject()) != null && JavaModelUtil.is10OrHigher(javaProject)) {
            isAllowed = true;
        }
        return isAllowed;
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection<IVariableBinding> fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection<IVariableBinding> forInitializerVariables) {
            Assert.isNotNull(forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }

    private static final class IdenticalExpressionFinder
    extends GenericVisitor {
        private ArrayList<ASTNode> identicalFragments = new ArrayList();
        private ASTNode expression;
        private HashMap<ASTNode, String> enclosingKeyMap = new HashMap();

        public IdenticalExpressionFinder(ASTNode expression) {
            this.expression = expression;
        }

        public ASTNode[] getIdenticalFragments() {
            return this.identicalFragments.toArray(new ASTNode[this.identicalFragments.size()]);
        }

        public HashMap<ASTNode, String> getEclosingKeyMap() {
            return this.enclosingKeyMap;
        }

        @Override
        public boolean visitNode(ASTNode node) {
            if (node.subtreeMatch(new ASTMatcher(), (Object)this.expression)) {
                this.identicalFragments.add(node);
                MethodDeclaration methodDeclaration = ASTNodes.getFirstAncestorOrNull(node, MethodDeclaration.class);
                this.enclosingKeyMap.put(node, methodDeclaration.resolveBinding().getMethodDeclaration().getKey());
            }
            return true;
        }
    }

    private static final class LocalVariableWithIdenticalExpressionFinder
    extends ASTVisitor {
        private ArrayList<String> usedNames = new ArrayList();
        private ASTNode expression;
        private Boolean ifStopOnFirstMatch;

        public LocalVariableWithIdenticalExpressionFinder(ASTNode expression, Boolean ifStopOnFirstMatch) {
            this.expression = expression;
            this.ifStopOnFirstMatch = ifStopOnFirstMatch;
        }

        public String getUsedName() {
            return this.usedNames.get(0);
        }

        public ArrayList<String> getUsedNames() {
            return this.usedNames;
        }

        public void setUsedName(String usedName) {
            this.usedNames.add(usedName);
        }

        public boolean visit(VariableDeclarationStatement node) {
            for (Object obj : node.fragments()) {
                Expression initializer;
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)obj;
                if (fragment.getInitializer() == null || !(initializer = fragment.getInitializer()).subtreeMatch(new ASTMatcher(), (Object)this.expression)) continue;
                this.setUsedName(fragment.getName().toString());
                if (!this.ifStopOnFirstMatch.booleanValue()) continue;
                throw new AbortSearchException();
            }
            return true;
        }
    }
}

