/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;

public class NewAnnotationMemberProposal
extends ASTRewriteCorrectionProposal {
    private final ASTNode fInvocationNode;
    private final ITypeBinding fSenderBinding;

    public NewAnnotationMemberProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, int relevance) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        this.fInvocationNode = invocationNode;
        this.fSenderBinding = binding;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.fInvocationNode);
        ASTNode typeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            newTypeDecl = typeDecl;
        } else {
            astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        ASTNode aSTNode = newTypeDecl;
        if (aSTNode instanceof AnnotationTypeDeclaration) {
            void newAnnotationTypeDecl;
            AnnotationTypeDeclaration annotationTypeDeclaration = (AnnotationTypeDeclaration)aSTNode;
            AnnotationTypeDeclaration cfr_ignored_0 = (AnnotationTypeDeclaration)aSTNode;
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            AnnotationTypeMemberDeclaration newStub = this.getStub(rewrite, (AnnotationTypeDeclaration)newAnnotationTypeDecl);
            List members = newAnnotationTypeDecl.bodyDeclarations();
            int insertIndex = members.size();
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)newAnnotationTypeDecl, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            listRewriter.insertAt((ASTNode)newStub, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    private AnnotationTypeMemberDeclaration getStub(ASTRewrite rewrite, AnnotationTypeDeclaration targetTypeDecl) {
        AST ast = targetTypeDecl.getAST();
        AnnotationTypeMemberDeclaration decl = ast.newAnnotationTypeMemberDeclaration();
        SimpleName newNameNode = this.getNewName(rewrite);
        decl.modifiers().addAll(ASTNodeFactory.newModifiers((AST)ast, (int)this.evaluateModifiers(targetTypeDecl)));
        decl.setName(newNameNode);
        Type returnType = this.getNewType(rewrite);
        decl.setType(returnType);
        return decl;
    }

    /*
     * WARNING - void declaration
     */
    private Type getNewType(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        SimpleType newTypeNode = null;
        ITypeBinding binding = null;
        if (this.fInvocationNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            Expression value = ((MemberValuePair)this.fInvocationNode.getParent()).getValue();
            binding = value.resolveTypeBinding();
        } else {
            ASTNode aSTNode = this.fInvocationNode;
            if (aSTNode instanceof Expression) {
                void expression;
                Expression value = (Expression)aSTNode;
                Expression cfr_ignored_0 = (Expression)aSTNode;
                binding = expression.resolveTypeBinding();
            }
        }
        if (binding != null) {
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(this.fInvocationNode, this.getImportRewrite());
            newTypeNode = this.getImportRewrite().addImport(binding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
        }
        if (newTypeNode == null) {
            newTypeNode = ast.newSimpleType((Name)ast.newSimpleName("String"));
        }
        return newTypeNode;
    }

    /*
     * WARNING - void declaration
     */
    private int evaluateModifiers(AnnotationTypeDeclaration targetTypeDecl) {
        List methodDecls = targetTypeDecl.bodyDeclarations();
        int i = 0;
        while (i < methodDecls.size()) {
            Object curr = methodDecls.get(i);
            Object e = curr;
            if (e instanceof AnnotationTypeMemberDeclaration) {
                void annotation;
                AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration = (AnnotationTypeMemberDeclaration)e;
                AnnotationTypeMemberDeclaration cfr_ignored_0 = (AnnotationTypeMemberDeclaration)e;
                return annotation.getModifiers();
            }
            ++i;
        }
        return 0;
    }

    private SimpleName getNewName(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        String name = this.fInvocationNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY ? ((SimpleName)this.fInvocationNode).getIdentifier() : "value";
        SimpleName newNameNode = ast.newSimpleName(name);
        return newNameNode;
    }
}

