/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.reorg;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.util.ResourceUtil;

public final class LoggedCreateTargetQueries
implements ICreateTargetQueries {
    private final CreateTargetExecutionLog fLog;

    public LoggedCreateTargetQueries(CreateTargetExecutionLog log) {
        Assert.isNotNull((Object)log);
        this.fLog = log;
    }

    public ICreateTargetQuery createNewPackageQuery() {
        return new CreateTargetQuery();
    }

    public CreateTargetExecutionLog getCreateTargetExecutionLog() {
        return this.fLog;
    }

    private final class CreateTargetQuery
    implements ICreateTargetQuery {
        private CreateTargetQuery() {
        }

        private void createPackageFragmentRoot(IPackageFragmentRoot root) throws CoreException {
            IJavaProject project = root.getJavaProject();
            project.exists();
            IFolder folder = project.getProject().getFolder(root.getElementName());
            if (!folder.exists()) {
                ResourceUtil.createFolder(folder, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            List<IClasspathEntry> list = Arrays.asList(project.getRawClasspath());
            list.add(JavaCore.newSourceEntry((IPath)folder.getFullPath()));
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), (IProgressMonitor)new NullProgressMonitor());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getCreatedTarget(Object selection) {
            Object target = LoggedCreateTargetQueries.this.fLog.getCreatedElement(selection);
            if (target instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)target;
                IJavaElement parent = fragment.getParent();
                if (!(parent instanceof IPackageFragmentRoot)) return target;
                try {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                    if (!root.exists()) {
                        this.createPackageFragmentRoot(root);
                    }
                    if (fragment.exists()) return target;
                    root.createPackageFragment(fragment.getElementName(), true, (IProgressMonitor)new NullProgressMonitor());
                    return target;
                }
                catch (CoreException exception) {
                    JavaLanguageServerPlugin.log(exception);
                    return null;
                }
            }
            if (!(target instanceof IFolder)) return target;
            try {
                IFolder folder = (IFolder)target;
                IProject project = folder.getProject();
                project.exists();
                if (folder.exists()) return target;
                ResourceUtil.createFolder(folder, true, true, (IProgressMonitor)new NullProgressMonitor());
                return target;
            }
            catch (CoreException exception) {
                JavaLanguageServerPlugin.log(exception);
                return null;
            }
        }

        public String getNewButtonLabel() {
            return "unused";
        }
    }
}

