/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.codemanipulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class OverrideMethodsOperation {
    public static List<OverridableMethod> listOverridableMethods(IType type) {
        return OverrideMethodsOperation.listOverridableMethods(type, (IProgressMonitor)new NullProgressMonitor());
    }

    public static List<OverridableMethod> listOverridableMethods(IType type, IProgressMonitor monitor) {
        if (type == null || type.getCompilationUnit() == null) {
            return Collections.emptyList();
        }
        ArrayList<OverridableMethod> overridables = new ArrayList<OverridableMethod>();
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
        if (astRoot == null) {
            return Collections.emptyList();
        }
        try {
            IMethodBinding[] methods;
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding == null) {
                return overridables;
            }
            IMethodBinding cloneMethod = null;
            ITypeBinding cloneable = astRoot.getAST().resolveWellKnownType("java.lang.Cloneable");
            if (Bindings.isSuperType((ITypeBinding)cloneable, (ITypeBinding)typeBinding)) {
                cloneMethod = OverrideMethodsOperation.resolveWellKnownCloneMethod(astRoot.getAST());
            }
            IPackageBinding pack = typeBinding.getPackage();
            IMethodBinding[] iMethodBindingArray = methods = StubUtility2Core.getOverridableMethods((AST)astRoot.getAST(), (ITypeBinding)typeBinding, (boolean)false);
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (Bindings.isVisibleInHierarchy((IMethodBinding)method, (IPackageBinding)pack)) {
                    boolean toImplement = Objects.equals(method, cloneMethod);
                    overridables.add(OverrideMethodsOperation.convertToSerializableMethod(method, toImplement));
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("List overridable methods", e);
        }
        return overridables;
    }

    public static TextEdit addOverridableMethods(IType type, OverridableMethod[] overridableMethods, IJavaElement insertPosition, IProgressMonitor monitor) {
        ITypeBinding typeBinding;
        CompilationUnit astRoot;
        block5: {
            if (type == null || type.getCompilationUnit() == null || overridableMethods == null || overridableMethods.length == 0) {
                return null;
            }
            astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot == null) {
                return null;
            }
            try {
                typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
                if (typeBinding != null) break block5;
                return null;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Add overridable methods", e);
                return null;
            }
        }
        IMethodBinding[] methodBindings = OverrideMethodsOperation.convertToMethodBindings(astRoot, typeBinding, overridableMethods);
        return OverrideMethodsOperation.createTextEditForOverridableMethods(type.getCompilationUnit(), astRoot, typeBinding, methodBindings, insertPosition);
    }

    /*
     * WARNING - void declaration
     */
    private static TextEdit createTextEditForOverridableMethods(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding typeBinding, IMethodBinding[] methodBindings, IJavaElement insertPosition) throws CoreException {
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
        ListRewrite listRewrite = null;
        ASTNode typeNode = astRoot.findDeclaringNode((IBinding)typeBinding);
        if (typeNode instanceof AnonymousClassDeclaration) {
            listRewrite = astRewrite.getListRewrite(typeNode, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
        } else {
            ASTNode aSTNode = typeNode;
            if (aSTNode instanceof AbstractTypeDeclaration) {
                void typeDeclaration;
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode;
                AbstractTypeDeclaration cfr_ignored_0 = (AbstractTypeDeclaration)aSTNode;
                listRewrite = astRewrite.getListRewrite(typeNode, typeDeclaration.getBodyDeclarationsProperty());
            } else {
                return null;
            }
        }
        CodeGenerationSettings settings = PreferenceManager.getCodeGenerationSettings(cu);
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(astRoot, typeNode.getStartPosition(), importRewrite);
        ASTNode insertion = StubUtility2Core.getNodeToInsertBefore((ListRewrite)listRewrite, (IJavaElement)insertPosition);
        IMethodBinding[] iMethodBindingArray = methodBindings;
        int n = methodBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            MethodDeclaration stub = StubUtility2Core.createImplementationStubCore((ICompilationUnit)cu, (ASTRewrite)astRewrite, (ImportRewrite)importRewrite, (ImportRewrite.ImportRewriteContext)context, (IMethodBinding)methodBinding, null, (ITypeBinding)typeBinding, (CodeGenerationSettings)settings, (boolean)typeBinding.isInterface(), (!typeBinding.isInterface() ? 1 : 0) != 0, (ASTNode)typeNode, (boolean)false);
            if (stub != null) {
                if (insertion != null) {
                    listRewrite.insertBefore((ASTNode)stub, insertion, null);
                } else {
                    listRewrite.insertLast((ASTNode)stub, null);
                }
            }
            ++n2;
        }
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild(importRewrite.rewriteImports(null));
        edit.addChild(astRewrite.rewriteAST());
        return edit;
    }

    private static IMethodBinding resolveWellKnownCloneMethod(AST ast) {
        IMethodBinding[] objectMethods;
        IMethodBinding[] iMethodBindingArray = objectMethods = ast.resolveWellKnownType("java.lang.Object").getDeclaredMethods();
        int n = objectMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.getName().equals("clone") && method.getParameterTypes().length == 0) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static IMethodBinding[] convertToMethodBindings(CompilationUnit astRoot, ITypeBinding typeBinding, OverridableMethod[] overridableMethods) {
        IMethodBinding[] methods;
        ArrayList<IMethodBinding> methodBindings = new ArrayList<IMethodBinding>();
        Set bindingKeys = Stream.of(overridableMethods).map(method -> method.bindingKey).collect(Collectors.toSet());
        IMethodBinding[] iMethodBindingArray = methods = StubUtility2Core.getOverridableMethods((AST)astRoot.getAST(), (ITypeBinding)typeBinding, (boolean)false);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method2 = iMethodBindingArray[n2];
            if (bindingKeys.contains(method2.getKey())) {
                methodBindings.add(method2);
            }
            ++n2;
        }
        return methodBindings.toArray(new IMethodBinding[0]);
    }

    private static OverridableMethod convertToSerializableMethod(IMethodBinding binding, boolean unimplemented) {
        OverridableMethod result = new OverridableMethod();
        result.bindingKey = binding.getKey();
        result.name = binding.getName();
        result.parameters = OverrideMethodsOperation.getMethodParameterTypes(binding, false);
        result.unimplemented = unimplemented || Modifier.isAbstract((int)binding.getModifiers());
        result.declaringClass = binding.getDeclaringClass().getQualifiedName();
        result.declaringClassType = binding.getDeclaringClass().isInterface() ? "interface" : "class";
        return result;
    }

    private static String[] getMethodParameterTypes(IMethodBinding binding, boolean qualifiedName) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        ITypeBinding[] iTypeBindingArray = binding.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type = iTypeBindingArray[n2];
            if (qualifiedName) {
                parameterTypes.add(type.getQualifiedName());
            } else {
                parameterTypes.add(type.getName());
            }
            ++n2;
        }
        return parameterTypes.toArray(new String[0]);
    }

    public static class OverridableMethod {
        public String bindingKey;
        public String name;
        public String[] parameters;
        public boolean unimplemented;
        public String declaringClass;
        public String declaringClassType;

        public OverridableMethod() {
        }

        public OverridableMethod(String bindingKey, String methodName, String[] methodParameters, boolean unimplemented, String declaringClass, String declaringClassType) {
            this.bindingKey = bindingKey;
            this.name = methodName;
            this.parameters = methodParameters;
            this.unimplemented = unimplemented;
            this.declaringClass = declaringClass;
            this.declaringClassType = declaringClassType;
        }
    }
}

