/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;

public class RenameHandler {
    private PreferenceManager preferenceManager;

    public static RenameOptions createOptions() {
        RenameOptions renameOptions = new RenameOptions();
        renameOptions.setPrepareProvider(Boolean.valueOf(true));
        return renameOptions;
    }

    public RenameHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public WorkspaceEdit rename(RenameParams params, IProgressMonitor monitor) {
        WorkspaceEdit edit = new WorkspaceEdit();
        if (!this.preferenceManager.getPreferences().isRenameEnabled()) {
            return edit;
        }
        try {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
            IJavaElement[] elements = JDTUtils.findElementsAtSelection((ITypeRoot)unit, params.getPosition().getLine(), params.getPosition().getCharacter(), this.preferenceManager, monitor);
            if (elements == null || elements.length == 0) {
                return edit;
            }
            IJavaElement curr = null;
            if (elements.length != 1) {
                IPackageFragment packageFragment = (IPackageFragment)unit.getParent();
                IJavaElement found = Stream.of(elements).filter(e -> e.equals(packageFragment)).findFirst().orElse(null);
                curr = found == null ? elements[0] : found;
            } else {
                curr = elements[0];
            }
            RenameSupport renameSupport = RenameSupport.create(curr, params.getNewName(), 1);
            if (renameSupport == null) {
                return edit;
            }
            RenameRefactoring renameRefactoring = renameSupport.getRenameRefactoring();
            CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)renameRefactoring, 6);
            CreateChangeOperation create = new CreateChangeOperation(check, 4);
            create.run(monitor);
            if (check.getStatus().getSeverity() >= 4) {
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidRequest, check.getStatus().getMessageMatchingSeverity(3), null));
            }
            Change change = create.getChange();
            return ChangeUtil.convertToWorkspaceEdit(change);
        }
        catch (CoreException ex) {
            JavaLanguageServerPlugin.logException("Problem with rename for " + params.getTextDocument().getUri(), ex);
            return edit;
        }
    }
}

