/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellMenuClickedRule
extends GenerationSimpleRule {
    private MenuItem item;

    @Override
    public boolean appliesTo(Event event) {
        boolean menu = event.widget instanceof MenuItem;
        int style = 0;
        if (menu) {
            MenuItem currentItem = (MenuItem)event.widget;
            Menu parent = null;
            while (currentItem != null && (parent = currentItem.getParent()) != null) {
                style = parent.getStyle();
                currentItem = parent.getParentItem();
            }
        }
        return event.type == 13 && menu && (style & 2) != 0;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.item = (MenuItem)event.widget;
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder code = new StringBuilder();
        ArrayList<String> path = new ArrayList<String>();
        path.add(this.item.getText());
        MenuItem currentItem = this.item;
        Menu parent = null;
        while (currentItem != null && (parent = currentItem.getParent()) != null) {
            currentItem = parent.getParentItem();
            if (currentItem == null || currentItem.getText() == null) continue;
            path.add(currentItem.getText());
        }
        Collections.reverse(path);
        code.append("bot");
        for (String text : path) {
            code.append(".menu(\"");
            code.append(text);
            code.append("\")");
        }
        code.append(".click()");
        actions.add(code.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }
}

