/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.InputStream;
import java.util.LinkedHashSet;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.web.project.facet.WebFragmentFacetInstallDataModelProvider;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.webfragment.WebFragmentQuickPeek;
import org.eclipse.m2e.wtp.internal.webfragment.WebFragmentUtil;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFragmentProjectConfigurator
extends AbstractProjectConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(WebFragmentProjectConfigurator.class);

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IProject project = facade.getProject();
        if (WTPProjectsUtil.isM2eWtpDisabled(facade, monitor) || !project.isAccessible() || project.getResourceAttributes().isReadOnly() || !WebFragmentUtil.isQualifiedAsWebFragment(facade)) {
            return;
        }
        IMavenMarkerManager mavenMarkerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        try {
            mavenMarkerManager.deleteMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.configuration");
            this.configureWebfragment(facade, monitor);
        }
        catch (CoreException cex) {
            mavenMarkerManager.addErrorMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.configuration", (Exception)((Object)cex));
        }
    }

    private void configureWebfragment(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        IFile webFragment = WebFragmentUtil.getWebFragment(facade);
        if (webFragment == null) {
            return;
        }
        IProjectFacetVersion facetVersion = this.getVersion(webFragment);
        if (facetVersion == null) {
            return;
        }
        IProject project = facade.getProject();
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        ResourceCleaner fileCleaner = new ResourceCleaner(project);
        this.addFoldersToClean(fileCleaner, facade);
        try {
            IProjectFacetVersion currentFacetVersion = facetedProject.getProjectFacetVersion(WTPProjectsUtil.WEB_FRAGMENT_FACET);
            IFacetedProject.Action.Type actionType = null;
            if (currentFacetVersion == null) {
                WTPProjectsUtil.removeConflictingFacets(facetedProject, facetVersion, actions);
                WTPProjectsUtil.installJavaFacet(actions, project, facetedProject);
                actionType = IFacetedProject.Action.Type.INSTALL;
            } else if (facetVersion.compareTo((Object)currentFacetVersion) > 0) {
                actionType = IFacetedProject.Action.Type.VERSION_CHANGE;
            }
            if (actionType != null) {
                IDataModel cfg = DataModelFactory.createDataModel((IDataModelProvider)new WebFragmentFacetInstallDataModelProvider());
                cfg.setProperty("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR", (Object)false);
                actions.add(new IFacetedProject.Action(actionType, facetVersion, (Object)cfg));
            }
            if (!actions.isEmpty()) {
                facetedProject.modify(actions, monitor);
            }
        }
        finally {
            try {
                fileCleaner.cleanUp();
            }
            catch (CoreException cex) {
                LOG.error(Messages.Error_Cleaning_WTP_Files, (Throwable)cex);
            }
        }
        WTPProjectsUtil.removeTestFolderLinks(project, facade.getMavenProject(), monitor, "/");
        WTPProjectsUtil.setNonDependencyAttributeToContainer(project, monitor);
    }

    private IProjectFacetVersion getVersion(IFile webFragment) {
        InputStream in;
        block4: {
            IProjectFacetVersion iProjectFacetVersion;
            in = null;
            try {
                webFragment.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                in = webFragment.getContents();
                WebFragmentQuickPeek peek = new WebFragmentQuickPeek(in);
                String version = peek.getVersion();
                if (version == null) break block4;
                iProjectFacetVersion = WTPProjectsUtil.WEB_FRAGMENT_FACET.getVersion(version);
            }
            catch (Exception e) {
                IProjectFacetVersion iProjectFacetVersion2;
                try {
                    LOG.error("Error_Reading_WebFragment", (Throwable)e);
                    iProjectFacetVersion2 = WTPProjectsUtil.WEB_FRAGMENT_FACET.getDefaultVersion();
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close((InputStream)in);
                return iProjectFacetVersion2;
            }
            IOUtil.close((InputStream)in);
            return iProjectFacetVersion;
        }
        IOUtil.close((InputStream)in);
        return null;
    }

    protected void addFoldersToClean(ResourceCleaner fileCleaner, IMavenProjectFacade facade) {
        for (IPath p : facade.getCompileSourceLocations()) {
            if (p == null) continue;
            fileCleaner.addFiles(p.append("META-INF/MANIFEST.MF"));
            fileCleaner.addFiles(p.append("META-INF/web-fragment.xml"));
            fileCleaner.addFolder(p);
        }
        for (IPath p : facade.getResourceLocations()) {
            if (p == null) continue;
            fileCleaner.addFiles(p.append("META-INF/MANIFEST.MF"));
            fileCleaner.addFiles(p.append("META-INF/web-fragment.xml"));
            fileCleaner.addFolder(p);
        }
        for (IPath p : facade.getTestCompileSourceLocations()) {
            if (p == null) continue;
            fileCleaner.addFolder(p);
        }
        for (IPath p : facade.getTestResourceLocations()) {
            if (p == null) continue;
            fileCleaner.addFolder(p);
        }
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }
}

