/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.wizards;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.rpm.core.utils.BufferedProcessInputStream;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.linuxtools.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SpecfileNewWizardPage
extends WizardPage {
    private static final String NAME = "package_name";
    private static final String VERSION = "1.0";
    private static final String SUMMARY = "Summary of the package";
    private static final String GROUP = "Amusements/Games";
    private static final String LICENSE = "GPL";
    private static final String URL = "http://";
    private static final String SOURCE0 = "archive_name-%{version}";
    private Text projectText;
    private Text nameText;
    private Text versionText;
    private Text summaryText;
    private Combo groupCombo;
    private Text licenseText;
    private Text urlText;
    private Text source0Text;
    private GridData gd;
    private Combo templateCombo;
    private ISelection selection;
    private String selectedTemplate = "minimal";
    private String content;

    public SpecfileNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.SpecfileNewWizardPage_9);
        this.setDescription(Messages.SpecfileNewWizardPage_10);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.SpecfileNewWizardPage_11);
        this.projectText = new Text(container, 2052);
        this.gd = new GridData(768);
        this.projectText.setLayoutData((Object)this.gd);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpecfileNewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.SpecfileNewWizardPage_12);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpecfileNewWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.SpecfileNewWizardPage_13);
        this.templateCombo = new Combo(container, 0);
        try {
            this.populateTemplateCombo(this.templateCombo);
        }
        catch (CoreException e2) {
            SpecfileLog.logError(e2);
        }
        label = new Label(container, 0);
        this.templateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpecfileNewWizardPage.this.selectedTemplate = ((Combo)e.getSource()).getText();
                BufferedInputStream inputStream = SpecfileNewWizardPage.this.runRpmdevNewSpec(SpecfileNewWizardPage.this.selectedTemplate);
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream));
                try {
                    String line;
                    SpecfileNewWizardPage.this.content = "";
                    SpecfileNewWizardPage.this.setDefaultValues();
                    while ((line = reader.readLine()) != null) {
                        String[] items;
                        String value;
                        if (line.startsWith("Name:")) {
                            SpecfileNewWizardPage.this.setTemplateTagValue(SpecfileNewWizardPage.this.nameText, line);
                        }
                        if (line.startsWith("Version:")) {
                            SpecfileNewWizardPage.this.setTemplateTagValue(SpecfileNewWizardPage.this.versionText, line);
                        }
                        if (line.startsWith("Summary:")) {
                            SpecfileNewWizardPage.this.setTemplateTagValue(SpecfileNewWizardPage.this.summaryText, line);
                        }
                        if (line.startsWith("Group:") && !(value = (items = line.split(":", 2))[1].trim()).equals("")) {
                            SpecfileNewWizardPage.this.groupCombo.setText(value);
                        }
                        if (line.startsWith("License:")) {
                            SpecfileNewWizardPage.this.setTemplateTagValue(SpecfileNewWizardPage.this.licenseText, line);
                        }
                        if (line.startsWith("URL:")) {
                            SpecfileNewWizardPage.this.setTemplateTagValue(SpecfileNewWizardPage.this.urlText, line);
                        }
                        if (line.startsWith("Source0:")) {
                            SpecfileNewWizardPage.this.setTemplateTagValue(SpecfileNewWizardPage.this.source0Text, line);
                        }
                        SpecfileNewWizardPage specfileNewWizardPage = SpecfileNewWizardPage.this;
                        specfileNewWizardPage.content = String.valueOf(specfileNewWizardPage.content) + line + '\n';
                    }
                }
                catch (IOException e1) {
                    SpecfileLog.logError(e1);
                }
            }
        });
        this.nameText = this.setTextItem(container, Messages.SpecfileNewWizardPage_14);
        this.versionText = this.setTextItem(container, Messages.SpecfileNewWizardPage_15);
        this.summaryText = this.setTextItem(container, Messages.SpecfileNewWizardPage_16);
        label = new Label(container, 0);
        label.setText(Messages.SpecfileNewWizardPage_17);
        this.groupCombo = new Combo(container, 0);
        this.populateGroupCombo(this.groupCombo);
        new Label(container, 0);
        this.licenseText = this.setTextItem(container, Messages.SpecfileNewWizardPage_18);
        this.urlText = this.setTextItem(container, Messages.SpecfileNewWizardPage_19);
        this.source0Text = this.setTextItem(container, Messages.SpecfileNewWizardPage_20);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private Text setTextItem(Composite container, String textLabel) {
        Label label = new Label(container, 0);
        label.setText(textLabel);
        Text text = new Text(container, 2052);
        text.setLayoutData((Object)this.gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpecfileNewWizardPage.this.dialogChanged();
            }
        });
        new Label(container, 0);
        return text;
    }

    private void setTemplateTagValue(Text text, String line) {
        String[] items = line.split(":", 2);
        String value = items[1].trim();
        if (!value.equals("")) {
            text.setText(value);
        }
    }

    public String getProjectName() {
        return this.projectText.getText();
    }

    public String getFileName() {
        return String.valueOf(this.nameText.getText()) + ".spec";
    }

    public String getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public String getContent() {
        BufferedInputStream inputStream = this.runRpmdevNewSpec(this.selectedTemplate);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream));
        try {
            String line;
            this.content = "";
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Name:")) {
                    line = "Name:           " + this.nameText.getText();
                }
                if (line.startsWith("Version:")) {
                    line = "Version:        " + this.versionText.getText();
                }
                if (line.startsWith("Summary:")) {
                    line = "Summary:        " + this.summaryText.getText();
                }
                if (line.startsWith("Group:")) {
                    line = "Group:          " + this.groupCombo.getText();
                }
                if (line.startsWith("License:")) {
                    line = "License:        " + this.licenseText.getText();
                }
                if (line.startsWith("URL:")) {
                    line = "URL:            " + this.urlText.getText();
                }
                if (line.startsWith("Source0:")) {
                    line = "Source0:        " + this.source0Text.getText();
                }
                this.content = String.valueOf(this.content) + line + '\n';
            }
        }
        catch (IOException e1) {
            SpecfileLog.logError(e1);
        }
        return this.content;
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.projectText.setText(container.getFullPath().toString());
            }
        }
        this.setDefaultValues();
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.SpecfileNewWizardPage_21);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.projectText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getProjectName()));
        String fileName = this.getFileName();
        if (this.getProjectName().length() == 0) {
            this.updateStatus(Messages.SpecfileNewWizardPage_22);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.SpecfileNewWizardPage_23);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.SpecfileNewWizardPage_24);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.SpecfileNewWizardPage_25);
            return;
        }
        String packageName = this.nameText.getText();
        if (packageName.indexOf(" ") != -1 || packageName.indexOf("<") != -1 || packageName.indexOf(">") != -1 || packageName.indexOf("=") != -1) {
            this.updateStatus(String.valueOf(Messages.SpecfileNewWizardPage_26) + Messages.SpecfileNewWizardPage_27);
            return;
        }
        if (this.versionText.getText().indexOf("-") > -1) {
            this.updateStatus(Messages.SpecfileNewWizardPage_28);
            return;
        }
        this.updateStatus(null);
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void setDefaultValues() {
        this.nameText.setText(NAME);
        this.versionText.setText(VERSION);
        this.summaryText.setText(SUMMARY);
        this.groupCombo.setText(GROUP);
        this.licenseText.setText(LICENSE);
        this.urlText.setText(URL);
        this.source0Text.setText(SOURCE0);
    }

    private void populateTemplateCombo(Combo templateCombo) throws CoreException {
        File dir = new File("/etc/rpmdevtools");
        String[] files = dir.list();
        if (dir.exists()) {
            String[] templates;
            String templateCSV = "";
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.startsWith("spectemplate-")) {
                    templateCSV = String.valueOf(templateCSV) + file.split("-", 2)[1].replaceAll("\\.spec", "") + ",";
                }
                ++n2;
            }
            String[] stringArray2 = templates = templateCSV.split(",");
            int n3 = templates.length;
            n = 0;
            while (n < n3) {
                String template = stringArray2[n];
                templateCombo.add(template);
                ++n;
            }
            templateCombo.setText(this.selectedTemplate);
        } else {
            this.throwCoreException(Messages.SpecfileNewWizardPage_29);
        }
    }

    private void populateGroupCombo(Combo groupsCombo) {
        List<String> rpmGroups = Activator.getDefault().getRpmGroups();
        for (String rpmGroup : rpmGroups) {
            groupsCombo.add(rpmGroup);
        }
    }

    private BufferedInputStream runRpmdevNewSpec(String template) {
        BufferedProcessInputStream in = null;
        try {
            in = Utils.runCommandToInputStream((String[])new String[]{"rpmdev-newspec", "-o", "-", "-t", template});
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
        }
        return in;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.linuxtools.rpm.ui.editor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public Text getNameText() {
        return this.nameText;
    }

    public Text getProjectText() {
        return this.projectText;
    }

    public Text getVersionText() {
        return this.versionText;
    }

    public Text getUrlText() {
        return this.urlText;
    }

    public Text getLicenseText() {
        return this.licenseText;
    }

    public Text getSourceText() {
        return this.source0Text;
    }

    public Text getSummaryText() {
        return this.summaryText;
    }
}

