/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceRegistration;
import org.eclipse.virgo.teststubs.osgi.internal.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public final class StubServiceReference<S>
implements ServiceReference<S> {
    private static final Long DEFAULT_SERVICE_ID = 1L;
    private static final Integer DEFAULT_SERVICE_RANKING = 0;
    private final Long serviceId;
    private final Integer serviceRanking;
    private final StubServiceRegistration<S> serviceRegistration;
    private volatile StubBundle bundle;
    private final Object bundleMonitor = new Object();
    private final List<StubBundle> usingBundles = new ArrayList<StubBundle>();
    private final Object usingBundlesMonitor = new Object();
    private final Map<Bundle, List<String>> assignableTo = new HashMap<Bundle, List<String>>();
    private final Object assignableToMonitor = new Object();

    public StubServiceReference(StubServiceRegistration<S> serviceRegistration) {
        this(DEFAULT_SERVICE_ID, DEFAULT_SERVICE_RANKING, serviceRegistration);
    }

    public StubServiceReference(Long serviceId, Integer serviceRanking, StubServiceRegistration<S> serviceRegistration) {
        Assert.assertNotNull(serviceId, "serviceId");
        Assert.assertNotNull(serviceRanking, "serviceRanking");
        Assert.assertNotNull(serviceRegistration, "serviceRegistration");
        this.serviceId = serviceId;
        this.serviceRanking = serviceRanking;
        this.serviceRegistration = serviceRegistration;
        this.serviceRegistration.setServiceReference(this);
        this.bundle = serviceRegistration.getBundleContext().getContextBundle();
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public Integer getServiceRanking() {
        return this.serviceRanking;
    }

    public StubServiceRegistration<S> getServiceRegistration() {
        return this.serviceRegistration;
    }

    public int compareTo(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        if (!(reference instanceof StubServiceReference)) {
            throw new IllegalArgumentException("input must be StubServiceReference");
        }
        StubServiceReference other = (StubServiceReference)reference;
        int idComparison = this.serviceId.compareTo(other.serviceId);
        int rankingComparison = this.serviceRanking.compareTo(other.serviceRanking);
        if (this.serviceId.equals(other.serviceId)) {
            return 0;
        }
        if (rankingComparison != 0) {
            return rankingComparison;
        }
        return idComparison;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getBundle() {
        Object object = this.bundleMonitor;
        synchronized (object) {
            return this.bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubServiceReference<S> setBundle(StubBundle bundle) {
        Object object = this.bundleMonitor;
        synchronized (object) {
            this.bundle = bundle;
            return this;
        }
    }

    public Object getProperty(String key) {
        return this.serviceRegistration.getProperties().get(key);
    }

    public String[] getPropertyKeys() {
        ArrayList<String> properties = new ArrayList<String>();
        Enumeration<String> keys = this.serviceRegistration.getProperties().keys();
        while (keys.hasMoreElements()) {
            properties.add(keys.nextElement());
        }
        return properties.toArray(new String[properties.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getUsingBundles() {
        Object object = this.usingBundlesMonitor;
        synchronized (object) {
            block4: {
                if (!this.usingBundles.isEmpty()) break block4;
                return null;
            }
            return this.usingBundles.toArray(new Bundle[this.usingBundles.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubServiceReference<S> addUsingBundles(StubBundle ... bundles) {
        Object object = this.usingBundlesMonitor;
        synchronized (object) {
            this.usingBundles.addAll((Collection<StubBundle>)Arrays.asList(bundles));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubServiceReference<S> removeUsingBundles(StubBundle ... bundles) {
        Object object = this.usingBundlesMonitor;
        synchronized (object) {
            this.usingBundles.removeAll((Collection)Arrays.asList(bundles));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssignableTo(Bundle bundle, String className) {
        Object object = this.assignableToMonitor;
        synchronized (object) {
            block4: {
                if (this.assignableTo.containsKey(bundle)) break block4;
                return false;
            }
            return this.assignableTo.get(bundle).contains(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubServiceReference<S> putAssignableTo(Bundle bundle, String ... classNames) {
        Object object = this.assignableToMonitor;
        synchronized (object) {
            this.assignableTo.put(bundle, Arrays.asList(classNames));
            return this;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.serviceRegistration.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StubServiceReference other = (StubServiceReference)obj;
        return this.serviceRegistration.equals(other.serviceRegistration);
    }

    public String toString() {
        return String.format("id: %d, ranking: %d", this.serviceId, this.serviceRanking);
    }
}

