/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine.phases;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.prov.engine.TouchpointManager;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.download.DownloadManager;
import org.eclipse.equinox.prov.engine.EngineSession;
import org.eclipse.equinox.prov.engine.ITouchpoint;
import org.eclipse.equinox.prov.engine.ITouchpointAction;
import org.eclipse.equinox.prov.engine.IUPhase;
import org.eclipse.equinox.prov.engine.Operand;
import org.eclipse.equinox.prov.engine.Profile;
import org.eclipse.equinox.prov.engine.phases.Messages;
import org.eclipse.equinox.prov.metadata.IResolvedInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class Collect
extends IUPhase {
    private static final String PHASE_ID = "collect";
    protected Map parameters = new HashMap();

    public Collect(int weight) {
        super(PHASE_ID, weight, Messages.Engine_Collect_Phase);
        this.PRE_PERFORM_WORK = 0;
        this.PERFORM_WORK = 100;
        this.POST_PERFORM_WORK = 1000;
    }

    protected IStatus performOperand(EngineSession session, Profile profile, Operand operand, IProgressMonitor monitor) {
        IResolvedInstallableUnit unit = operand.second();
        if (unit != null) {
            monitor.subTask(NLS.bind((String)Messages.Engine_Collecting_For_IU, (Object)unit.getId()));
            ITouchpoint touchpoint = TouchpointManager.getInstance().getTouchpoint(unit.getTouchpointType());
            if (touchpoint.supports(PHASE_ID)) {
                ITouchpointAction[] actions = touchpoint.getActions(PHASE_ID, profile, operand);
                int i = 0;
                while (i < actions.length) {
                    IStatus result = actions[i].execute(this.parameters);
                    if (!result.isOK()) {
                        return result;
                    }
                    session.record(actions[i]);
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    protected void postPerform(MultiStatus status, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
        DownloadManager dm = (DownloadManager)this.parameters.get("downloadManager");
        status.add(dm.start(monitor));
    }

    protected void prePerform(MultiStatus status, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
        this.parameters.put("downloadManager", new DownloadManager());
    }

    protected boolean isApplicable(Operand op) {
        return op.second() != null;
    }
}

