/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.simpleconfigurator.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;
import org.eclipse.equinox.simpleconfigurator.internal.SimpleConfiguratorImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

class ConfigApplier {
    private BundleContext manipulatingContext;
    private PackageAdmin adminService = null;
    private StartLevel startLevelService = null;
    private final boolean runningOnEquinox;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    ConfigApplier(BundleContext context, SimpleConfiguratorImpl configurator) {
        ServiceReference startLevelRef;
        ServiceReference packageAdminRef;
        this.manipulatingContext = context;
        this.runningOnEquinox = "Eclipse".equals(context.getProperty("org.osgi.framework.vendor"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((packageAdminRef = this.manipulatingContext.getServiceReference(clazz.getName())) == null) {
            throw new IllegalStateException("No PackageAdmin service is available.");
        }
        this.adminService = (PackageAdmin)this.manipulatingContext.getService(packageAdminRef);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((startLevelRef = this.manipulatingContext.getServiceReference(clazz2.getName())) == null) {
            throw new IllegalStateException("No StartLevelService service is available.");
        }
        this.startLevelService = (StartLevel)this.manipulatingContext.getService(startLevelRef);
    }

    void install(BundleInfo[] expectedState, boolean uninstall) {
        ArrayList toRefresh = new ArrayList();
        ArrayList toStart = new ArrayList();
        toRefresh.addAll(this.installBundles(expectedState, toStart));
        if (uninstall) {
            toRefresh.addAll(this.uninstallBundles(expectedState, this.adminService));
        }
        this.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]), this.manipulatingContext);
        this.startBundles(toStart.toArray(new Bundle[toStart.size()]));
    }

    private ArrayList installBundles(BundleInfo[] finalList, Collection toStart) {
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        boolean useReference = Boolean.valueOf(this.manipulatingContext.getProperty("org.eclipse.equinox.simpleconfigurator.useReference"));
        int i = 0;
        while (i < finalList.length) {
            block14: {
                int startLevel;
                Bundle current;
                Bundle[] matches = null;
                Dictionary manifest = Utils.getOSGiManifest(finalList[i].getLocation());
                String symbolicName = null;
                try {
                    symbolicName = (String)manifest.get("Bundle-SymbolicName");
                }
                catch (RuntimeException re) {
                    System.err.println("cannot get Manifest :" + finalList[i]);
                    throw re;
                }
                if (symbolicName != null && symbolicName.indexOf(";") != -1) {
                    symbolicName = symbolicName.substring(0, symbolicName.indexOf(";")).trim();
                }
                String version = (String)manifest.get("Bundle-Version");
                if (symbolicName != null && version != null) {
                    matches = this.adminService.getBundles(symbolicName, version);
                }
                Bundle bundle = matches == null ? null : (current = matches.length == 0 ? null : matches[0]);
                if (current == null) {
                    try {
                        String location = finalList[i].getLocation();
                        if (location == null) break block14;
                        if (this.runningOnEquinox && useReference && location.startsWith("file:")) {
                            location = "reference:" + location;
                        }
                        current = this.manipulatingContext.installBundle(location);
                        installed.add(current);
                    }
                    catch (BundleException e) {
                        System.err.println("Can't install " + symbolicName + "/" + version + " from location " + finalList[i].getLocation());
                        e.printStackTrace();
                        break block14;
                    }
                }
                if ((startLevel = finalList[i].getStartLevel()) != -1 && current.getBundleId() != 0L) {
                    String name = current.getSymbolicName();
                    try {
                        if (startLevel > 0 && !"org.eclipse.equinox.simpleconfigurator".equals(name)) {
                            this.startLevelService.setBundleStartLevel(current, startLevel);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println("fail to set start level of Bundle:" + finalList[i]);
                        ex.printStackTrace();
                    }
                }
                if (finalList[i].isMarkedAsStarted()) {
                    toStart.add(current);
                }
            }
            ++i;
        }
        return installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshPackages(Bundle[] bundles, BundleContext manipulatingContext) {
        if (bundles.length == 0) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        ServiceReference packageAdminRef = manipulatingContext.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)manipulatingContext.getService(packageAdminRef)) == null) {
            return;
        }
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        manipulatingContext.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (true) {
                if (flag[0]) {
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    break;
                }
                try {
                    flag.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            manipulatingContext.removeFrameworkListener(listener);
            manipulatingContext.ungetService(packageAdminRef);
            return;
        }
    }

    private void startBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if (bundle.getState() != 8) {
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private Collection uninstallBundles(BundleInfo[] finalList, PackageAdmin adminService) {
        Bundle[] allBundles = this.manipulatingContext.getBundles();
        HashSet<Bundle> installedBundles = new HashSet<Bundle>(allBundles.length);
        int i = 0;
        while (i < allBundles.length) {
            if (allBundles[i].getBundleId() != 0L) {
                installedBundles.add(allBundles[i]);
            }
            ++i;
        }
        i = 0;
        while (i < finalList.length) {
            Bundle[] toAdd = adminService.getBundles(finalList[i].getSymbolicName(), finalList[i].getVersion());
            int j = 0;
            while (toAdd != null && j < toAdd.length) {
                installedBundles.remove(toAdd[j]);
                ++j;
            }
            ++i;
        }
        Iterator iter = installedBundles.iterator();
        while (iter.hasNext()) {
            try {
                Bundle bundle = (Bundle)iter.next();
                bundle.uninstall();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        return installedBundles;
    }
}

