/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.tests.ccvs.core;

import java.lang.reflect.InvocationTargetException;
import java.util.*;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.*;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RLog;
import org.eclipse.team.internal.ccvs.core.client.Command.LocalOption;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.ui.IWorkbenchPart;

public class FindCommittersTest extends EclipseTest {

	public class FindCommittersOperation extends RemoteLogOperation {
		private LogEntryCache cache;
		private Set authors;

		public FindCommittersOperation(IWorkbenchPart part,
				ICVSRemoteResource[] remoteResources, CVSTag tag1, CVSTag tag2,
				LogEntryCache cache) {
			super(part, remoteResources, tag1, tag2, cache);
			this.cache = cache;
		}

		protected LocalOption[] getLocalOptions(CVSTag tag1, CVSTag tag2) {
			return new Command.LocalOption[] {RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.REVISIONS_ON_DEFAULT_BRANCH, new LocalOption("-d" + tag1.asDate() + "<" + tag2.asDate().toString(), null) {
				
			}};
		}
		protected void execute(ICVSRepositoryLocation location,
				ICVSRemoteResource[] remoteResources, IProgressMonitor monitor)
				throws CVSException {
			super.execute(location, remoteResources, monitor);
			processAuthors();
		}

		private void processAuthors() {
			authors = getAuthors(cache);
		}
		
		private Set getAuthors(RemoteLogOperation.LogEntryCache logEntryCache) {
			String[] paths = logEntryCache.getCachedFilePaths();
			Set authors = new HashSet();
			for (int i = 0; i < paths.length; i++) {
				String path = paths[i];
				ILogEntry[] entries = logEntryCache.getLogEntries(path);
				for (int j = 0; j < entries.length; j++) {
					ILogEntry entry = entries[j];
					authors.add(entry.getAuthor());
				}
			}
			return authors;
		}

		public Set getAuthors() {
			return authors;
		}
	}
	
	/**
	 * Constructor for CVSProviderTest
	 */
	public FindCommittersTest() {
		super();
	}

	/**
	 * Constructor for CVSProviderTest
	 */
	public FindCommittersTest(String name) {
		super(name);
	}

	public static Test suite() {
		return new TestSuite(FindCommittersTest.class);
	}
	
	public void testFetchLogs() throws CVSException, InvocationTargetException, InterruptedException {
		CVSRepositoryLocation location = CVSRepositoryLocation.fromString(":pserver:anonymous@dev.eclipse.org:/cvsroot/eclipse");
		ICVSRemoteResource[] members = location.members(null, false, DEFAULT_MONITOR);
		Set authors = fetchLogs(members);
		for (Iterator iterator = authors.iterator(); iterator.hasNext();) {
			String name = (String) iterator.next();
			System.out.println(name);
		}
		
	}

	private Set fetchLogs(
			ICVSRemoteResource[] members) throws InvocationTargetException,
			InterruptedException {
		CVSTag tag1 = new CVSTag(new Date(101, 10, 07));
		CVSTag tag2 = new CVSTag(new Date());
		RemoteLogOperation.LogEntryCache logEntryCache = new RemoteLogOperation.LogEntryCache();
		FindCommittersOperation op = new FindCommittersOperation(null, members, tag1, tag2, logEntryCache);
		op.run(DEFAULT_MONITOR);
		return op.getAuthors();
	}
	
}
