/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;

class NonExtractableStatementFinder
extends ASTVisitor {
    private boolean containsContinueStmt;
    private boolean containsBreakStmt;

    NonExtractableStatementFinder() {
        this.shouldVisitStatements = true;
    }

    public int visit(IASTStatement statement) {
        if (statement instanceof IASTContinueStatement) {
            this.containsContinueStmt = true;
            return 1;
        }
        if (statement instanceof IASTBreakStatement) {
            this.containsBreakStmt = true;
            return 1;
        }
        if (statement instanceof IASTForStatement || statement instanceof ICPPASTRangeBasedForStatement || statement instanceof IASTWhileStatement || statement instanceof IASTDoStatement || statement instanceof IASTSwitchStatement) {
            return 1;
        }
        return 3;
    }

    public boolean containsContinue() {
        return this.containsContinueStmt;
    }

    public boolean containsBreak() {
        return this.containsBreakStmt;
    }
}

